/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.internal.jms;

import com.google.common.collect.ImmutableList;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SecureObjectInputStream
extends ObjectInputStream {
    private static final Log LOGGER = LogFactory.getInstance(SecureObjectInputStream.class);
    private static final String KEY_SECURE_CLASS = "deserialization.secure.class";
    private static final String KEY_SECURE_PACKAGE = "deserialization.secure.package";
    private List<String> secureClassList = ImmutableList.of((Object)"com.huawei.lego.comm.internal.jms.MessageUnit", (Object)"com.huawei.lego.comm.internal.jms.MessageTopic", (Object)"java.io.Serializable.OpenStackStoragePoolRemoteDevInfo", (Object)"java.sql.Timestamp", (Object)"[B", (Object)"[Ljava.lang.String;");
    private List<String> securePackageList = ImmutableList.of((Object)"com.huawei.lego.nem.fault.sdk.model", (Object)"com.huawei.lego.cbb.resource.sdk.model", (Object)"com.huawei.lego.nem.discover.sdk.model", (Object)"com.huawei.lego.com.south.sdk.model", (Object)"com.huawei.lego.cbb.backtask.sdk.model", (Object)"com.huawei.ism.drm.openstack.sdk.model", (Object)"com.huawei.ism.drm.openstack.sdk.msg", (Object)"com.huawei.ism.drm.common.sdk.model", (Object)"com.huawei.ism.drm.drp.sdk.model", (Object)"com.huawei.ism.drm.system.info.sdk.model", (Object)"com.huawei.ism.drm.report.sdk.model", (Object)"com.huawei.ism.drm.protection", (Object[])new String[]{"com.huawei.ism.drm.openstack.model", "com.huawei.ism.drm.site.sdk.model", "com.huawei.ism.drm.galax.sdk.model", "com.huawei.ism.base.sdk.model", "org.hibernate.collection.internal", "java.util", "java.lang"});
    private long configUpdateTime = 0L;
    private ClassLoader classLoader;

    public SecureObjectInputStream(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public SecureObjectInputStream(InputStream inputStream, ClassLoader classLoader) throws IOException {
        super(inputStream);
        this.classLoader = classLoader;
    }

    protected SecureObjectInputStream() throws IOException, SecurityException {
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        this.reloadProperties();
        boolean isClassSecure = this.secureClassList.stream().anyMatch(className -> className.equals(desc.getName()));
        if (!(isClassSecure |= this.securePackageList.stream().anyMatch(packageName -> desc.getName().startsWith((String)packageName)))) {
            LOGGER.error((Object)("ResolveClass failed. cause " + desc.getName() + " is not secure Class"));
            throw new ClassNotFoundException("ResolveClass failed. cause " + desc.getName() + " is not secure Class");
        }
        try {
            return super.resolveClass(desc);
        }
        catch (ClassNotFoundException e) {
            return Class.forName(desc.getName(), true, this.classLoader);
        }
    }

    private void reloadProperties() {
        List<String> securePackageConfigList;
        if (this.configUpdateTime >= LegoConfig.getInstance().getUpdateTime()) {
            return;
        }
        List<String> secureClassConfigList = this.getSecureConfigList(KEY_SECURE_CLASS);
        if (!secureClassConfigList.isEmpty()) {
            this.secureClassList = secureClassConfigList;
        }
        if (!(securePackageConfigList = this.getSecureConfigList(KEY_SECURE_PACKAGE)).isEmpty()) {
            this.securePackageList = securePackageConfigList;
        }
        this.configUpdateTime = LegoConfig.getInstance().getUpdateTime();
    }

    private List<String> getSecureConfigList(String key) {
        String secureValue = LegoConfig.getInstance().getKeyValue(key);
        if (VerifyUtil.isEmpty((String)secureValue)) {
            LOGGER.info((Object)"Key:%s of legoConfig is empty", new Object[]{key});
            return Collections.emptyList();
        }
        LOGGER.info((Object)"Key:%s of legoConfig read success", new Object[]{key});
        return Arrays.asList(secureValue.split(","));
    }
}

