/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.comm.internal.jms.messagemanager;

import com.huawei.lego.comm.internal.jms.messagecodebase.CommandCodeBase;
import com.huawei.lego.comm.internal.jms.messagemanager.MessageCollecter;
import com.huawei.lego.comm.internal.jms.util.ClassFiler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Locale;

public class MessageClassFilterLoader
extends ClassLoader {
    private static final Log LOGGER = LogFactory.getInstance(MessageClassFilterLoader.class);
    private static final String MESSAGEBASENAME = CommandCodeBase.class.getName();
    private static int count = 0;
    private ClassFiler cf = null;
    private MessageCollecter mc = null;

    private static void increaseCount() {
        ++count;
    }

    private static void decreaseCount() {
        --count;
    }

    public void setMc(MessageCollecter mc) {
        this.mc = mc;
    }

    public void setClassFiler(ClassFiler cfilter) {
        this.cf = cfilter;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String supername;
        MessageClassFilterLoader.increaseCount();
        if (2 == count) {
            ClassFiler classFiler = this.cf = null == this.mc ? null : this.mc.checkClassExist(name);
        }
        if (2 < count || null == this.cf) {
            throw new ClassNotFoundException();
        }
        byte[] bs = this.cf.getFileData();
        Class<?> clazz = this.defineClass(name, bs, 0, bs.length);
        MessageClassFilterLoader.decreaseCount();
        if (MESSAGEBASENAME.equals(name)) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "The messagecode's base class's name is \uff1a--%s.", name), 1L);
            return clazz;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (null != superclass && MESSAGEBASENAME.equals(supername = superclass.getName())) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "The CommandCodeBase's child class's name is \uff1a--%s.", name), 1L);
            return clazz;
        }
        throw new ClassNotFoundException();
    }
}

