/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.confmgr;

import com.huawei.lego.core.base.confmgr.EntryProcessor;
import com.huawei.lego.core.base.confmgr.ParserCreator;
import com.huawei.lego.core.base.service.IAnalyzer;
import com.huawei.lego.core.base.service.IParser;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Map;
import java.util.Properties;

public class ExternalAnalyzer
implements IAnalyzer {
    private static final Log LOGGER = LogFactory.getInstance(ExternalAnalyzer.class);
    private ParserCreator parserCreator;
    private EntryProcessor processor;

    public void setProcessor(EntryProcessor processor) {
        this.processor = processor;
    }

    public void setParserCreator(ParserCreator parserCreator) {
        this.parserCreator = parserCreator;
    }

    @Override
    public void analyze(Properties extensionPoints) {
        for (Map.Entry<Object, Object> entry : extensionPoints.entrySet()) {
            String type = (String)entry.getValue();
            IParser parser = this.parserCreator.createParser(type, this.processor);
            if (parser != null) {
                parser.parse(type);
                continue;
            }
            LOGGER.info((Object)"Parser is null,type:%s.", new Object[]{type});
        }
    }
}

