/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.confmgr;

import com.huawei.lego.core.base.confmgr.EntryProcessor;
import com.huawei.lego.core.base.confmgr.parser.XmlConfigParser;
import com.huawei.lego.core.base.service.DefaultProcessEntry;
import com.huawei.lego.core.base.service.IParser;
import com.huawei.lego.core.base.service.IProcessEntry;
import com.huawei.lego.core.sdk.file.util.AdapterUtils;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ParserCreator {
    private static final Log LOG = LogFactory.getInstance(ParserCreator.class);
    private Map<String, IParser> parsers = new HashMap<String, IParser>();
    private Map<String, IProcessEntry> entries = new HashMap<String, IProcessEntry>();
    private Map<String, String> entryConfig;

    public void setEntryConfig(Map<String, String> entryConfig) {
        this.entryConfig = entryConfig;
    }

    public void initProcessEntry(String type) {
        try {
            if (!this.entryConfig.containsKey(type)) {
                return;
            }
            String path = this.entryConfig.get(type);
            Properties p = new Properties();
            URL url = ParserCreator.class.getResource(path);
            if (url == null) {
                LOG.error((Object)"Get resource from bundle error!", 1L);
                return;
            }
            p.load(url.openStream());
            Object[] entriesParam = p.values().toArray();
            this.initProcessEntry(type, p, entriesParam);
        }
        catch (IOException e) {
            LOG.error((Object)e, 1L);
        }
        catch (InstantiationException e) {
            LOG.error((Object)e, 1L);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)e, 1L);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
    }

    private void initProcessEntry(String type, Properties p, Object[] entriesParam) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        if (entriesParam.length <= 0) {
            LOG.info((Object)"EntriesParam is empty,type:%s", new Object[]{type});
        }
        IProcessEntry current = null;
        for (int i = 1; i <= entriesParam.length; ++i) {
            String clazz = p.getProperty(String.valueOf(i));
            IProcessEntry temp = (IProcessEntry)Class.forName(clazz).newInstance();
            if (current != null) {
                ((DefaultProcessEntry)current).setNextParser(temp);
                current = temp;
                continue;
            }
            current = temp;
            this.entries.put(type, current);
            LOG.info((Object)"Put IProcessEntry into entries,type:%s.", new Object[]{type});
        }
    }

    public IParser createParser(String type, EntryProcessor processor) {
        IParser parser = null;
        this.initProcessEntry(type);
        if (!this.parsers.containsKey(type)) {
            if (this.entries != null && this.entries.containsKey(type)) {
                IProcessEntry entry = this.entries.get(type);
                if (type.equals("com.huawei.lego.core.domain")) {
                    parser = new XmlConfigParser(AdapterUtils.getAllClassPathEntries((String)"domain/*-domain-model.xml"), processor, entry);
                    this.parsers.put(type, parser);
                }
            } else {
                LOG.info((Object)"Get IProcessEntry fail,type:%s.", new Object[]{type});
            }
        } else {
            parser = this.parsers.get(type);
        }
        if (null == parser) {
            LOG.info((Object)"Parser is null,type:%s.", new Object[]{type});
        }
        return parser;
    }
}

