/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.framework.rpc.util;

import com.huawei.lego.core.base.framework.rpc.metadata.AnnotationMetadata;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.base.structure.IService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.ClassUtils;

public class AnnotationUtil {
    public static AnnotationMetadata getAnnotationType(IService service) {
        AnnotationMetadata metaData = null;
        Service serviceAnnotation = null;
        if (service.getClass().isAnnotationPresent(Service.class)) {
            serviceAnnotation = service.getClass().getAnnotation(Service.class);
            metaData = new AnnotationMetadata(serviceAnnotation, serviceAnnotation.interfaceClass());
        } else {
            Class[] clazzes;
            for (Class clazz : clazzes = ClassUtils.getAllInterfaces((Object)service)) {
                if (!clazz.isAnnotationPresent(Service.class)) continue;
                serviceAnnotation = clazz.getAnnotation(Service.class);
                metaData = new AnnotationMetadata(serviceAnnotation, clazz);
                break;
            }
        }
        return metaData;
    }

    public static List<AnnotationMetadata> getAnnotationTypes(IService service) {
        ArrayList<AnnotationMetadata> metaDataList = new ArrayList<AnnotationMetadata>();
        Service serviceAnnotation = null;
        if (service.getClass().isAnnotationPresent(Service.class)) {
            serviceAnnotation = service.getClass().getAnnotation(Service.class);
            metaDataList.add(new AnnotationMetadata(serviceAnnotation, serviceAnnotation.interfaceClass()));
        } else {
            Class<?>[] clazzes;
            for (Class<?> clazz : clazzes = service.getClass().getInterfaces()) {
                if (!clazz.isAnnotationPresent(Service.class)) continue;
                serviceAnnotation = clazz.getAnnotation(Service.class);
                metaDataList.add(new AnnotationMetadata(serviceAnnotation, clazz));
            }
        }
        return metaDataList;
    }
}

