/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.registry;

import com.huawei.lego.core.base.registry.AppStore;
import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class AppStorehouse
implements InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getInstance(AppStorehouse.class);
    private static final String DATA_DIRECTORY = "data/";
    private static final String DATA_PATH = "data/app.xml";
    private AppStore store = new AppStore();

    public void add(AppInfo info) {
        this.store.add(info);
    }

    public void remove(String appName) {
        this.store.remove(appName);
    }

    public AppInfo query(String appName) {
        return this.store.query(appName);
    }

    public List<AppInfo> list() {
        return this.store.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterPropertiesSet() throws IOException {
        File file;
        File dir = new File(DATA_DIRECTORY);
        if (!dir.exists()) {
            boolean result = dir.mkdir();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Mkdir result is %s.", result), 0L);
        }
        if ((file = new File(DATA_PATH)).exists()) {
            FileInputStream fis = new FileInputStream(file);
            try {
                this.store.store(fis);
            }
            finally {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.error((Object)"close FileInputStream error.", (Throwable)e, 0L);
                }
            }
        }
    }

    public void destroy() throws IOException {
        File file = new File(DATA_PATH);
        if (file.exists()) {
            boolean result = file.delete();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete result is %s.", result), 0L);
        }
    }
}

