/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.service;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.base.framework.container.support.ApplicationHolder;
import com.huawei.lego.core.base.framework.rpc.Publisher;
import com.huawei.lego.core.sdk.base.ServiceContext;
import com.huawei.lego.core.sdk.base.event.ApplicationStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.EventTrigger;
import com.huawei.lego.core.sdk.base.event.ServiceStatusChangedListener;
import com.huawei.lego.core.sdk.base.event.StatusChangedListener;
import com.huawei.lego.core.sdk.base.event.SystemStatusChangedListener;
import com.huawei.lego.core.sdk.base.model.AppInfo;
import com.huawei.lego.core.sdk.base.model.Status;
import com.huawei.lego.core.sdk.base.structure.AbsApplication;
import com.huawei.lego.core.sdk.base.structure.IApplication;
import com.huawei.lego.core.sdk.base.structure.ICallback;
import com.huawei.lego.core.sdk.base.structure.ILifecycle;
import com.huawei.lego.core.sdk.base.structure.IService;
import com.huawei.lego.core.sdk.base.structure.ISystem;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public abstract class DefaultSystem
implements ISystem,
ILifecycle {
    private static final Log LOGGER = LogFactory.getInstance(DefaultSystem.class);
    private ApplicationHolder appHolder;
    private Status status;
    private ClassLoader loader;
    private List<StatusChangedListener> listeners;
    private List<StatusChangedListener> appListeners = new ArrayList<StatusChangedListener>();
    private List<StatusChangedListener> srvListeners = new ArrayList<StatusChangedListener>();
    private ManagedObject sysMO;
    private boolean systemStarted = false;
    private Publisher publisher;
    private Object lock = new Object();

    public void setCurrentStatus(Status statusVo) {
        this.status = statusVo;
    }

    public Status getCurrentStatus() {
        return this.status;
    }

    public ManagedObject getSystemMO() {
        return this.sysMO;
    }

    public void setSystemMO(ManagedObject mo) {
        this.sysMO = mo;
    }

    public void setAppliationHolder(ApplicationHolder holder) {
        this.appHolder = holder;
    }

    public void setContextClassLoader(ClassLoader cLoader) {
        this.loader = cLoader;
    }

    public ClassLoader getContextClassLoader() {
        return this.loader;
    }

    public void setPublisher(Publisher publisher) {
        this.publisher = publisher;
    }

    public void publishService(final AppInfo appinfo, final IService service) {
        if (this.publisher != null) {
            this.publisher.setBindedAppInfor(appinfo);
            this.publisher.publish(service, new ICallback(){

                public void invoke(ILifecycle life) {
                    AbsApplication application = (AbsApplication)service.getContainer();
                    if (null != application) {
                        ServiceContext.getInstance().register(appinfo);
                    }
                }
            });
        } else {
            StringBuffer msg = new StringBuffer(this.getClass().getSimpleName());
            msg.append(" system does not apply to system container,so ");
            msg.append(service.getClass().getSimpleName());
            msg.append(" service can't export rmi service!");
            LOGGER.error((Object)msg.toString(), 1L);
        }
    }

    public void unpublishService(IService service) {
        if (this.publisher != null) {
            this.publisher.unpublish(service, new ICallback(){

                public void invoke(ILifecycle life) {
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "%s has been unpublished!", life.getClass().getName()), 1L);
                }
            });
        } else {
            StringBuffer msg = new StringBuffer(this.getClass().getSimpleName());
            msg.append(" system does not apply to system container,so ");
            msg.append(service.getClass().getSimpleName());
            msg.append(" service can't unexport rmi service!");
            LOGGER.error((Object)msg.toString(), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(List<ICallback> callback) {
        List<IApplication> apps;
        List<IApplication> list = apps = this.appHolder.getHeldStructureEles();
        synchronized (list) {
            for (IApplication app : apps) {
                ILifecycle life;
                if (!(app instanceof ILifecycle) || (life = (ILifecycle)app).getCurrentStatus() == Status.STATUS_STARTED) continue;
                try {
                    life.start(callback);
                    life.setCurrentStatus(Status.STATUS_STARTED);
                }
                catch (Exception e) {
                    life.setCurrentStatus(Status.STATUS_ILLEGAL);
                }
            }
        }
        if (!this.systemStarted) {
            this.systemStarted = true;
            this.setCurrentStatus(Status.STATUS_STARTED);
            EventTrigger.fireEventListener((Object)this, this.listeners, (Status)Status.STATUS_STARTED);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(List<ICallback> callback) {
        List<IApplication> apps;
        List<IApplication> list = apps = this.appHolder.getHeldStructureEles();
        synchronized (list) {
            Iterator<IApplication> iterator = apps.iterator();
            while (iterator.hasNext()) {
                ILifecycle life;
                IApplication app = iterator.next();
                if (!(app instanceof ILifecycle) || (life = (ILifecycle)app).getCurrentStatus() != Status.STATUS_STOPED) continue;
                try {
                    life.stop(callback);
                    life.setCurrentStatus(Status.STATUS_DESTROYED);
                    iterator.remove();
                }
                catch (Exception e) {
                    life.setCurrentStatus(Status.STATUS_ILLEGAL);
                }
            }
        }
        this.setCurrentStatus(Status.STATUS_STOPED);
        EventTrigger.fireEventListener((Object)this, this.listeners, (Status)Status.STATUS_STOPED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(List<ICallback> callback) {
        List<IApplication> apps;
        List<IApplication> list = apps = this.appHolder.getHeldStructureEles();
        synchronized (list) {
            int count = apps.size();
            for (int i = 0; i < count; ++i) {
                IApplication app = apps.get(i);
                this.initializeLifeCycle(app, callback);
            }
        }
        this.setCurrentStatus(Status.STATUS_INIT);
        EventTrigger.fireEventListener((Object)this, this.listeners, (Status)Status.STATUS_INIT);
    }

    private void initializeLifeCycle(IApplication app, List<ICallback> callback) {
        if (app instanceof ILifecycle) {
            ILifecycle life = (ILifecycle)app;
            if (life.getCurrentStatus() == Status.STATUS_INIT || life.getCurrentStatus() == Status.STATUS_STARTED) {
                return;
            }
            try {
                life.initialize(callback);
                life.setCurrentStatus(Status.STATUS_INIT);
            }
            catch (Exception e) {
                life.setCurrentStatus(Status.STATUS_ILLEGAL);
            }
        }
    }

    public void initialize(ICallback[] callback) {
    }

    public void start(ICallback[] callback) {
    }

    public void stop(ICallback[] callback) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusChangeListener(EventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            if (listener instanceof StatusChangedListener) {
                this.listeners.add((StatusChangedListener)listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remStatusChangeListener(EventListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listeners.remove(listener);
        }
    }

    public boolean hasSystemBeenLaunched() {
        return this.systemStarted;
    }

    public List<StatusChangedListener> getStatusChangeLiserners() {
        return this.listeners;
    }

    public List<StatusChangedListener> getAppStatusListeners() {
        return this.appListeners;
    }

    public List<StatusChangedListener> getSrvStatusListeners() {
        return this.srvListeners;
    }

    public void mountApp(IApplication app, Map properties) {
        IApplication selfapp = app.getSelf();
        selfapp.setContainer((ISystem)this);
        if (this.appHolder == null) {
            this.appHolder = new ApplicationHolder(this);
        }
        this.appHolder.hold(selfapp);
    }

    public void umountApp(IApplication app, Map properties) {
        IApplication selfapp = app.getSelf();
        this.appHolder.free(selfapp);
    }

    public void registerSysListener(SystemStatusChangedListener listener, Map properties) {
        this.listeners.add((StatusChangedListener)listener);
    }

    public void unregisterSysListener(SystemStatusChangedListener listener, Map properties) {
        this.listeners.remove(listener);
    }

    public void registerAppListener(ApplicationStatusChangedListener listener, Map properties) {
        this.appListeners.add((StatusChangedListener)listener);
    }

    public void unregisterAppListener(ApplicationStatusChangedListener listener, Map properties) {
        this.appListeners.remove(listener);
    }

    public void registerServiceListener(ServiceStatusChangedListener listener, Map properties) {
        this.srvListeners.add((StatusChangedListener)listener);
    }

    public void unregisterServiceListener(ServiceStatusChangedListener listener, Map properties) {
        this.srvListeners.remove(listener);
    }

    public ApplicationHolder getAppHolder() {
        return this.appHolder;
    }

    public void setAppHolder(ApplicationHolder appHolder) {
        this.appHolder = appHolder;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public void setLoader(ClassLoader loader) {
        this.loader = loader;
    }

    public List<StatusChangedListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<StatusChangedListener> listeners) {
        this.listeners = listeners;
    }

    public List<StatusChangedListener> getAppListeners() {
        return this.appListeners;
    }

    public void setAppListeners(List<StatusChangedListener> appListeners) {
        this.appListeners = appListeners;
    }

    public List<StatusChangedListener> getSrvListeners() {
        return this.srvListeners;
    }

    public void setSrvListeners(List<StatusChangedListener> srvListeners) {
        this.srvListeners = srvListeners;
    }

    public Log getLog() {
        return LOGGER;
    }

    public ManagedObject getSysMO() {
        return this.sysMO;
    }

    public void setSysMO(ManagedObject sysMO) {
        this.sysMO = sysMO;
    }

    public boolean isSystemStarted() {
        return this.systemStarted;
    }

    public void setSystemStarted(boolean isStarted) {
        this.systemStarted = isStarted;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }
}

