/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.thread;

import com.huawei.lego.core.base.thread.Cache;
import com.huawei.lego.core.base.thread.Enhancer;
import com.huawei.lego.core.base.thread.FutureResult;
import com.huawei.lego.core.base.thread.ThreadPool;
import com.huawei.lego.core.base.thread.ThreadPoolConfig;
import com.huawei.lego.core.base.util.Lambda;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class ExecutionService {
    private static final Log logger = LogFactory.getInstance(ExecutionService.class);
    private static final int DEFAULT_COUNT = 20;
    private static final int CORE_POOL_SIZE = 2;
    private static ThreadPool threadPool = null;
    private static final int DEFAULT_TIME_OUT = 30;

    private ExecutionService() {
    }

    public static int getActiveCount() {
        return threadPool.getActiveCount();
    }

    public static void submitTask(Runnable runnable) {
        threadPool.submitTask(runnable);
    }

    public static Future<?> submit(Runnable runnable) {
        return threadPool.submit(runnable);
    }

    public static <T> Future<T> submit(Callable<T> callable) {
        return threadPool.submit(callable);
    }

    public static <T> Future<T> commit(Callable<T> callable) {
        return Cache.run(cache -> threadPool.submit(Enhancer.shareableCallable(callable)), new Runnable[0]);
    }

    public static <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return threadPool.newTaskFor(runnable, value);
    }

    public static <T> List<T> batchSubmit(List<Callable<T>> tasks, ExecuteType executeType, int timeout, int count) {
        return ExecutionService.execute(tasks, executeType, timeout, count).stream().filter(FutureResult::success).map(FutureResult::getData).collect(Collectors.toList());
    }

    public static <T> List<FutureResult<T>> commit(List<Callable<T>> tasks, ExecuteType executeType, int timeout, int count) {
        return Cache.run(cache -> ExecutionService.execute(Enhancer.shareableCallables(tasks), executeType, timeout, count), new Runnable[0]);
    }

    public static <T> List<FutureResult<T>> execute(List<Callable<T>> tasks, ExecuteType executeType, int timeout, int count) {
        if (null == tasks || tasks.isEmpty() || count <= 0) {
            throw new LegoCheckedException(1073947393L);
        }
        if (null == executeType) {
            executeType = ExecuteType.FAILED_CONTINUE;
        }
        ArrayList<FutureResult<T>> results = new ArrayList<FutureResult<T>>();
        List<List<Callable<T>>> batchTasks = ExecutionService.batchTask(tasks, count);
        for (List<Callable<T>> perBatchTasks : batchTasks) {
            ArrayList<Map.Entry<Callable<T>, Future<T>>> taskFutures = new ArrayList<Map.Entry<Callable<T>, Future<T>>>();
            for (Callable<T> task : perBatchTasks) {
                Future<T> taskFuture = ExecutionService.submit(task);
                taskFutures.add(new AbstractMap.SimpleEntry<Callable<T>, Future<T>>(task, taskFuture));
            }
            List perBatchTaskResults = ExecutionService.getResults(taskFutures, timeout);
            results.addAll(perBatchTaskResults);
            boolean failure = FutureResult.hasFailedResult(perBatchTaskResults);
            if (!failure || executeType != ExecuteType.FAILED_ABORT) continue;
            break;
        }
        return results;
    }

    private static <T> List<List<Callable<T>>> batchTask(List<Callable<T>> tasks, int count) {
        ArrayList<List<Callable<T>>> batchTasks = new ArrayList<List<Callable<T>>>();
        ArrayList<Callable<T>> concurrentTasks = new ArrayList<Callable<T>>();
        int index = 0;
        for (Callable<T> task : tasks) {
            concurrentTasks.add(task);
            if (++index != count) continue;
            batchTasks.add(concurrentTasks);
            concurrentTasks = new ArrayList();
            index = 0;
        }
        if (!concurrentTasks.isEmpty()) {
            batchTasks.add(concurrentTasks);
        }
        return batchTasks;
    }

    private static <T> List<FutureResult<T>> getResults(List<Map.Entry<Callable<T>, Future<T>>> items, int timeout) {
        if (null == items || items.isEmpty()) {
            return Collections.emptyList();
        }
        if (timeout <= 0) {
            timeout = 30;
        }
        ArrayList<FutureResult<T>> results = new ArrayList<FutureResult<T>>();
        for (Map.Entry<Callable<T>, Future<T>> item : items) {
            Future<T> future = item.getValue();
            try {
                T result = future.get(timeout, TimeUnit.SECONDS);
                results.add(new FutureResult<T>(result));
            }
            catch (Exception e) {
                logger.error((Object)("The task is timeout or interrupt: " + ExceptionUtil.getErrorMessage((Throwable)e)));
                results.add(new FutureResult(e));
            }
        }
        return results;
    }

    private static synchronized void initializePool() {
        try {
            if (null != threadPool) {
                return;
            }
            ThreadPoolConfig config = ThreadPoolConfig.getThreadPoolConfig();
            threadPool = new ThreadPool(config.getCorePoolSize() * 2, config.getMaximumPoolSize(), config.getKeepAliveTime(), TimeUnit.SECONDS, config.getWorkQueueSize());
        }
        catch (Exception e) {
            logger.error((Object)("Initialize thread pool failed: " + ExceptionUtil.getErrorMessage((Throwable)e)), 0L);
            threadPool = null;
        }
    }

    public static <I, O> List<O> map(Collection<I> items, Function<I, O> mapper, ExecuteType executeType, int timeout, int count) {
        if (items == null || items.isEmpty()) {
            return Collections.emptyList();
        }
        Objects.requireNonNull(mapper);
        ArrayList tasks = new ArrayList();
        for (I item : items) {
            tasks.add(new Mapping<I, O>(item, mapper));
        }
        return ExecutionService.batchSubmit(tasks, executeType, timeout, count);
    }

    public static <I, O> List<O> map(Collection<I> items, Function<I, O> mapper, int count) {
        return ExecutionService.map(items, mapper, null, 0, count);
    }

    public static <I, O> List<O> map(Collection<I> items, Function<I, O> mapper) {
        return ExecutionService.map(items, mapper, 20);
    }

    public static <I, O> List<O> map(Collection<I> items, Function<I, O> mapper, Function<I, String> stringify) {
        return ExecutionService.map(items, mapper, stringify, null);
    }

    public static <I, O> List<O> map(Collection<I> items, Function<I, O> mapper, Function<I, String> stringify, LegoCheckedException exception) {
        ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue();
        List<Object> results = ExecutionService.map(items, (I item) -> {
            queue.add(item);
            return mapper.apply(item);
        }, 20);
        if (queue.size() != items.size()) {
            logger.error((Object)("there have some item(s) failed or timeout. items: " + items.stream().filter(Lambda.use(queue::contains).negate()).map(stringify).collect(Collectors.toSet())));
            if (exception != null) {
                throw exception;
            }
        }
        return results;
    }

    public static <I> int map(Collection<I> items, Consumer<I> mapper, Function<I, String> stringify) {
        return ExecutionService.map(items, mapper, stringify, null);
    }

    public static <I> int map(Collection<I> items, Consumer<I> mapper, Function<I, String> stringify, LegoCheckedException exception) {
        Function<Object, Void> handler = item -> {
            mapper.accept(item);
            return null;
        };
        List<Void> results = ExecutionService.map(items, handler, stringify, exception);
        return results.size();
    }

    static {
        ExecutionService.initializePool();
    }

    private static class Mapping<I, O>
    implements Callable<O> {
        private I input;
        private Function<I, O> mapper;

        public Mapping(I input, Function<I, O> mapper) {
            this.input = input;
            this.mapper = mapper;
        }

        @Override
        public O call() throws Exception {
            return this.mapper.apply(this.input);
        }
    }

    public static enum ExecuteType {
        FAILED_ABORT,
        FAILED_CONTINUE;

    }
}

