/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.thread;

import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class ThreadPoolConfig {
    private static final Log LOGGER = LogFactory.getInstance(ThreadPoolConfig.class);
    public static final int DEFAULT_CORE_POOL_SIZE = 30;
    public static final int DEFAULT_MAX_POOL_SIZE = 500;
    public static final int DEFAULT_WORK_QUEUE_SIZE = 200;
    public static final int HCS_DEFAULT_WORK_QUEUE_SIZE = 1;
    public static final int RUNTIME_ENVIROMENT_CPU_PROCESSOR = 8;
    public static final String FUSION_CLOUD_VERSION = "fusioncloud.version";
    private static final String FC_VERSION = "6.3";
    private static final Map<String, ThreadPoolConfig> CONFIGS = new HashMap<String, ThreadPoolConfig>();
    private static final long DEFAULT_KEEP_ALIVE_TIME = 120L;
    private int corePoolSize = 30;
    private int maximumPoolSize = 500;
    private int workQueueSize = 200;
    private long keepAliveTime = 120L;
    private long cpuProcessor = 8L;

    private ThreadPoolConfig(String poolName) {
        this.loadThreadPoolConfiguration(poolName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadThreadPoolConfiguration(String poolName) {
        InputStream inputStream;
        Properties props;
        block6: {
            props = new Properties();
            inputStream = null;
            try {
                ClassLoader cLoader = ThreadPoolConfig.class.getClassLoader();
                if (null != cLoader) {
                    inputStream = cLoader.getResourceAsStream("common_threadpool.properties");
                }
                if (null == inputStream) break block6;
                props.load(inputStream);
            }
            catch (IOException e) {
                try {
                    LOGGER.warn((Object)("Loading configuration failed, exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 0L);
                }
                catch (Throwable throwable) {
                    CommonUtil.close(inputStream);
                    throw throwable;
                }
                CommonUtil.close((Closeable)inputStream);
            }
        }
        CommonUtil.close((Closeable)inputStream);
        this.corePoolSize = NumberUtil.convertToInteger((Object)props.getProperty("pool." + poolName + ".core_pool_size"), (int)30);
        this.maximumPoolSize = NumberUtil.convertToInteger((Object)props.getProperty("pool." + poolName + ".max_pool_size"), (int)500);
        this.workQueueSize = NumberUtil.convertToInteger((Object)props.getProperty("pool." + poolName + ".work_queue_size"), (int)200);
        this.keepAliveTime = NumberUtil.convertToLong((Object)props.getProperty("pool." + poolName + ".keep_alive_time"), (long)120L);
        Runtime runtime = Runtime.getRuntime();
        String fcVersion = LegoConfig.getInstance().getKeyValue(FUSION_CLOUD_VERSION);
        if ((long)runtime.availableProcessors() >= this.cpuProcessor && !VerifyUtil.isEmpty((String)fcVersion) && fcVersion.compareToIgnoreCase(FC_VERSION) >= 0) {
            this.workQueueSize = NumberUtil.convertToInteger((Object)props.getProperty("hcs.pool." + poolName + ".work_queue_size"), (int)1);
            LOGGER.info((Object)"CpuProcessor more than eight and ThreadPoolConfig set  workQueueSize of threadPool to %s", (long)this.workQueueSize);
        }
    }

    public static ThreadPoolConfig getThreadPoolConfig() {
        return ThreadPoolConfig.getThreadPoolConfig("default");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadPoolConfig getThreadPoolConfig(String poolName) {
        Map<String, ThreadPoolConfig> map = CONFIGS;
        synchronized (map) {
            if (CONFIGS.containsKey(poolName)) {
                return CONFIGS.get(poolName);
            }
            ThreadPoolConfig config = new ThreadPoolConfig(poolName);
            CONFIGS.put(poolName, config);
            return config;
        }
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getWorkQueueSize() {
        return this.workQueueSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }
}

