/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.base.util;

import com.huawei.lego.core.base.util.LegoDBProperties;

public class ConverterUtil {
    public static String convertString(String sourceStr, boolean isWild) {
        String dbType = LegoDBProperties.getDBType();
        if (sourceStr == null) {
            return "%%";
        }
        StringBuilder buffer = new StringBuilder();
        if (isWild) {
            buffer.append("%");
        }
        ConverterUtil.convertStringOne(sourceStr, dbType, buffer);
        if (isWild) {
            buffer.append("%");
        }
        return buffer.toString();
    }

    private static void convertStringOne(String sourceStr, String dbType, StringBuilder buffer) {
        for (int i = 0; i < sourceStr.length(); ++i) {
            char c = sourceStr.charAt(i);
            if ("sqlserver".equalsIgnoreCase(dbType)) {
                buffer = ConverterUtil.processCharSqlserver(buffer, c);
                continue;
            }
            if (c == '%' || c == '_' || c == '\\') {
                buffer.append('\\');
            }
            buffer.append(c);
        }
    }

    private static StringBuilder processCharSqlserver(StringBuilder buffer, char c) {
        if (c == '%' || c == '_' || c == '[') {
            buffer.append('[');
            buffer.append(c);
            buffer.append(']');
        } else {
            buffer.append(c);
        }
        return buffer;
    }
}

