/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.core.mediation.synchronize;

import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.model.Node;
import com.huawei.lego.core.mediation.model.SynchronizeMOResult;
import com.huawei.lego.core.sdk.domain.IDomainContainer;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.mediation.synchronize.ISynchronizer;
import com.huawei.lego.core.sdk.mediation.synchronize.model.MoListOrMap;
import com.huawei.lego.core.sdk.mediation.synchronize.model.SynchronizeParameter;
import com.huawei.lego.core.sdk.mediation.synchronize.model.XmlSynchronizeContext;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import java.util.List;

public class SynchronizeWorker {
    private static final Log LOGGER = LogFactory.getInstance(SynchronizeWorker.class);
    private IDomainContainer container = null;
    private XmlSynchronizeContext xmlSynchronizeContext = null;
    private Node discoveredNode = null;
    private ManagedObject topMo = null;
    private DiscoveryPolicy discoveryPolicy = null;
    private String refreshOperationUuid = null;

    public SynchronizeWorker(XmlSynchronizeContext xmlSynchronizeContext, Node discoveredNode, IDomainContainer container, DiscoveryPolicy discoveryPolicy, String refreshOperationUuid) {
        this.xmlSynchronizeContext = xmlSynchronizeContext;
        this.discoveredNode = discoveredNode;
        this.container = container;
        this.discoveryPolicy = discoveryPolicy;
        this.refreshOperationUuid = refreshOperationUuid;
    }

    public void doSynchronizeWork(SynchronizeMOResult synchronizeMOResult) {
        LOGGER.info((Object)"A task is begin to run");
        try {
            this.process(this.xmlSynchronizeContext, this.discoveredNode, null, synchronizeMOResult);
        }
        catch (LegoUncheckedException ex) {
            LOGGER.error((Object)"Exception when process synchronizing", (Throwable)ex);
            throw new LegoCheckedException(ex.getErrorCode(), (Throwable)ex);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exception when process synchronizing", (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception when process synchronizing,%s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoUncheckedException(1053L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void process(XmlSynchronizeContext xmlSynchronizeCtx, Node discoveredNod, MoListOrMap parentMoListOrMap, SynchronizeMOResult synchronizeMOResult) {
        LOGGER.info((Object)"XMLSynchronizeCtx is : %s, parentMoListOrMap is : %s", new Object[]{xmlSynchronizeCtx, parentMoListOrMap});
        ISynchronizer synchronizer = xmlSynchronizeCtx.getSynchronizer();
        String[] disParam = new String[]{discoveredNod.getIpAddress(), discoveredNod.getNetMask()};
        SynchronizeParameter synchronizeParameter = new SynchronizeParameter(disParam, discoveredNod.getManagementProtocolMap(), new String[]{discoveredNod.getSysOid(), discoveredNod.getSysName(), discoveredNod.getSysDescr()}, xmlSynchronizeCtx.getHalfConstructMo(), this.discoveryPolicy, discoveredNod.getLocation());
        if (this.checkSyncCTX(xmlSynchronizeCtx)) {
            MoListOrMap moListOrMap;
            try {
                moListOrMap = synchronizer.synchronizeDataAndConstructMo(synchronizeParameter, parentMoListOrMap);
            }
            finally {
                if (synchronizer.getSyncMOCount() > 0) {
                    synchronizeMOResult.setCount(synchronizer.getSyncMOCount());
                }
            }
            LOGGER.info((Object)"Synchronize result in process method is : %s, synchronizer is : ", new Object[]{moListOrMap, synchronizer});
            if (this.checkMoMapEmpty(moListOrMap)) {
                LOGGER.warn((Object)"The return topMo of synchronizeDataAndConstructMo is null, mapping is : %s", new Object[]{xmlSynchronizeCtx});
                return;
            }
            this.extracted(xmlSynchronizeCtx, moListOrMap);
            LOGGER.info((Object)"Will process none top mo...", 1L);
            this.processNoneTopMo(xmlSynchronizeCtx, discoveredNod, moListOrMap);
        } else {
            MoListOrMap moListOrMap = synchronizer.synchronizeDataAndConstructMo(synchronizeParameter, parentMoListOrMap);
            LOGGER.info((Object)"Synchronize result in process method is :%s ,synchronizer is : %s.", new Object[]{moListOrMap, synchronizer});
            if (this.checkMoMapEmpty(moListOrMap)) {
                LOGGER.warn((Object)"Return value of synchronizeDataAndConstructMo is empty, mapping is: %s.", new Object[]{xmlSynchronizeCtx});
                return;
            }
            List childMappings = xmlSynchronizeCtx.getChildrenContext();
            if (!childMappings.isEmpty()) {
                for (XmlSynchronizeContext childMapping : childMappings) {
                    this.processSubMo(childMapping, moListOrMap);
                }
            }
        }
    }

    private boolean checkMoMapEmpty(MoListOrMap moListOrMap) {
        return moListOrMap == null || moListOrMap.isEmpty();
    }

    private boolean checkSyncCTX(XmlSynchronizeContext xmlSynchronizeCtx) {
        return xmlSynchronizeCtx.getReferredOid() == null || "".equals(xmlSynchronizeCtx.getReferredOid().trim());
    }

    private void extracted(XmlSynchronizeContext xmlSynchronizeCtx, MoListOrMap moListOrMap) {
        if (xmlSynchronizeCtx.isTopMo()) {
            this.topMo = moListOrMap.getMo();
            this.topMo.setIsTopMo(Boolean.valueOf(true));
            if (this.topMo instanceof Node && this.discoveryPolicy != null) {
                ((Node)this.topMo).setManagementProtocolMap(this.discoveryPolicy.getManagementProtocolMap());
            }
        }
    }

    private void processNoneTopMo(XmlSynchronizeContext xmlSynchronizeCtx, Node discoveredNod, MoListOrMap moListOrMap) {
        LOGGER.info((Object)"Inside processNoneTopMo method,xmlSynchronizeCtx is:%s, discoveredNod is:%s, moListOrMap is:%s", new Object[]{xmlSynchronizeCtx, discoveredNod, moListOrMap, 1L});
        List childMappings = xmlSynchronizeCtx.getChildrenContext();
        LOGGER.info((Object)"ChildMappings is : %s", new Object[]{1L, childMappings});
        if (!childMappings.isEmpty()) {
            for (XmlSynchronizeContext childMapping : childMappings) {
                LOGGER.info((Object)"ChildMapping is : %s.", new Object[]{1L, childMapping});
                if (xmlSynchronizeCtx.isTopMo()) {
                    LOGGER.info((Object)"Will process sub mo of top mo.", 1L);
                    this.process(childMapping, discoveredNod, moListOrMap, null);
                    continue;
                }
                LOGGER.info((Object)"Will process sub mo of sub mo.", 1L);
                this.processSubMo(childMapping, moListOrMap);
            }
            LOGGER.info((Object)"Final moListOrMap is : %s.", new Object[]{1L, moListOrMap});
        }
    }

    private void processSubMo(XmlSynchronizeContext xmlSynchronizeCtx, MoListOrMap parentMoListOrMap) {
        block6: {
            SynchronizeParameter synchronizeParameter;
            ISynchronizer handler;
            block5: {
                handler = xmlSynchronizeCtx.getSynchronizer();
                String[] disParam = new String[]{this.discoveredNode.getIpAddress(), this.discoveredNode.getNetMask()};
                synchronizeParameter = new SynchronizeParameter(disParam, this.discoveredNode.getManagementProtocolMap(), new String[]{this.discoveredNode.getSysOid(), this.discoveredNode.getSysName(), this.discoveredNode.getSysDescr()}, xmlSynchronizeCtx.getHalfConstructMo(), this.discoveryPolicy, this.discoveredNode.getLocation());
                if (!this.checkSyncCTX(xmlSynchronizeCtx)) break block5;
                MoListOrMap moListOrMap = handler.synchronizeDataAndConstructMo(synchronizeParameter, parentMoListOrMap);
                LOGGER.info((Object)"Synchronize result in processSubMo method is : %s, synchronizer is : %s.", new Object[]{1L, moListOrMap, handler});
                if (this.checkMoMapEmpty(moListOrMap)) {
                    LOGGER.warn((Object)"Return value of synchronizeDataAndConstructMo is empty, mapping is : %s", new Object[]{1L, xmlSynchronizeCtx});
                    return;
                }
                List childMappings = xmlSynchronizeCtx.getChildrenContext();
                if (childMappings.isEmpty()) break block6;
                for (XmlSynchronizeContext childMapping : childMappings) {
                    this.processSubMo(childMapping, moListOrMap);
                }
                break block6;
            }
            MoListOrMap moListOrMap = handler.synchronizeDataAndConstructMo(synchronizeParameter, parentMoListOrMap);
            LOGGER.info((Object)"Synchronize result in processSubMo method is : %s, synchronizer is : %s.", new Object[]{1L, moListOrMap, handler});
            if (this.checkMoMapEmpty(moListOrMap)) {
                LOGGER.warn((Object)"Return value of synchronizeDataAndConstructMo is empty, mapping is : %s", new Object[]{1L, xmlSynchronizeCtx});
                return;
            }
            List childMappings = xmlSynchronizeCtx.getChildrenContext();
            if (!childMappings.isEmpty()) {
                for (XmlSynchronizeContext childMapping : childMappings) {
                    this.processSubMo(childMapping, moListOrMap);
                }
            }
        }
    }

    public String toString() {
        return "SynchronizeTask [container=" + this.container + ", discoveredNode=" + this.discoveredNode + ", discoveryPolicy=" + this.discoveryPolicy + ", topMo=" + this.topMo + ", xmlSynchronizeContext=" + this.xmlSynchronizeContext + ", refreshOperationUuid=" + this.refreshOperationUuid + "]";
    }
}

