/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.discover.service;

import com.huawei.lego.cbb.resource.dao.IResourceDao;
import com.huawei.lego.cbb.resource.sdk.model.DeviceTypeRelation;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.cbb.resource.sdk.service.IResourceService;
import com.huawei.lego.com.south.sdk.model.Protocol;
import com.huawei.lego.com.south.sdk.model.TelnetPara;
import com.huawei.lego.comm.internal.jms.IMessageCenter;
import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.ICacheService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.discover.dao.IDiscoveryDao;
import com.huawei.lego.nem.discover.sdk.model.DeviceTypeAndUrl;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryPolicy;
import com.huawei.lego.nem.discover.sdk.model.DiscoveryResult;
import com.huawei.lego.nem.discover.sdk.model.DynamicFieldOfDiscovery;
import com.huawei.lego.nem.discover.sdk.model.ExtendAttribute;
import com.huawei.lego.nem.discover.sdk.model.ExtendProductAttribute;
import com.huawei.lego.nem.discover.sdk.model.ProtocolAndUrl;
import com.huawei.lego.nem.discover.sdk.service.IDeviceTypeFilter;
import com.huawei.lego.nem.discover.sdk.service.IDiscoveryService;
import com.huawei.lego.nem.discover.sdk.service.IManagementProtocolAndPageUrlHandler;
import com.huawei.lego.nem.discover.sdk.service.IManualNodeEditor;
import com.huawei.lego.nem.discover.sdk.service.INodeEditor;
import com.huawei.lego.nem.discover.service.AbstractDiscoveryThread;
import com.huawei.lego.nem.discover.service.DiscoveryServiceImplUtil;
import com.huawei.lego.nem.discover.service.IcmpDiscoveryThread;
import com.huawei.lego.nem.discover.service.ProductDiscoveryServiceContainer;
import com.huawei.lego.nem.discover.util.DaoFactory;
import com.huawei.lego.nem.discover.util.WatchUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.springframework.util.StringUtils;

@Service(name="DiscoveryServiceImpl", desc="", interfaceClass=IDiscoveryService.class)
public class DiscoveryServiceImpl
extends BaseService
implements IDiscoveryService {
    private static final int VALUE_5 = 5;
    private static final int VALUE_100 = 100;
    private static final int VALUE_1000 = 1000;
    private static final int VALUE_3 = 3;
    private static boolean cleanDiscoveryCacheThreadStarted = false;
    private static final Log LOGGER = LogFactory.getInstance(DiscoveryServiceImpl.class);
    private ICacheService<String, Object> cacheService = null;
    private IDiscoveryDao discoveryDao = null;
    private IMessageCenter messageCenter = null;
    private List<INodeEditor> nodeEditorList = new ArrayList<INodeEditor>();
    private List<IManualNodeEditor> manualNodeEditorList = new ArrayList<IManualNodeEditor>();
    private List<IDeviceTypeFilter> deviceTypeFilterList = new ArrayList<IDeviceTypeFilter>();
    private Map<String, Map<String, DynamicFieldOfDiscovery>> deviceTypeDynamicFieldMap = new HashMap<String, Map<String, DynamicFieldOfDiscovery>>();
    private Map<String, String> managementProtocolPageUrlMap = new HashMap<String, String>();
    private Map<String, String> managementProtocolCreatePageUrlMap = new HashMap<String, String>();
    private ExecutorService threadPool = Executors.newFixedThreadPool(5);
    private Map<Long, AbstractDiscoveryThread> activeDiscoveryThreadMap = new ConcurrentHashMap<Long, AbstractDiscoveryThread>();
    private Set<Long> lockedDeviceWhenRefresh = Collections.synchronizedSet(new HashSet());
    private Set<Long> lockedDeviceWhenDelete = Collections.synchronizedSet(new HashSet());
    private Set<Long> lockedDeviceWhenSyncAlarm = Collections.synchronizedSet(new HashSet());
    private DiscoveryServiceImplUtil dsiUtil = new DiscoveryServiceImplUtil();

    public synchronized BatchOperationResult deleteDeviceNewWithoutMsg(List<Long> moIdList) {
        LOGGER.debug((Object)"deleteDeviceNewWithoutMsg");
        return this.dsiUtil.deleteDeviceNewWithoutMsg(this.cacheService, moIdList);
    }

    private DeviceTypeAndUrl filterDevice(DeviceTypeAndUrl deviceTypeAndUrl, Map<String, Set<String>> unmodifiableMainSubTypeMap) {
        HashMap<String, Set<String>> filteredMainSubTypeMap = new HashMap<String, Set<String>>();
        for (IDeviceTypeFilter deviceTypeFilter : this.deviceTypeFilterList) {
            Map productDeviceTypeMap = deviceTypeFilter.filterDeviceType(unmodifiableMainSubTypeMap);
            if (productDeviceTypeMap != null) {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Filtered product device type map is : %s.", productDeviceTypeMap), 1L);
                this.addToFilteredMainSubTypeMap(productDeviceTypeMap, filteredMainSubTypeMap);
                continue;
            }
            LOGGER.info((Object)"filtered product device type map is : null", 1L);
        }
        deviceTypeAndUrl.setMainSubTypeMap(filteredMainSubTypeMap);
        return deviceTypeAndUrl;
    }

    private void addToFilteredMainSubTypeMap(Map<String, Set<String>> productDeviceTypeMap, Map<String, Set<String>> filteredMainSubTypeMap) {
        for (Map.Entry<String, Set<String>> productDeviceTypeEntry : productDeviceTypeMap.entrySet()) {
            String productMainType = productDeviceTypeEntry.getKey();
            if (filteredMainSubTypeMap.containsKey(productMainType)) {
                filteredMainSubTypeMap.get(productMainType).addAll((Collection<String>)productDeviceTypeEntry.getValue());
                continue;
            }
            filteredMainSubTypeMap.put(productMainType, productDeviceTypeEntry.getValue());
        }
        LOGGER.debug((Object)"addToFilteredMainSubTypeMap:completed");
    }

    public synchronized DeviceTypeAndUrl getDeviceTypeAndUrl() {
        DeviceTypeAndUrl deviceTypeAndUrl = new DeviceTypeAndUrl();
        String hql = "from DeviceTypeRelation";
        List<?> deviceTypeRelationList = this.discoveryDao.findByHql(hql);
        HashMap<String, Set<String>> mainSubTypeMap = new HashMap<String, Set<String>>();
        if (deviceTypeRelationList != null) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "The deviceTypeRelationList is : %s.", deviceTypeRelationList), 1L);
            HashMap<String, String> typeUrlMap = new HashMap<String, String>();
            for (DeviceTypeRelation typeRelation : deviceTypeRelationList) {
                this.processTypeUrlMap(mainSubTypeMap, typeRelation, typeUrlMap);
            }
            deviceTypeAndUrl.setTypeUrlMap(typeUrlMap);
        } else {
            LOGGER.info((Object)"the deviceTypeRelationList is : null", 1L);
        }
        HashMap mapHasUnmodifiableSet = new HashMap();
        for (Map.Entry entry : mainSubTypeMap.entrySet()) {
            mapHasUnmodifiableSet.put(entry.getKey(), Collections.unmodifiableSet((Set)entry.getValue()));
        }
        Map<String, Set<String>> unmodifiableMainSubTypeMap = Collections.unmodifiableMap(mapHasUnmodifiableSet);
        deviceTypeAndUrl = this.filterDevice(deviceTypeAndUrl, unmodifiableMainSubTypeMap);
        LOGGER.info((Object)String.format(Locale.ENGLISH, "The result deviceTypeAndUrl is : %s.", deviceTypeAndUrl), 1L);
        return deviceTypeAndUrl;
    }

    private void processTypeUrlMap(Map<String, Set<String>> mainSubTypeMap, DeviceTypeRelation typeRelation, Map<String, String> typeUrlMap) {
        String mainType = typeRelation.getParentType();
        String subType = typeRelation.getChildType();
        String pageUrl = typeRelation.getPageUrl();
        if (!mainSubTypeMap.containsKey(mainType)) {
            mainSubTypeMap.put(mainType, new HashSet());
        }
        if (StringUtils.hasText((String)subType)) {
            Set<String> subTypeSet = mainSubTypeMap.get(mainType);
            subTypeSet.add(subType);
            if (StringUtils.hasText((String)pageUrl)) {
                typeUrlMap.put(subType, pageUrl);
            }
        } else if (StringUtils.hasText((String)pageUrl)) {
            typeUrlMap.put(mainType, pageUrl);
        }
        LOGGER.debug((Object)"processTypeUrlMap:completed");
    }

    public synchronized DiscoveryPolicy getDiscoveryPolicy(Long discoveryPolicyId) {
        String hql;
        List<?> protocolList;
        List<DiscoveryPolicy> policyList = this.discoveryDao.findByHql("from DiscoveryPolicy policy where policy.discoveryPolicyId = " + discoveryPolicyId);
        if (this.checkPolicyListNull(policyList)) {
            LOGGER.warn((Object)("the discovery policy does not exit, discoveryPolicyId is : " + discoveryPolicyId), 1L);
            throw new LegoCheckedException(1055L);
        }
        DiscoveryPolicy policy = policyList.get(0);
        if (!policy.getFinished().booleanValue()) {
            String key = "discoveryPolicyId_" + policy.getDiscoveryPolicyId();
            Long finishedIpCount = (Long)this.cacheService.get((Object)key);
            long percent100 = 0L;
            if (finishedIpCount == null) {
                LOGGER.warn((Object)("finishedIpCount is null in the cache, key is : " + key), 1L);
                percent100 = 100L;
            } else {
                percent100 = finishedIpCount * 100L / policy.getTotalIpCount();
            }
            policy.setDiscoveryPercentStr(percent100 + "%");
            policy.setDiscoveryPercentInt((int)percent100);
        }
        if ((protocolList = this.discoveryDao.findByHql(hql = "from Protocol p where p.discoveryPolicy.discoveryPolicyId = " + policy.getDiscoveryPolicyId())) != null) {
            for (Protocol protocol : protocolList) {
                policy.addManagementProtocol(protocol.getClass().getName(), protocol);
            }
            Map managementProtocolMap = policy.getManagementProtocolMap();
            if (managementProtocolMap != null) {
                policy.setTelnetPara((TelnetPara)managementProtocolMap.get(TelnetPara.class.getName()));
            }
        }
        return policy;
    }

    private boolean checkPolicyListNull(List<DiscoveryPolicy> policyList) {
        if (policyList == null || policyList.isEmpty()) {
            return true;
        }
        LOGGER.debug((Object)"checkPolicyListNull:policyList is not null");
        return false;
    }

    public synchronized Paging getDiscoveryResult(Long discoveryPolicyId, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        LOGGER.info((Object)String.format(Locale.ENGLISH, "DiscoveryPolicyId is : %s.", discoveryPolicyId), 1L);
        if (discoveryPolicyId == null) {
            return new Paging();
        }
        if (this.discoveryDao.get(DiscoveryPolicy.class, discoveryPolicyId) == null) {
            LOGGER.warn((Object)("the discovery policy does not exitttt, discoveryPolicyId is : " + discoveryPolicyId), 1L);
            throw new LegoCheckedException(1055L);
        }
        return this.discoveryDao.getDiscoveryResult(discoveryPolicyId, firstRowIndex, totalRow, orderByField, orderByAscend);
    }

    public synchronized void updateDiscoveryResultAndPolicy(DiscoveryResult discoveryResult, boolean icmpPingSuccess) {
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Discovery result is : %s.", discoveryResult), 1L);
        DiscoveryPolicy discoveryPolicy = discoveryResult.getDiscoveryPolicy();
        if (discoveryResult.getSuccess().booleanValue() || icmpPingSuccess) {
            this.discoveryDao.save(discoveryResult);
        }
        this.updateDiscoveryPolicy(discoveryPolicy, discoveryResult.getSuccess());
    }

    public synchronized void updateDiscoveryPolicy(DiscoveryPolicy policy, boolean discoverSuccess) {
        LOGGER.info((Object)"will updateDiscoveryStatus", 1L);
        DiscoveryPolicy discoveryPolicy = (DiscoveryPolicy)this.discoveryDao.get(DiscoveryPolicy.class, Long.valueOf(policy.getDiscoveryPolicyId()));
        if (discoveryPolicy == null) {
            LOGGER.warn((Object)"the discovery policy does not exist", 1L);
            return;
        }
        String key = "discoveryPolicyId_" + discoveryPolicy.getDiscoveryPolicyId();
        if (!this.cacheService.containsKey((Object)key)) {
            LOGGER.warn((Object)"the discovery policy may finish or be stopped manually", 1L);
            return;
        }
        this.cacheService.increaseCachedDataCount(key);
        Long discoveredIpCount = (Long)this.cacheService.get((Object)key);
        Long totalIpCount = discoveryPolicy.getTotalIpCount();
        LOGGER.info((Object)String.format(Locale.ENGLISH, "DiscoveredIpCount is : %s, totalIpCount is : %s.", discoveredIpCount, totalIpCount), 1L);
        if (discoveredIpCount >= totalIpCount) {
            this.cacheService.remove((Object)key);
            this.activeDiscoveryThreadMap.remove(discoveryPolicy.getDiscoveryPolicyId());
            discoveryPolicy.setFinished(Boolean.valueOf(true));
            discoveryPolicy.setEndDiscoveryTime(new Timestamp(System.currentTimeMillis()));
            discoveryPolicy.setDiscoveryPercentStr("100%");
            discoveryPolicy.setDiscoveryPercentInt(100);
        }
        this.discoveryDao.update(discoveryPolicy);
    }

    public synchronized Long icmpDiscovery(DiscoveryPolicy policy) {
        LOGGER.info((Object)"begin icmp discovery.");
        this.setPolicyInfo(policy);
        policy = this.updateAndSavePolicy(policy);
        this.cacheService.put((Object)("discoveryPolicyId_" + policy.getDiscoveryPolicyId()), (Object)0L);
        policy.setLocation(this.decode(policy.getLocation()));
        IcmpDiscoveryThread icmpDiscoveryThread = new IcmpDiscoveryThread(policy, this.nodeEditorList);
        this.activeDiscoveryThreadMap.put(policy.getDiscoveryPolicyId(), icmpDiscoveryThread);
        this.threadPool.execute(icmpDiscoveryThread);
        LOGGER.info((Object)"icmp discovery finished.");
        return policy.getDiscoveryPolicyId();
    }

    private DiscoveryPolicy updateAndSavePolicy(DiscoveryPolicy policy) {
        Map extendProductMap;
        policy = ProductDiscoveryServiceContainer.disSavePro(policy);
        this.validateDiscParam(policy);
        this.discoveryDao.save(policy);
        Map paramMap = policy.getParamMap();
        if (paramMap != null) {
            for (Map.Entry entry : paramMap.entrySet()) {
                String paramName = (String)entry.getKey();
                String paramValue = (String)entry.getValue();
                ExtendAttribute ea = new ExtendAttribute();
                ea.setAttributeName(paramName);
                ea.setAttributeValue(paramValue);
                ea.setDiscoveryPolicy(policy);
                this.discoveryDao.save(ea);
            }
        }
        if ((extendProductMap = policy.getExtendProductAttributeMap()) != null) {
            for (Map.Entry entry : extendProductMap.entrySet()) {
                String paramName = (String)entry.getKey();
                String paramValue = (String)entry.getValue();
                ExtendProductAttribute ea = new ExtendProductAttribute();
                ea.setAttributeName(paramName);
                ea.setAttributeValue(paramValue);
                ea.setDiscoveryPolicy(policy);
                this.discoveryDao.save(ea);
            }
        }
        return policy;
    }

    private void setPolicyInfo(DiscoveryPolicy policy) {
        policy.setUuidForPerDiscovery(UUID.randomUUID().toString());
        policy.setDiscoveryStyle(3);
        policy.setBeginDiscoveryTime(new Timestamp(System.currentTimeMillis()));
        policy.setDiscoveryPercentStr("0%");
        policy.setDiscoveryPercentInt(0);
        long startIpLong = 0L;
        if (WatchUtil.regexpMatchIp(policy.getStartIP())) {
            startIpLong = WatchUtil.getAddrLong(policy.getStartIP());
        }
        long totalIpCount = 1L;
        if (StringUtils.hasText((String)policy.getEndIP())) {
            long endIpLong = 0L;
            if (WatchUtil.regexpMatchIp(policy.getEndIP())) {
                endIpLong = WatchUtil.getAddrLong(policy.getEndIP());
            }
            totalIpCount = endIpLong + 1L - startIpLong;
        }
        policy.setTotalIpCount(Long.valueOf(totalIpCount));
    }

    private boolean validateDiscParam(DiscoveryPolicy policy) {
        LOGGER.debug((Object)"validateDiscParam");
        return this.dsiUtil.validateDiscParam(policy);
    }

    public synchronized BatchOperationResult deleteDevice(List<Long> moIdList) {
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Will deleteDevice, moIdList is : %s.", moIdList), 1L);
        IResourceDao resourceDao = DaoFactory.getInstance().getResourceDao();
        BatchOperationResult batchOpResult = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int failCount = 0;
        int operCount = moIdList.size();
        IResourceService resourceServiceTemp = this.dsiUtil.getResourceService();
        for (Long moId : moIdList) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Willllllll delete device moid is : %s.", moId), 1L);
            try {
                ManagedObject lmo = resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                LOGGER.info((Object)String.format(Locale.ENGLISH, "llllllllllllllmo is : %s.", lmo), 1L);
                HashMap<String, String> map = new HashMap<String, String>();
                failCount = this.checkFail(lmo, moId, failCount, resultList, map);
                if ("true".equals(map.get("flag"))) continue;
                resourceServiceTemp.deleteMo(moId);
            }
            catch (Exception e) {
                LOGGER.error((Object)("delete device faileddddddd, moId is : " + moId + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                ++failCount;
                BatchOperation operation = new BatchOperation();
                operation.setErrorCode(1028L);
                ManagedObject lmo = resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                if (lmo != null) {
                    operation.setTargetName(lmo.getName());
                } else {
                    operation.setTargetName(String.valueOf(moId));
                }
                resultList.add(operation);
            }
        }
        batchOpResult.setResult(resultList);
        batchOpResult.setFailCount(failCount);
        batchOpResult.setTotalCount(operCount);
        batchOpResult.setSucceedCount(operCount - failCount);
        return batchOpResult;
    }

    private int checkFail(ManagedObject lmo, Long moId, int failCount, List<BatchOperation> resultList, Map<String, String> map) {
        if (lmo == null) {
            LOGGER.warn((Object)("tttttthe device has been already deleted, moId is : " + moId), 1L);
            ++failCount;
            this.addOperation(resultList, "", moId, 1028L);
            map.put("flag", "true");
        } else {
            String keys = "mo_uuid_" + lmo.getUuid();
            if (this.cacheService.containsKey((Object)keys)) {
                LOGGER.warn((Object)("the device is synchronizing data, moId is : " + moId), 1L);
                ++failCount;
                this.addOperation(resultList, "", moId, 1028L);
                map.put("flag", "true");
            }
        }
        return failCount;
    }

    public synchronized void checkOverLimitResourceQuantity(int addNum) {
        String hql = "select count(*) from DrResource";
        HashMap<Integer, String> param = new HashMap<Integer, String>();
        long existDrNum = this.discoveryDao.getTotalCount(hql, param);
        if (existDrNum + (long)addNum > 10000L) {
            LOGGER.error((Object)"Over the resource quantity limit. current resource num:[%s]. add num:[%s]", new Object[]{String.valueOf(existDrNum), addNum});
            throw new SpecCheckedException("discovery_resource_quantity", existDrNum + (long)addNum, 10000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized BatchOperationResult deleteDeviceNew(List<BatchOperation> bathOprLst) {
        LOGGER.info((Object)String.format(Locale.ENGLISH, "Will deleteDeviceNewwwwwwwwww, bathOprLst size is : %s.", bathOprLst.size()), 1L);
        IResourceDao resourceDao = DaoFactory.getInstance().getResourceDao();
        BatchOperationResult batchOpResult = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int failCount = 0;
        int operCount = bathOprLst.size();
        IResourceService resourceServiceTemp = this.dsiUtil.getResourceService();
        for (BatchOperation op : bathOprLst) {
            Long moId = op.getTargetId();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Will delete device moid is : %s.", moId), 1L);
            if (this.lockedDeviceWhenRefresh.contains(moId)) {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "The mo is locked because the mo is in refresh, moId is : %s.", moId), 1L);
                ++failCount;
                this.addOperation(resultList, op.getTargetName(), moId, 1033L);
                continue;
            }
            if (this.lockedDeviceWhenSyncAlarm.contains(moId)) {
                LOGGER.info((Object)String.format(Locale.ENGLISH, "The mo is locked because the mo is in synchrnonizing alarm, moId is : %s.", moId), 1L);
                ++failCount;
                this.addOperation(resultList, op.getTargetName(), moId, 1033L);
                continue;
            }
            try {
                this.lockedDeviceWhenDelete.add(moId);
                ManagedObject lmo = resourceDao.getMoByIdAndType(ManagedObject.class, moId, null);
                HashMap<String, String> map = new HashMap<String, String>();
                failCount = this.checkFailNew(lmo, failCount, moId, resultList, op, map);
                if ("true".equals(map.get("flag"))) continue;
                resourceServiceTemp.deleteMo(moId);
            }
            catch (Exception e) {
                LOGGER.error((Object)("delete device failed, moId is : " + moId + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                ++failCount;
                this.addOperation(resultList, op.getTargetName(), moId, 1028L);
                continue;
            }
            finally {
                this.lockedDeviceWhenDelete.remove(moId);
                continue;
            }
            this.addOperation(resultList, op.getTargetName(), moId, 0L);
        }
        this.setBatchopResult(batchOpResult, resultList, failCount, operCount);
        return batchOpResult;
    }

    private void setBatchopResult(BatchOperationResult batchOpResult, List<BatchOperation> resultList, int failCount, int operCount) {
        batchOpResult.setResult(resultList);
        batchOpResult.setFailCount(failCount);
        batchOpResult.setTotalCount(operCount);
        batchOpResult.setSucceedCount(operCount - failCount);
    }

    private void addOperation(List<BatchOperation> resultList, String targetName, long moId, long errorCode) {
        BatchOperation operation = new BatchOperation();
        operation.setErrorCode(errorCode);
        operation.setTargetName(targetName);
        operation.setTargetId(moId);
        resultList.add(operation);
    }

    private int checkFailNew(ManagedObject lmo, int failCount, Long moId, List<BatchOperation> resultList, BatchOperation op, Map<String, String> map) {
        if (lmo == null) {
            LOGGER.warn((Object)("the device has been already deleted, moId is : " + moId), 1L);
            ++failCount;
            this.addOperation(resultList, op.getTargetName(), moId, 1028L);
            map.put("flag", "true");
        } else {
            String key = "mo_uuid_" + lmo.getUuid();
            if (this.cacheService.containsKey((Object)key)) {
                LOGGER.warn((Object)("the device is synchronizing data, moId is : " + moId), 1L);
                ++failCount;
                this.addOperation(resultList, op.getTargetName(), moId, 1028L);
                map.put("flag", "true");
            }
        }
        return failCount;
    }

    public synchronized void setCacheService(ICacheService<String, Object> cacheService) {
        this.cacheService = cacheService;
    }

    public synchronized void setDiscoveryDao(IDiscoveryDao discoveryDao) {
        this.discoveryDao = discoveryDao;
    }

    public void onBind(INodeEditor topoObjectEditor, Map<String, String> map) {
        this.nodeEditorList.add(topoObjectEditor);
        LOGGER.info((Object)String.format(Locale.ENGLISH, "TopoObjectEditor size is : %s.", this.nodeEditorList.size()), 1L);
    }

    public void onUnbind(INodeEditor topoObjectEditor, Map<String, String> map) {
        LOGGER.debug((Object)"onUnbind");
        this.nodeEditorList.remove(topoObjectEditor);
    }

    public void onStart(IManualNodeEditor manualNodeEditor, Map<String, String> map) {
        LOGGER.debug((Object)"onStart");
        this.manualNodeEditorList.add(manualNodeEditor);
    }

    public void onStop(IManualNodeEditor manualNodeEditor, Map<String, String> map) {
        LOGGER.debug((Object)"onStop");
        this.manualNodeEditorList.remove(manualNodeEditor);
    }

    public void onBinding(IDeviceTypeFilter deviceTypeFilter, Map<String, String> map) {
        LOGGER.debug((Object)"onBinding");
        this.deviceTypeFilterList.add(deviceTypeFilter);
    }

    public void onUnbinding(IDeviceTypeFilter deviceTypeFilter, Map<String, String> map) {
        LOGGER.debug((Object)"onUnbinding");
        this.deviceTypeFilterList.remove(deviceTypeFilter);
    }

    public void onStartup(IManagementProtocolAndPageUrlHandler managementProtocolAndPageUrlHandler, Map<String, String> map) {
        List protocolAndUrlList = managementProtocolAndPageUrlHandler.getManagementProtocolPageUrl();
        if (protocolAndUrlList != null) {
            LOGGER.debug((Object)"onStartup:protocolAndUrlList is not null");
            for (ProtocolAndUrl protocolAndUrl : protocolAndUrlList) {
                this.managementProtocolPageUrlMap.put(protocolAndUrl.getPrococolFullClassName(), protocolAndUrl.getModifyPageUrl());
                this.managementProtocolCreatePageUrlMap.put(protocolAndUrl.getPrococolFullClassName(), protocolAndUrl.getCreatePageUrl());
            }
        }
    }

    public void onShutdown(IManagementProtocolAndPageUrlHandler managementProtocolAndPageUrlHandler, Map<String, String> map) {
        List protocolAndUrlList = managementProtocolAndPageUrlHandler.getManagementProtocolPageUrl();
        if (protocolAndUrlList != null) {
            LOGGER.debug((Object)"onShutdown:protocolAndUrlList is not null");
            for (ProtocolAndUrl protocolAndUrl : protocolAndUrlList) {
                this.managementProtocolPageUrlMap.remove(protocolAndUrl.getPrococolFullClassName());
                this.managementProtocolCreatePageUrlMap.remove(protocolAndUrl.getPrococolFullClassName());
            }
        }
    }

    public IMessageCenter getMessageCenter() {
        return this.messageCenter;
    }

    public void setMessageCenter(IMessageCenter messageCenter) {
        this.messageCenter = messageCenter;
    }

    public synchronized void lockDeviceBeforeRefresh(Long moId) {
        LOGGER.debug((Object)"lockDeviceBeforeRefresh");
        this.lockedDeviceWhenRefresh.add(moId);
    }

    public synchronized void unlockDeviceAfterRefresh(Long moId) {
        LOGGER.debug((Object)"unlockDeviceAfterRefresh");
        this.lockedDeviceWhenRefresh.remove(moId);
    }

    public synchronized boolean isDeviceCanRefresh(Long moId) {
        LOGGER.debug((Object)"isDeviceCanRefresh");
        return !this.lockedDeviceWhenDelete.contains(moId);
    }

    private String decode(String encodedChar) {
        if (null == encodedChar) {
            LOGGER.debug((Object)"decode:encodedChar is null");
            return "";
        }
        return encodedChar.replaceAll("&quot;", "\"").replaceAll("&#39;", "'").replaceAll("&#96;", "`").replaceAll("&#37;", "%").replaceAll("&lt;", "<").replaceAll("&gt;", ">").replaceAll("&#40;", "\\(").replaceAll("&#41;", "\\)").replaceAll("&#58;", ":").replaceAll("&#46;", ".");
    }

    public void lockDeviceBeforeSyncAlarm(Long moId) {
        LOGGER.debug((Object)"lockDeviceBeforeSyncAlarm");
        this.lockedDeviceWhenSyncAlarm.add(moId);
    }

    public void unlockDeviceAfterSyncAlarm(Long moId) {
        LOGGER.debug((Object)"unlockDeviceAfterSyncAlarm");
        this.lockedDeviceWhenSyncAlarm.remove(moId);
    }
}

