/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.dao.impl;

import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoExceptionTranslator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.nem.fault.dao.IAlarmDAO;
import com.huawei.lego.nem.fault.dao.impl.AlarmClearProcess;
import com.huawei.lego.nem.fault.launcher.FaultLauncher;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.AlarmSyncTask;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.model.LegoAlarm;
import com.huawei.lego.nem.fault.util.FaultUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.DataAccessUtils;

public class AlarmDAOImpl
extends HibernateDaoSupportWrapper
implements IAlarmDAO {
    private static final List<String> ALARM_ID_LIST = Arrays.asList("0x000803220001", "0x000803220002", "0x000803220003", "0x000803220004", "0x000803220005", "0x323002E", "0x323002F", "0x3230030", "0x3230031", "0x3230033", "0x3230034", "0x3230035", "0x3230036", "0x3230037", "0x3230038", "0x3230039", "0x323003A", "0x323003B", "0x323003C", "0x323003F", "0x3230042", "0x3230043");
    private static final Log LOGGER = LogFactory.getInstance(AlarmDAOImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Alarm affirmAlarm(String id, boolean isAffirm, long time, String user) {
        Alarm alarm;
        LOGGER.info((Object)String.format(Locale.ENGLISH, "AffirmAlarm lock:%s.", System.currentTimeMillis()), 1L);
        FaultLauncher.getInstance().getFaultApi().lock();
        try {
            alarm = this.affirm(id, isAffirm, time, user);
        }
        catch (Throwable throwable) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "AffirmAlarm unlock:%s.", System.currentTimeMillis()), 1L);
            FaultLauncher.getInstance().getFaultApi().unLock();
            throw throwable;
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "AffirmAlarm unlock:%s.", System.currentTimeMillis()), 1L);
        FaultLauncher.getInstance().getFaultApi().unLock();
        return alarm;
    }

    private Alarm affirm(String id, boolean isAffirm, long time, String user) {
        Alarm alarm = null;
        try {
            alarm = FaultLauncher.getInstance().getFaultApi().getAlarmFast(id);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Manual clear alarm failure", (long)101L, null, (Log)LOGGER);
        }
        if (alarm == null) {
            throw new LegoCheckedException(1540L);
        }
        if (1 == alarm.getClearStatus()) {
            throw new LegoCheckedException(1545L);
        }
        this.processAffirm(isAffirm, alarm, time, user);
        try {
            if (FaultLauncher.getInstance().getFaultApi().confirmAlarmAndAnnotation(alarm)) {
                return alarm;
            }
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Affirm alarm failure", (long)101L, null, (Log)LOGGER);
        }
        return null;
    }

    private void processAffirm(boolean isAffirm, Alarm alarm, long time, String user) {
        this.logger.debug((Object)("processAffirm:isAffirm is " + isAffirm));
        if (isAffirm) {
            if (1 == alarm.getConfirmStatus()) {
                throw new LegoCheckedException(1543L);
            }
        } else if (0 == alarm.getConfirmStatus()) {
            throw new LegoCheckedException(1544L);
        }
        if (isAffirm) {
            alarm.setConfirmTime(time);
            alarm.setConfirmUser(user);
            alarm.setConfirmStatus(FaultEnum.ConfirmState.CONFIRMED.getValue());
        } else {
            alarm.setConfirmTime(0L);
            alarm.setConfirmUser("");
            alarm.setConfirmStatus(FaultEnum.ConfirmState.UNCONFIRMED.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Alarm manualClearAlarm(String id, String user, long time) {
        Alarm alarm;
        LOGGER.info((Object)String.format(Locale.ENGLISH, "ManualClearAlarm lock:%s.", System.currentTimeMillis()), 1L);
        FaultLauncher.getInstance().getFaultApi().lock();
        try {
            alarm = this.clearAlarm(id, user, time, false);
        }
        catch (Throwable throwable) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "ManualClearAlarm unlock:%s.", System.currentTimeMillis()), 1L);
            FaultLauncher.getInstance().getFaultApi().unLock();
            throw throwable;
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "ManualClearAlarm unlock:%s.", System.currentTimeMillis()), 1L);
        FaultLauncher.getInstance().getFaultApi().unLock();
        return alarm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Alarm clearOneAlarm(String id, String user, long time, boolean isClearSysAlarm) {
        Alarm alarm;
        LOGGER.info((Object)String.format(Locale.ENGLISH, "ClearOneAlarm lock:%s.", System.currentTimeMillis()), 1L);
        FaultLauncher.getInstance().getFaultApi().lock();
        try {
            alarm = this.clearAlarm(id, user, time, isClearSysAlarm);
        }
        catch (Throwable throwable) {
            LOGGER.info((Object)String.format(Locale.ENGLISH, "ClearOneAlarm unlock:%s.", System.currentTimeMillis()), 1L);
            FaultLauncher.getInstance().getFaultApi().unLock();
            throw throwable;
        }
        LOGGER.info((Object)String.format(Locale.ENGLISH, "ClearOneAlarm unlock:%s.", System.currentTimeMillis()), 1L);
        FaultLauncher.getInstance().getFaultApi().unLock();
        return alarm;
    }

    private Alarm clearAlarm(String id, String user, long time, boolean isClearSysAlarm) {
        block11: {
            Alarm alarm = null;
            try {
                alarm = FaultLauncher.getInstance().getFaultApi().getAlarmFast(id);
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"Manual clear alarm failure", (long)101L, null, (Log)LOGGER);
            }
            if (null == alarm) {
                throw new LegoCheckedException(1540L);
            }
            if (alarm.getClearStatus() == 1) {
                throw new LegoCheckedException(1545L);
            }
            if (!this.judgeAffirm(alarm)) {
                throw new LegoCheckedException(1557L);
            }
            alarm.setClearTime(time);
            alarm.setClearUser(user);
            alarm.setClearStatus(1);
            try {
                LegoAlarm legoAlarm = FaultUtil.alarmToLegoAlarm(alarm);
                if (!isClearSysAlarm && ALARM_ID_LIST.contains(alarm.getAlarmId())) {
                    StringBuffer bufer = new StringBuffer();
                    bufer.append("clear system alarm,alarmId:");
                    bufer.append(alarm.getAlarmId());
                    bufer.append(",alarmName:");
                    bufer.append(alarm.getAlarmName());
                    bufer.append(",moId:");
                    bufer.append(alarm.getMoId());
                    bufer.append(",moName:");
                    bufer.append(alarm.getMoName());
                    LOGGER.debug((Object)bufer.toString(), 1L);
                    throw new LegoCheckedException(1562L);
                }
                if (AlarmClearProcess.clearAlarm(legoAlarm, user)) {
                    if (FaultLauncher.getInstance().getFaultApi().clearAlarmAndAnnotation(alarm)) {
                        return alarm;
                    }
                    break block11;
                }
                throw new LegoCheckedException(1541L);
            }
            catch (LegoCheckedException e) {
                LOGGER.error((Object)"Manual clear alarm failure", (Throwable)e, 1L);
                throw e;
            }
            catch (Exception e) {
                ExceptionUtil.rethrowException((Throwable)e, (String)"Manual clear alarm failure", (long)101L, null, (Log)LOGGER);
            }
        }
        return null;
    }

    @Override
    public Alarm getAlarm(String id) {
        try {
            return (Alarm)super.getHibernateTemplate().get(Alarm.class, (Serializable)((Object)id));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)101L, null, (Log)LOGGER);
            return null;
        }
    }

    @Override
    public List<Alarm> getUnclearedAlarm(String alarmId, Long moId) {
        String hql = "FROM Alarm where alarmId=? and moId=?";
        List alarmList = null;
        try {
            alarmList = super.getHibernateTemplate().find(hql, new Object[]{alarmId, moId});
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)101L, null, (Log)LOGGER);
        }
        return alarmList;
    }

    @Override
    public boolean hasUnclearedAlarm(String entity) {
        String hql = "select 1 from Alarm t where t.entity = ? and t.clearStatus=0";
        try {
            return super.getHibernateTemplate().find(hql, new Object[]{entity}).listIterator().hasNext();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurs when query alarm. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            return false;
        }
    }

    @Override
    public Annotation getAnnotation(long id) {
        try {
            return (Annotation)super.getHibernateTemplate().get(Annotation.class, (Serializable)Long.valueOf(id));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)101L, null, (Log)LOGGER);
            return null;
        }
    }

    private boolean judgeAffirm(Alarm alarm) {
        return alarm.getConfirmStatus() == 1 || alarm.getConfirmStatus() == 0;
    }

    @Override
    public AlarmSyncTask getAlarmSyncTask(long id) {
        try {
            return (AlarmSyncTask)this.getHibernateTemplate().get(AlarmSyncTask.class, (Serializable)Long.valueOf(id));
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"", (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public AlarmSyncTask getAlarmSyncTask(long moId, String moIP, FaultEnum.AlarmSyncType syncType) {
        Session session = null;
        try {
            session = this.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(AlarmSyncTask.class);
            criteria.add((Criterion)Restrictions.eq((String)"moId", (Object)moId));
            criteria.add((Criterion)Restrictions.eq((String)"moIP", (Object)moIP));
            criteria.add((Criterion)Restrictions.eq((String)"taskType", (Object)syncType.getValue()));
            List list = criteria.list();
            if (null != list && !list.isEmpty()) {
                AlarmSyncTask alarmSyncTask = (AlarmSyncTask)list.get(0);
                return alarmSyncTask;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(new StringBuilder().append("get AlarmSyncTask List error, moId: ").append(moId).append(", moIP: ").append(moIP).append(", taskType: ").append(syncType.getValue()) + ", exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    @Override
    public AlarmSyncTask getAlarmSyncTask(long moId, FaultEnum.AlarmSyncType syncType) {
        Session session = null;
        try {
            session = this.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(AlarmSyncTask.class);
            criteria.add((Criterion)Restrictions.eq((String)"moId", (Object)moId));
            criteria.add((Criterion)Restrictions.eq((String)"taskType", (Object)syncType.getValue()));
            List list = criteria.list();
            if (null != list && !list.isEmpty()) {
                AlarmSyncTask alarmSyncTask = (AlarmSyncTask)list.get(0);
                return alarmSyncTask;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)(new StringBuilder().append("get AlarmSyncTask List error, moId: ").append(moId).append(", taskType: ").append(syncType.getValue()) + ", exception: " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
        return null;
    }

    @Override
    public long addAlarmSyncTask(AlarmSyncTask syncTask) {
        try {
            return (Long)super.getHibernateTemplate().save((Object)syncTask);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"", (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void updateAlarmSyncTask(AlarmSyncTask syncTask) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("updateAlarmSyncTask,moId:");
        buffer.append(syncTask.getMoId());
        buffer.append(",moIp:");
        buffer.append(syncTask.getMoIP());
        buffer.append(",moName:");
        buffer.append(syncTask.getMoName());
        buffer.append(",errorCode:");
        buffer.append(syncTask.getErrorCode());
        buffer.append(",alarmCount:");
        buffer.append(syncTask.getResultCount());
        buffer.append(",taskType:");
        buffer.append(syncTask.getTaskType());
        buffer.append(",taskStatus:");
        buffer.append(syncTask.getTaskStatus());
        buffer.append(",update result:");
        try {
            AlarmSyncTask tempTask = (AlarmSyncTask)this.getHibernateTemplate().get(AlarmSyncTask.class, (Serializable)Long.valueOf(syncTask.getId()));
            if (null == tempTask) {
                buffer.append("false,AlarmSyncTask is null.");
                LOGGER.error((Object)buffer.toString(), 1L);
                throw new LegoCheckedException(1568L);
            }
            super.getHibernateTemplate().update((Object)syncTask);
            buffer.append("true.");
            LOGGER.info((Object)buffer.toString(), 1L);
        }
        catch (DataAccessException e) {
            buffer.append("false,DataAccessException.");
            LOGGER.error((Object)buffer.toString(), (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public void deleteAlarmSyncTask(long taskId) {
        try {
            AlarmSyncTask tempTask = (AlarmSyncTask)this.getHibernateTemplate().get(AlarmSyncTask.class, (Serializable)Long.valueOf(taskId));
            if (null == tempTask) {
                throw new LegoCheckedException(1568L);
            }
            super.getHibernateTemplate().delete((Object)tempTask);
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"", (Throwable)e, 1L);
            throw new LegoCheckedException(101L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean delMoRelationInfo(List<Long> moIdList) {
        StringBuffer logBuffer = new StringBuffer();
        logBuffer.append("product call delMoRelationInfo(syn,shield,notify),moId is ");
        if (null == moIdList || moIdList.isEmpty()) {
            logBuffer.append("empty.");
            LOGGER.info((Object)logBuffer.toString(), 1L);
            return false;
        }
        StringBuffer buffer = new StringBuffer();
        int len = moIdList.size();
        for (int i = 0; i < len; ++i) {
            buffer.append('\'');
            buffer.append(moIdList.get(i)).append('\'');
            if (i == len - 1) continue;
            buffer.append(',');
        }
        if ("".equals(buffer.toString())) {
            logBuffer.append("null.");
            LOGGER.info((Object)logBuffer.toString(), 1L);
            return false;
        }
        String moIds = buffer.toString();
        if (moIds.endsWith(",")) {
            moIds = moIds.substring(0, moIds.length() - 1);
        }
        logBuffer.append(moIds);
        LOGGER.info((Object)logBuffer.toString(), 1L);
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.getSessionFactory().openSession();
            transaction = session.beginTransaction();
            int synCount = session.createSQLQuery("delete from T_alarm_synctask where moid in (" + moIds + ")").executeUpdate();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete T_alarm_synctask count:%s.", synCount), 1L);
            int notifyResCount = session.createSQLQuery("delete from T_alarm_notifyresitem where alarmsource in (" + moIds + ")").executeUpdate();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete T_alarm_notifyresitem count:%s.", notifyResCount), 1L);
            transaction.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            HibernateUtil.rollbackSession(session);
            LOGGER.error((Object)(new StringBuilder().append("delMoRelationInfo fail, moId: ").append(moIds) + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    private void closeSession(Session session) {
        HibernateUtil.closeSession(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRedundanceInfo(List<Long> moIdList) {
        StringBuffer logBuffer = new StringBuffer();
        logBuffer.append("deleteRedundanceInfo(syn,shield,notify),moId is ");
        if (null == moIdList || moIdList.isEmpty()) {
            logBuffer.append("empty.");
            LOGGER.info((Object)logBuffer.toString(), 1L);
            return false;
        }
        StringBuffer buffers = new StringBuffer();
        int len = moIdList.size();
        for (int i = 0; i < len; ++i) {
            buffers.append('\'');
            buffers.append(moIdList.get(i)).append('\'');
            if (i == len - 1) continue;
            buffers.append(',');
        }
        if ("".equals(buffers.toString())) {
            logBuffer.append("null.");
            LOGGER.info((Object)logBuffer.toString(), 1L);
            return false;
        }
        String moIds = buffers.toString();
        if (moIds.endsWith(",")) {
            moIds = moIds.substring(0, moIds.length() - 1);
        }
        logBuffer.append(moIds);
        LOGGER.info((Object)logBuffer.toString(), 1L);
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.getSessionFactory().openSession();
            transaction = session.beginTransaction();
            String delAlarmSyncTaskSQL = "delete from T_alarm_synctask where moid not in (:moids)";
            int synCount = session.createSQLQuery(delAlarmSyncTaskSQL).setParameterList("moids", moIdList).executeUpdate();
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete T_alarm_synctask count:%s.", synCount), 1L);
            int notifyResItemCount = this.getNotifyResItemCount(moIdList, session);
            LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete T_alarm_notifyresitem count:%s.", notifyResItemCount), 1L);
            transaction.commit();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            HibernateUtil.rollbackSession(session);
            LOGGER.error((Object)(new StringBuilder().append("deleteRedundanceInfo fail, moId: ").append(moIds) + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    private int getNotifyResItemCount(List<Long> moIdList, Session session) {
        String delAlarmNotifyResitemSQL = "delete from T_alarm_notifyresitem where alarmsource not in (:moids)";
        return session.createSQLQuery(delAlarmNotifyResitemSQL).setParameterList("moids", moIdList).executeUpdate();
    }

    @Override
    public TopoObject getTopoObjectById(long moId) {
        try {
            return (TopoObject)this.getHibernateTemplate().get(TopoObject.class, (Serializable)Long.valueOf(moId));
        }
        catch (DataAccessException e) {
            LOGGER.error((Object)"", (Throwable)e, 1L);
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    @Override
    public int getAlarmCount() {
        int numberOfAlarm = 0;
        try {
            numberOfAlarm = DataAccessUtils.intResult((Collection)this.getHibernateTemplate().find("select count(*) from Alarm", new Object[0]));
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception occurs when query number of alarm.", 1L);
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return numberOfAlarm;
    }

    @Override
    public int getAlarmCountByMoUuid(String moUuid) {
        int numberOfAlarm = 0;
        try {
            DetachedCriteria alarmCriteria = DetachedCriteria.forClass(Alarm.class);
            alarmCriteria.add((Criterion)Restrictions.eq((String)"moUuid", (Object)moUuid));
            alarmCriteria.add((Criterion)Restrictions.eq((String)"clearStatus", (Object)0));
            List alarmList = super.getHibernateTemplate().findByCriteria(alarmCriteria);
            numberOfAlarm = alarmList.size();
        }
        catch (Exception e) {
            LOGGER.warn((Object)"Exception occurs when query top-mo from DB.", 1L);
            LOGGER.warn((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        return numberOfAlarm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getMostSeriousAlarmAndCount(long moId) {
        Session session = null;
        try {
            session = this.getSessionFactory().openSession();
            NativeQuery queryResult = session.createSQLQuery("select severity,count(*) from T_alarm where mo_id=:moId and clear_status=0 group by severity");
            queryResult.setParameter("moId", (Object)moId);
            List objects = queryResult.list();
            Object[] result2 = null;
            for (Object[] result2 : objects) {
            }
            if (null != result2) {
                String severity = String.valueOf(result2[0]);
                String count = String.valueOf(result2[1]);
                String string = severity + "," + count;
                return string;
            }
            String string = "";
            return string;
        }
        catch (Exception e) {
            LOGGER.error((Object)("getMostSeriousAlarmAndCount:" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return "";
    }

    @Override
    public void update(Object entity) {
        super.getHibernateTemplate().update(entity);
    }

    @Override
    public Serializable save(Object entity) {
        return super.getHibernateTemplate().save(entity);
    }

    @Override
    public List<?> findByHql(String hql) {
        return super.getHibernateTemplate().find(hql, new Object[0]);
    }

    @Override
    public List<?> findByHql(String hql, Object[] params) {
        return super.getHibernateTemplate().find(hql, params);
    }

    @Override
    public void remove(Object entity) {
        super.getHibernateTemplate().delete(entity);
        this.logger.debug((Object)"remove:completed");
    }

    @Override
    public int getAnnotationByEntity(String entity) {
        StringBuffer hql = new StringBuffer();
        hql.append("select count(*) from Annotation t where t.entity = ?");
        Long count = (Long)super.getHibernateTemplate().find(hql.toString(), new Object[]{entity}).listIterator().next();
        return count.intValue();
    }
}

