/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.dao.impl;

import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.dao.IFaultDao;
import com.huawei.lego.nem.fault.sdk.model.Alarm;
import com.huawei.lego.nem.fault.sdk.model.Annotation;
import com.huawei.lego.nem.fault.sdk.model.Event;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;

public final class FaultDaoImpl
extends HibernateDaoSupportWrapper
implements IFaultDao {
    private static final int VALUE_1000 = 1000;
    private static final int MAX_SIZE_BATCH = 100;
    private static final Object LOCK_OBJECT = new Object();
    private static final Log LOGGER = LogFactory.getInstance(FaultDaoImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> queryFaults(Class<?> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, FaultQueryInfo queryInfo) {
        int firstRowIndex = queryInfo.getFirstRowIndex();
        int totalRow = queryInfo.getTotalRow();
        String orderByField = queryInfo.getOrderByField();
        boolean orderByAscend = queryInfo.isOrderByAscend();
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(faultType);
            this.setPage(firstRowIndex, totalRow, criteria);
            this.processDefaultOrder(orderByField, orderByAscend, criteria);
            this.processIndexOrder(faultType, orderByField, orderByAscend, criteria);
            if (null == condition) {
                criteria.setLockMode(LockMode.NONE);
                List list = criteria.list();
                return list;
            }
            List<?> list = this.getFaults(faultType, condition, isFaultNameNeedWildcard, criteria);
            return list;
        }
        catch (Exception e) {
            LOGGER.error((Object)("queryFaults exception, query condition is : " + condition + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return null;
    }

    private <T> void processIndexOrder(Class<T> faultType, String orderByField, boolean orderByAscend, Criteria criteria) {
        if (!"id".equals(orderByField) && Annotation.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.extracted(orderByAscend, criteria);
        } else if (!"entity".equals(orderByField) && Alarm.class.getSimpleName().equals(faultType.getSimpleName())) {
            if (orderByAscend) {
                criteria.addOrder(Order.asc((String)"entity"));
            } else {
                criteria.addOrder(Order.desc((String)"entity"));
            }
        } else if (!"id".equals(orderByField) && Event.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.extracted(orderByAscend, criteria);
        }
    }

    private void extracted(boolean orderByAscend, Criteria criteria) {
        if (orderByAscend) {
            criteria.addOrder(Order.asc((String)"id"));
        } else {
            criteria.addOrder(Order.desc((String)"id"));
        }
    }

    private void processDefaultOrder(String orderByField, boolean orderByAscend, Criteria criteria) {
        if (orderByAscend) {
            criteria.addOrder(Order.asc((String)orderByField));
        } else {
            criteria.addOrder(Order.desc((String)orderByField));
        }
    }

    private void setPage(int firstRowIndex, int totalRow, Criteria criteria) {
        if (firstRowIndex >= 0) {
            criteria.setFirstResult(firstRowIndex);
        }
        if (totalRow >= 0) {
            criteria.setMaxResults(totalRow);
        }
    }

    private <T> List<T> getFaults(Class<T> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, Criteria criteria) {
        String nmsIp;
        String projectId;
        String moName = condition.get("moName");
        if (!VerifyUtil.isEmpty((String)moName)) {
            String convertStr = ConverterUtil.convertString(moName.trim(), true);
            criteria.add(Restrictions.ilike((String)"moName", (Object)convertStr));
        }
        if (!VerifyUtil.isEmpty((String)(projectId = condition.get("project_id")))) {
            criteria.add((Criterion)Restrictions.eq((String)"projectId", (Object)projectId));
        }
        this.getDetailCondition(faultType, condition, criteria);
        String loc = condition.get("location");
        if (!VerifyUtil.isEmpty((String)loc)) {
            criteria.add(this.getConbyLoc(loc));
        }
        if (!VerifyUtil.isEmpty((String)(nmsIp = condition.get("nmsIp")))) {
            criteria.add((Criterion)Restrictions.eq((String)"nmsIp", (Object)nmsIp));
        }
        if (Alarm.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.processAlarm(condition, isFaultNameNeedWildcard, criteria);
        } else {
            this.processEvent(condition, isFaultNameNeedWildcard, criteria);
        }
        criteria.setLockMode(LockMode.NONE);
        return criteria.list();
    }

    private <T> void getDetailCondition(Class<T> faultType, Map<String, String> condition, Criteria criteria) {
        if (Annotation.class.getSimpleName().equals(faultType.getSimpleName())) {
            String entity = condition.get("entity");
            if (!VerifyUtil.isEmpty((String)entity)) {
                criteria.add((Criterion)Restrictions.eq((String)"entity", (Object)entity));
            }
        } else {
            String source = condition.get("source");
            if (!VerifyUtil.isEmpty((String)source)) {
                this.dealSource(source, criteria);
            }
        }
    }

    private void dealSource(String source, Criteria criteria) {
        if (source.contains(",")) {
            String[] moIdStrs = source.split(",");
            Object[] moIds = new Long[moIdStrs.length];
            for (int i = 0; i < moIdStrs.length; ++i) {
                try {
                    moIds[i] = Long.parseLong(moIdStrs[i]);
                    continue;
                }
                catch (NumberFormatException ex) {
                    LOGGER.error((Object)("Moid is not number, moid is " + moIdStrs[i]), 1L);
                }
            }
            criteria.add(Restrictions.in((String)"moId", (Object[])moIds));
        } else {
            try {
                criteria.add((Criterion)Restrictions.eq((String)"moId", (Object)Long.parseLong(source)));
            }
            catch (NumberFormatException ex) {
                LOGGER.error((Object)("Source is not number, souce is " + source), 1L);
            }
        }
    }

    private <T> void getFaultsCount(Class<T> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String projectId;
        String moNames = condition.get("moName");
        if (!VerifyUtil.isEmpty((String)moNames)) {
            String convertStrs = ConverterUtil.convertString(moNames.trim(), true);
            hqlBuffer.append(" and lower(alarm.moName) like lower(?)");
            param.put(param.size(), convertStrs);
        }
        String simpleName = faultType.getSimpleName();
        this.processAnnotationDetail(hqlBuffer, param, simpleName, condition);
        String locs = condition.get("location");
        this.getHqlByloc(hqlBuffer, locs, param);
        String nmsIps = condition.get("nmsIp");
        if (!VerifyUtil.isEmpty((String)nmsIps)) {
            hqlBuffer.append(" and alarm.nmsIp = ?");
            param.put(param.size(), nmsIps);
        }
        if (!VerifyUtil.isEmpty((String)(projectId = condition.get("project_id")))) {
            hqlBuffer.append(" and alarm.projectId = ?");
            param.put(param.size(), projectId);
        }
        if (Alarm.class.getSimpleName().equals(faultType.getSimpleName())) {
            this.processAlarm(condition, isFaultNameNeedWildcard, hqlBuffer, param);
        } else {
            this.processEvent(condition, isFaultNameNeedWildcard, hqlBuffer);
        }
    }

    private void processAnnotationDetail(StringBuffer hqlBuffer, Map<Integer, String> param, String simpleName, Map<String, String> condition) {
        if (Annotation.class.getSimpleName().equals(simpleName)) {
            String entitys = condition.get("entity");
            if (!VerifyUtil.isEmpty((String)entitys)) {
                hqlBuffer.append(" and alarm.entity = ?");
                param.put(param.size(), entitys);
            }
        } else {
            String moIds = condition.get("source");
            if (!VerifyUtil.isEmpty((String)moIds)) {
                if (moIds.contains(",")) {
                    this.processMoId(hqlBuffer, moIds, param);
                } else {
                    hqlBuffer.append(" and alarm.moId = ?");
                    param.put(param.size(), moIds);
                }
            }
        }
    }

    private void processEvent(Map<String, String> condition, boolean isFaultNameNeedWildcard, Criteria criteria) {
        String eventType;
        String endTime;
        String startTime;
        String eventName = condition.get("eventName");
        if (!VerifyUtil.isEmpty((String)eventName)) {
            if (isFaultNameNeedWildcard) {
                String convertStr = ConverterUtil.convertString(eventName, true);
                criteria.add(Restrictions.ilike((String)"eventName", (Object)convertStr));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"eventName", (Object)eventName));
            }
        }
        if (!VerifyUtil.isEmpty((String)(startTime = condition.get("createTimeStart")))) {
            criteria.add((Criterion)Restrictions.ge((String)"time", (Object)NumberUtil.convertToLong((Object)startTime)));
        }
        if (!VerifyUtil.isEmpty((String)(endTime = condition.get("createTimeEnd")))) {
            long temp = NumberUtil.convertToLong((Object)endTime) + 1000L;
            criteria.add((Criterion)Restrictions.lt((String)"time", (Object)temp));
        }
        if (!VerifyUtil.isEmpty((String)(eventType = condition.get("eventType"))) && !"0".equalsIgnoreCase(eventType.trim())) {
            criteria.add((Criterion)Restrictions.eq((String)"eventType", (Object)NumberUtil.convertToInteger((Object)eventType)));
        }
    }

    private Criterion getConbyLoc(String loc) {
        String convertStr = ConverterUtil.convertString(loc.trim(), true);
        Criterion cti = Restrictions.ilike((String)"location", (Object)convertStr);
        return cti;
    }

    private void processEvent(Map<String, String> condition, boolean isFaultNameNeedWildcard, StringBuffer hqlBuffer) {
        String eventType;
        String endTime;
        String startTime;
        String eventName = condition.get("eventName");
        if (!VerifyUtil.isEmpty((String)eventName)) {
            if (isFaultNameNeedWildcard) {
                String convertStr = ConverterUtil.convertString(eventName, true);
                hqlBuffer.append(" and lower(alarm.eventName) like lower('");
                hqlBuffer.append(convertStr);
                hqlBuffer.append("')");
            } else {
                hqlBuffer.append(" and alarm.eventName = '");
                hqlBuffer.append(eventName);
                hqlBuffer.append('\'');
            }
        }
        if (!VerifyUtil.isEmpty((String)(startTime = condition.get("createTimeStart")))) {
            hqlBuffer.append(" and alarm.time >= ");
            hqlBuffer.append(NumberUtil.convertToLong((Object)startTime));
        }
        if (!VerifyUtil.isEmpty((String)(endTime = condition.get("createTimeEnd")))) {
            long temp = NumberUtil.convertToLong((Object)endTime) + 1000L;
            hqlBuffer.append(" and alarm.time < ");
            hqlBuffer.append(temp);
        }
        if (!VerifyUtil.isEmpty((String)(eventType = condition.get("eventType"))) && !"0".equalsIgnoreCase(eventType.trim())) {
            hqlBuffer.append(" and alarm.eventType = '");
            hqlBuffer.append(eventType);
            hqlBuffer.append('\'');
        }
    }

    private void processAlarm(Map<String, String> condition, boolean isFaultNameNeedWildcard, Criteria criteria) {
        String endTime;
        String startTime;
        String alarmName = condition.get("alarmName");
        if (!VerifyUtil.isEmpty((String)alarmName)) {
            if (isFaultNameNeedWildcard) {
                String convertStr = ConverterUtil.convertString(alarmName, true);
                criteria.add(Restrictions.ilike((String)"alarmName", (Object)convertStr));
            } else {
                criteria.add((Criterion)Restrictions.eq((String)"alarmName", (Object)alarmName));
            }
        }
        if (!VerifyUtil.isEmpty((String)(startTime = condition.get("createTimeStart")))) {
            criteria.add((Criterion)Restrictions.ge((String)"modTime", (Object)NumberUtil.convertToLong((Object)startTime)));
        }
        if (!VerifyUtil.isEmpty((String)(endTime = condition.get("createTimeEnd")))) {
            long temp = NumberUtil.convertToLong((Object)endTime) + 1000L;
            criteria.add((Criterion)Restrictions.lt((String)"modTime", (Object)temp));
        }
        this.processAlarm2(condition, criteria);
    }

    private StringBuffer getHqlByloc(StringBuffer hqlBuffer, String loc, Map<Integer, String> param) {
        if (!VerifyUtil.isEmpty((String)loc)) {
            String convertStr = ConverterUtil.convertString(loc.trim(), true);
            hqlBuffer.append(" and lower(alarm.location) like lower(?");
            param.put(param.size(), convertStr);
            hqlBuffer.append(')');
        }
        return hqlBuffer;
    }

    private void processAlarm(Map<String, String> condition, boolean isFaultNameNeedWildcard, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String endTimes;
        String startTimes;
        String alarmNames = condition.get("alarmName");
        if (!VerifyUtil.isEmpty((String)alarmNames)) {
            if (isFaultNameNeedWildcard) {
                String convertStrs = ConverterUtil.convertString(alarmNames, true);
                hqlBuffer.append(" and lower(alarm.alarmName) like lower(?)");
                param.put(param.size(), convertStrs);
            } else {
                hqlBuffer.append(" and alarm.alarmName = ?");
                param.put(param.size(), alarmNames);
            }
        }
        if (!VerifyUtil.isEmpty((String)(startTimes = condition.get("createTimeStart")))) {
            hqlBuffer.append(" and alarm.modTime >= ?");
            param.put(param.size(), startTimes);
        }
        if (!VerifyUtil.isEmpty((String)(endTimes = condition.get("createTimeEnd")))) {
            long temp = NumberUtil.convertToLong((Object)endTimes) + 1000L;
            hqlBuffer.append(" and alarm.modTime < ?");
            param.put(param.size(), String.valueOf(temp));
        }
        this.processAlarm2(condition, hqlBuffer, param);
    }

    private void processAlarm2(Map<String, String> condition, Criteria criteria) {
        String alarmType;
        String confirmStatus;
        String severity = condition.get("severity");
        if (!VerifyUtil.isEmpty((String)severity)) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            for (int i = 0; i < severity.length(); ++i) {
                list.add(NumberUtil.convertToInteger((Object)String.valueOf(severity.charAt(i))));
            }
            criteria.add(Restrictions.in((String)"severity", list));
        }
        if (!VerifyUtil.isEmpty((String)(confirmStatus = condition.get("confirmStatus"))) && !String.valueOf(0).equals(confirmStatus.trim())) {
            int status = NumberUtil.convertToInteger((Object)confirmStatus);
            criteria.add((Criterion)Restrictions.eq((String)"confirmStatus", (Object)NumberUtil.convertToInteger((Object)(status - 1))));
        }
        if (!VerifyUtil.isEmpty((String)(alarmType = condition.get("alarmType")))) {
            int type = NumberUtil.convertToInteger((Object)alarmType);
            criteria.add((Criterion)Restrictions.eq((String)"alarmType", (Object)type));
        }
        this.processClearStatus(condition, criteria);
    }

    private void processClearStatus(Map<String, String> condition, Criteria criteria) {
        String clearStatus = condition.get("clearStatus");
        if (!VerifyUtil.isEmpty((String)clearStatus)) {
            criteria.add((Criterion)Restrictions.eq((String)"clearStatus", (Object)NumberUtil.convertToInteger((Object)clearStatus)));
            if (String.valueOf(0).equals(clearStatus)) {
                String filterForThirdDevice = condition.get("isFilterForThirdDevice");
                if (!VerifyUtil.isEmpty((String)filterForThirdDevice) && "1".equals(filterForThirdDevice)) {
                    criteria.add((Criterion)Restrictions.eq((String)"isFilterForThirdDevice", (Object)"1"));
                } else {
                    criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"isFilterForThirdDevice", (Object)"0"), (Criterion)Restrictions.isNull((String)"isFilterForThirdDevice")));
                }
            }
        }
    }

    private void processAlarm2(Map<String, String> condition, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String alarmTypex;
        String confirmStatuses;
        String severitys = condition.get("severity");
        if (!VerifyUtil.isEmpty((String)severitys)) {
            hqlBuffer.append(" and alarm.severity in (");
            for (int i = 0; i < severitys.length(); ++i) {
                hqlBuffer.append("?,");
                param.put(param.size(), String.valueOf(severitys.charAt(i)));
            }
            hqlBuffer.append("'-1')");
        }
        if (!VerifyUtil.isEmpty((String)(confirmStatuses = condition.get("confirmStatus"))) && !String.valueOf(0).equals(confirmStatuses.trim())) {
            int status = NumberUtil.convertToInteger((Object)confirmStatuses);
            hqlBuffer.append(" and alarm.confirmStatus = ?");
            param.put(param.size(), String.valueOf(status - 1));
        }
        if (!VerifyUtil.isEmpty((String)(alarmTypex = condition.get("alarmType")))) {
            hqlBuffer.append(" and alarm.alarmType = ?");
            param.put(param.size(), alarmTypex);
        }
        this.processClearStatus(condition, hqlBuffer, param);
    }

    private void processClearStatus(Map<String, String> condition, StringBuffer hqlBuffer, Map<Integer, String> param) {
        String clearStatuses = condition.get("clearStatus");
        if (!VerifyUtil.isEmpty((String)clearStatuses)) {
            hqlBuffer.append(" and alarm.clearStatus = ?");
            param.put(param.size(), clearStatuses);
            if (String.valueOf(0).equals(clearStatuses)) {
                String filterForThirdDevices = condition.get("isFilterForThirdDevice");
                if (!VerifyUtil.isEmpty((String)filterForThirdDevices) && "1".equals(filterForThirdDevices)) {
                    hqlBuffer.append(" and alarm.isFilterForThirdDevice = '");
                    hqlBuffer.append("1'");
                } else {
                    hqlBuffer.append(" and (alarm.isFilterForThirdDevice is null or alarm.isFilterForThirdDevice != '");
                    hqlBuffer.append("1')");
                }
            }
        }
    }

    @Override
    public int getFaultCount(Class<?> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard) {
        int count = this.getFaultCount2(faultType, condition, isFaultNameNeedWildcard);
        if (-1 == count) {
            count = this.getFaultCount2(faultType, condition, isFaultNameNeedWildcard);
        }
        if (count < 0) {
            count = 0;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> int getFaultCount2(Class<T> faultType, Map<String, String> condition, boolean isFaultNameNeedWildcard) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            StringBuffer hqlBuffer = new StringBuffer("select count(alarm) from ");
            String typeName = faultType.getName();
            hqlBuffer = this.constructAlarmType(hqlBuffer, typeName);
            hqlBuffer.append("as alarm where 0=0");
            if (null == condition) {
                Query query = session.createQuery(hqlBuffer.toString());
                Object object = query.uniqueResult();
                if (null == object) {
                    int n = 0;
                    return n;
                }
                int n = ((Long)object).intValue();
                return n;
            }
            HashMap<Integer, String> param = new HashMap<Integer, String>();
            this.getFaultsCount(faultType, condition, isFaultNameNeedWildcard, hqlBuffer, param);
            Query query = session.createQuery(hqlBuffer.toString());
            Set entrys = param.entrySet();
            for (Map.Entry entry : entrys) {
                query.setString(((Integer)entry.getKey()).intValue(), (String)entry.getValue());
            }
            Object object = query.uniqueResult();
            if (null == object) {
                int n = 0;
                return n;
            }
            int n = ((Long)object).intValue();
            return n;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Query fault exception, query condition is : " + condition + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return -1;
    }

    private StringBuffer constructAlarmType(StringBuffer hqlBuffer, String typeName) {
        if (null != typeName) {
            if (typeName.indexOf("Alarm") >= 0) {
                hqlBuffer.append("Alarm ");
            } else if (typeName.indexOf("Event") >= 0) {
                hqlBuffer.append("Event ");
            } else if (typeName.indexOf("Annotation") >= 0) {
                hqlBuffer.append("Annotation ");
            }
        }
        return hqlBuffer;
    }

    private void processMoId(StringBuffer hqlBuffer, String moId, Map<Integer, String> param) {
        String[] moIds = moId.split(",");
        StringBuffer bufx = new StringBuffer();
        for (int i = 0; i < moIds.length; ++i) {
            if ("".equals(moIds[i].trim())) continue;
            bufx.append('?');
            param.put(param.size(), moIds[i].trim());
            if (i == moIds.length - 1) continue;
            bufx.append(',');
        }
        if (!"".equals(bufx.toString())) {
            hqlBuffer.append(" and alarm.moId in (");
            hqlBuffer.append(bufx + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> getFaultsByIds(Class<?> faultType, List<String> ids, String orderField, boolean orderByAscend) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(faultType);
            if (ids == null || ids.isEmpty()) {
                List list = criteria.list();
                return list;
            }
            criteria.add(Restrictions.in((String)"entity", ids));
            this.processDefaultOrder(orderField, orderByAscend, criteria);
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            LOGGER.error((Object)("getFaultsByIds exception, ids is : " + ids + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFaultsByCondition(Class<?> faultType, Map<String, String> condition) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            try {
                this.doWithTransaction(session -> this.deleteFaultsByConditionInternal(faultType, condition, (Session)session));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Delete alarm or event." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private void deleteFaultsByConditionInternal(Class<?> faultType, Map<String, String> condition, Session session) {
        String endTime;
        String startTime;
        String entity;
        StringBuilder sqlBuilder = new StringBuilder("delete from ");
        sqlBuilder.append(Event.class.getName().equals(faultType.getName()) ? "T_event" : "T_alarm");
        if (null == condition) {
            LOGGER.debug((Object)"construtSQL:condition is null");
            session.createSQLQuery(sqlBuilder.toString()).executeUpdate();
            return;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        sqlBuilder.append(" where ");
        String moId = condition.get("source");
        if (!VerifyUtil.isEmpty((String)moId)) {
            sqlBuilder.append(" mo_id = :moId and ");
            paramMap.put("moId", moId);
        }
        if (!VerifyUtil.isEmpty((String)(entity = condition.get("entity")))) {
            sqlBuilder.append(" entity = :entity and ");
            paramMap.put("entity", entity);
        }
        String timeField = Event.class.getName().equals(faultType.getName()) ? "time" : "mod_time";
        String eventTime = condition.get("ttime");
        if (!VerifyUtil.isEmpty((String)eventTime)) {
            sqlBuilder.append(timeField).append(" = :eventTime and ");
            paramMap.put("eventTime", Long.parseLong(eventTime));
        }
        if (!VerifyUtil.isEmpty((String)(startTime = condition.get("createTimeStart")))) {
            sqlBuilder.append(timeField).append(" > :startTime and ");
            paramMap.put("startTime", Long.parseLong(startTime));
        }
        if (!VerifyUtil.isEmpty((String)(endTime = condition.get("createTimeEnd")))) {
            sqlBuilder.append(timeField).append(" < :endTime and ");
            paramMap.put("endTime", Long.parseLong(endTime));
        }
        NativeQuery query = session.createSQLQuery(sqlBuilder.append("0=0").toString());
        paramMap.forEach((arg_0, arg_1) -> ((NativeQuery)query).setParameter(arg_0, arg_1));
        query.executeUpdate();
    }

    @Override
    public void deleteFaults(Class<?> clazz, List<?> faultList) {
        try {
            this.doWithTransaction(session -> this.deleteFaultsInternal(faultList, (Session)session));
        }
        catch (Exception e) {
            LOGGER.error((Object)("Delete alarm or event." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
    }

    private void deleteFaultsInternal(List<?> faultList, Session session) {
        int count = 0;
        for (Object fault : faultList) {
            session.delete(fault);
            if (++count % 100 != 0) continue;
            session.flush();
            session.clear();
        }
    }

    @Override
    public void deleteHistorys(Class<?> clazz, List<?> faultList) {
        try {
            Set keySet = faultList.stream().filter(fault -> fault instanceof Alarm).map(fault -> ConverterUtil.convertString(((Alarm)fault).getEntity(), false)).collect(Collectors.toSet());
            if (keySet.isEmpty()) {
                return;
            }
            this.doWithTransaction(session -> {
                String sql = "delete from T_annotation where entity in (:keySet)";
                session.createSQLQuery(sql).setParameterList("keySet", (Collection)keySet).executeUpdate();
            });
        }
        catch (Exception eu) {
            LOGGER.error((Object)("Delete alarm or event." + ExceptionUtil.getErrorMessage((Throwable)eu)), 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteHistoryByCondition(Map<String, String> condition) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            try {
                this.doWithTransaction(session -> this.deleteHistoryByConditionInternal(condition, (Session)session));
            }
            catch (Exception e) {
                LOGGER.error((Object)("Delete alarm or event." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            }
        }
    }

    private void deleteHistoryByConditionInternal(Map<String, String> condition, Session session) {
        StringBuilder sql = new StringBuilder("delete from T_annotation ");
        String moId = condition.get("source");
        if (VerifyUtil.isEmpty((String)moId)) {
            session.createSQLQuery(sql.toString()).executeUpdate();
        } else {
            sql.append("where entity in (select entity from T_alarm where mo_id = :moId)");
            session.createSQLQuery(sql.toString()).setParameter("moId", (Object)moId).executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteHistoryOfflineByCondition(Map<String, String> condition) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            try {
                this.doWithTransaction(session -> this.deleteHistoryOfflineByConditionInternal(condition, (Session)session));
            }
            catch (Exception ea) {
                LOGGER.error((Object)("Delete alarm or event." + ExceptionUtil.getErrorMessage((Throwable)ea)), 1L);
            }
        }
    }

    private void deleteHistoryOfflineByConditionInternal(Map<String, String> condition, Session session) {
        StringBuilder sql = new StringBuilder();
        sql.append("delete from T_annotation");
        String entity = condition.get("entity");
        if (VerifyUtil.isEmpty((String)entity)) {
            session.createSQLQuery(sql.toString()).executeUpdate();
        } else {
            sql.append(" where entity = :entity");
            session.createSQLQuery(sql.toString()).setParameter("entity", (Object)entity).executeUpdate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> getEventsByIds(Class<?> faultType, List<Integer> ids, String orderField, boolean orderByAscend) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(faultType);
            if (ids == null || ids.isEmpty()) {
                List list = criteria.list();
                return list;
            }
            ArrayList<Long> longIds = new ArrayList<Long>();
            for (Integer id : ids) {
                longIds.add(NumberUtil.convertToLong((Object)String.valueOf(id)));
            }
            criteria.add(Restrictions.in((String)"id", longIds));
            this.processDefaultOrder(orderField, orderByAscend, criteria);
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            LOGGER.error((Object)("getEventsByIds exception, ids is : " + ids + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteAlarmAndEventByMoID(List<Long> moIdList) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            StringBuilder logBuilder = new StringBuilder("Product call deleteAlarmAndEventByMoID,moId is ");
            if (null == moIdList || moIdList.isEmpty()) {
                logBuilder.append("empty.");
                LOGGER.info((Object)logBuilder.toString(), 1L);
                return false;
            }
            logBuilder.append(StringUtils.join(moIdList, (char)','));
            LOGGER.info((Object)logBuilder.toString(), 1L);
            try {
                this.doWithTransaction(session -> {
                    String historySql = "delete from T_annotation where entity in (select entity from T_alarm where mo_id in (:moIds))";
                    int annotationCount = session.createSQLQuery(historySql).setParameterList("moIds", (Collection)moIdList).executeUpdate();
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete annotation count:%s.", annotationCount), 1L);
                    String alarmSql = "delete from T_alarm where mo_id in (:moIds)";
                    int alarmCount = session.createSQLQuery(alarmSql).setParameterList("moIds", (Collection)moIdList).executeUpdate();
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete alarm count:%s.", alarmCount), 1L);
                    String eventSql = "delete from T_event where mo_id in (:moIds)";
                    int eventCount = session.createSQLQuery(eventSql).setParameterList("moIds", (Collection)moIdList).executeUpdate();
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete event counts:%s.", eventCount), 1L);
                });
                return true;
            }
            catch (Exception em) {
                LOGGER.error((Object)("Delete alarm or event, moId: " + StringUtils.join(moIdList, (char)',') + ExceptionUtil.getErrorMessage((Throwable)em)), 1L);
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteAlarmAndEventBySourceId(List<String> sourceIdList) {
        Object object = LOCK_OBJECT;
        synchronized (object) {
            StringBuilder logBuilder = new StringBuilder("Low Nms call deleteAlarmAndEventBySourceId, sourceId is ");
            if (null == sourceIdList || sourceIdList.isEmpty()) {
                logBuilder.append("empty.");
                LOGGER.info((Object)logBuilder.toString(), 1L);
                return false;
            }
            logBuilder.append(StringUtils.join(sourceIdList, (char)','));
            LOGGER.info((Object)logBuilder.toString(), 1L);
            try {
                this.doWithTransaction(session -> {
                    String historySql = "delete from T_annotation where entity in (select entity from T_alarm where source_id in (:ids) and mo_id = 1)";
                    int annotationCount = session.createSQLQuery(historySql).setParameterList("ids", (Collection)sourceIdList).executeUpdate();
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete nms annotation by uuid count:%s.", annotationCount), 1L);
                    String alarmSql = "delete from T_alarm where source_id in (:ids) and mo_id = 1";
                    int alarmCount = session.createSQLQuery(alarmSql).setParameterList("ids", (Collection)sourceIdList).executeUpdate();
                    LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete nms alarm by uuid count:%s.", alarmCount), 1L);
                });
                return true;
            }
            catch (Exception e) {
                LOGGER.error((Object)("delete lowNms alarm or event,uuIds:" + StringUtils.join(sourceIdList, (char)',') + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
                return false;
            }
        }
    }

    @Override
    public boolean deleteRedundanceInfo(List<Long> moIdList) {
        StringBuilder logBuilder = new StringBuilder();
        logBuilder.append("deleteRedundanceInfo,moId is ");
        if (null == moIdList || moIdList.isEmpty()) {
            logBuilder.append("empty.");
            LOGGER.info((Object)logBuilder.toString(), 1L);
            return false;
        }
        logBuilder.append(StringUtils.join(moIdList, (char)','));
        LOGGER.info((Object)logBuilder.toString(), 1L);
        try {
            this.doWithTransaction(session -> {
                String historySql = "delete from T_annotation where entity in (select entity from T_alarm where mo_id not in (:moIds))";
                int annotationCount = session.createSQLQuery(historySql).setParameterList("moIds", (Collection)moIdList).executeUpdate();
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete annotation count:%s.", annotationCount), 1L);
                String alarmSql = "delete from T_alarm where mo_id not in (:moIds)";
                int alarmCount = session.createSQLQuery(alarmSql).setParameterList("moIds", (Collection)moIdList).executeUpdate();
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete alarm count:%s.", alarmCount), 1L);
                String eventSql = "delete from T_event where mo_id not in (:moIds)";
                int eventCount = session.createSQLQuery(eventSql).setParameterList("moIds", (Collection)moIdList).executeUpdate();
                LOGGER.info((Object)String.format(Locale.ENGLISH, "Delete event count:%s.", eventCount), 1L);
            });
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Delete alarm or event, moId: " + StringUtils.join(moIdList, (char)',') + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            return false;
        }
    }

    @Override
    public boolean updateChildFault(String oldName, String newName, String moId) {
        try {
            this.doWithTransaction(session -> {
                Criteria criteria = session.createCriteria(Alarm.class);
                criteria.add((Criterion)Restrictions.eq((String)"moId", (Object)NumberUtil.convertToLong((Object)moId)));
                criteria.add((Criterion)Restrictions.eq((String)"moName", (Object)oldName));
                List alarmList = criteria.list();
                for (Alarm alarm : alarmList) {
                    alarm.setMoName(newName);
                    session.saveOrUpdate((Object)alarm);
                }
                Criteria criteriaEvent = session.createCriteria(Event.class);
                criteriaEvent.add((Criterion)Restrictions.eq((String)"moId", (Object)NumberUtil.convertToLong((Object)moId)));
                criteriaEvent.add((Criterion)Restrictions.eq((String)"moName", (Object)oldName));
                List eventList = criteriaEvent.list();
                for (Event event : eventList) {
                    event.setMoName(newName);
                    session.saveOrUpdate((Object)event);
                }
            });
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Update moId: " + moId + ", oldName: " + oldName + ", newName: " + newName + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            return false;
        }
    }

    @Override
    public boolean updateFaultMoName(String moId, String name) {
        try {
            this.doWithTransaction(session -> {
                Criteria criteria = session.createCriteria(Alarm.class);
                criteria.add((Criterion)Restrictions.eq((String)"moId", (Object)NumberUtil.convertToLong((Object)moId)));
                List alarmList = criteria.list();
                for (Alarm alarm : alarmList) {
                    alarm.setMoName(name);
                    session.saveOrUpdate((Object)alarm);
                }
                Criteria criteriaEvent = session.createCriteria(Event.class);
                criteriaEvent.add((Criterion)Restrictions.eq((String)"moId", (Object)NumberUtil.convertToLong((Object)moId)));
                List eventList = criteriaEvent.list();
                for (Event event : eventList) {
                    event.setMoName(name);
                    session.saveOrUpdate((Object)event);
                }
            });
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Update moId: " + moId + ", Name: " + name + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long queryMaxOrMinSyncNo(boolean isMax) {
        Session session = null;
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Annotation.class);
            if (isMax) {
                criteria.setProjection((Projection)Projections.max((String)"id"));
            } else {
                criteria.setProjection((Projection)Projections.min((String)"id"));
                criteria.add((Criterion)Restrictions.eq((String)"clearStatus", (Object)FaultEnum.ClearState.UNCLEARED.getValue()));
            }
            List result = criteria.list();
            if (null != result && !result.isEmpty()) {
                Long l = (Long)result.get(0);
                return l;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Annotation> syncAlarmByAaid(long minSynNo, long maxSyncNo) {
        Session session = null;
        ArrayList<Annotation> detailList = new ArrayList();
        try {
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Annotation.class);
            criteria.add((Criterion)Restrictions.ge((String)"id", (Object)minSynNo));
            criteria.add((Criterion)Restrictions.le((String)"id", (Object)maxSyncNo));
            detailList = criteria.list();
        }
        catch (Exception e) {
            LOGGER.error((Object)(new StringBuilder().append("syncAlarmByAaid error, minSynNo: ").append(minSynNo).append(", maxSyncNo: ").append(maxSyncNo) + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return detailList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Alarm> queryAlarms(List<Annotation> detailList) {
        HashMap<String, Alarm> alertMap = new HashMap<String, Alarm>();
        Session session = null;
        try {
            HashSet<String> entityList = new HashSet<String>();
            for (Annotation detail : detailList) {
                entityList.add(detail.getEntity());
            }
            session = super.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(Alarm.class);
            criteria.add(Restrictions.in((String)"entity", entityList));
            List alertList = criteria.list();
            if (null != alertList && !alertList.isEmpty()) {
                for (Alarm alert : alertList) {
                    alertMap.put(alert.getEntity(), alert);
                }
            }
            HibernateUtil.closeSession(session);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)ExceptionUtil.getErrorMessage((Throwable)e), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return alertMap;
    }

    private void doWithTransaction(Consumer<Session> action) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = super.getSessionFactory().openSession();
            transaction = session.beginTransaction();
            action.accept(session);
            transaction.commit();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Action failed. Transaction will be rolled back." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            if (transaction != null) {
                LOGGER.debug((Object)"rollbackTransaction:transaction is not null");
                transaction.rollback();
            }
            throw e;
        }
        finally {
            HibernateUtil.closeSession(session);
        }
    }
}

