/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.dao.impl;

import com.huawei.lego.cbb.resource.sdk.model.TopoObject;
import com.huawei.lego.core.base.persistance.HibernateUtil;
import com.huawei.lego.core.base.persistance.initializer.HibernateDaoSupportWrapper;
import com.huawei.lego.core.base.util.ConverterUtil;
import com.huawei.lego.core.sdk.comm.Paging;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.SpecCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.nem.fault.dao.IRemoteNotifyRuleDAO;
import com.huawei.lego.nem.fault.sdk.model.NotifyAlarmItem;
import com.huawei.lego.nem.fault.sdk.model.NotifyResItem;
import com.huawei.lego.nem.fault.sdk.model.RemoteNotifyRule;
import com.huawei.lego.nem.fault.sdk.service.FaultQueryInfo;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.dao.DataAccessException;

public class RemoteNotifyRuleDAOImpl
extends HibernateDaoSupportWrapper
implements IRemoteNotifyRuleDAO {
    private static final int REMOTE_NOTIFY_RULE_LIMIT = 512;
    private static final Log LOGGER = LogFactory.getInstance(RemoteNotifyRuleDAOImpl.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String addRule(RemoteNotifyRule remoteNotifyRule) {
        List<RemoteNotifyRule> ruleList = this.getRuleByName(remoteNotifyRule.getRuleName());
        if (null != ruleList && !ruleList.isEmpty()) {
            throw new LegoCheckedException(1556L);
        }
        long ruleId = 0L;
        Session session = null;
        Transaction tx = null;
        try {
            session = this.getSessionFactory().openSession();
            tx = session.beginTransaction();
            RemoteNotifyRuleDAOImpl.checkRemoteNotifyRuleCount(session);
            for (NotifyResItem notifyResItem : remoteNotifyRule.getNotifyResItems()) {
                notifyResItem.setRemoteNotifyRule(remoteNotifyRule);
                session.saveOrUpdate((Object)notifyResItem);
            }
            for (NotifyAlarmItem notifyAlarmItem : remoteNotifyRule.getNotifyAlarmItems()) {
                notifyAlarmItem.setRemoteNotifyRule(remoteNotifyRule);
                session.saveOrUpdate((Object)notifyAlarmItem);
            }
            ruleId = (Long)session.save((Object)remoteNotifyRule);
            tx.commit();
        }
        catch (SpecCheckedException e) {
            HibernateUtil.rollbackSession(session);
            throw e;
        }
        catch (Exception e) {
            HibernateUtil.rollbackSession(session);
            ExceptionUtil.rethrowException((Throwable)e, (String)"create notify rule exception.", (long)101L, null, (Log)LOGGER);
        }
        finally {
            this.closeSession(session);
        }
        return String.valueOf(ruleId);
    }

    public static void checkRemoteNotifyRuleCount(Session session) {
        List list = session.createQuery("select count(id) from RemoteNotifyRule").list();
        if (VerifyUtil.isEmpty((Collection)list)) {
            return;
        }
        int count = ((Number)list.get(0)).intValue();
        if (count >= 512) {
            LOGGER.error((Object)"remote_notify_rule_quantity is more than 512");
            throw new SpecCheckedException("remote_notify_rule_quantity", 512L, (long)count);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean deleteRule(RemoteNotifyRule remoteNotifyRule) {
        Session session = null;
        Transaction tx = null;
        try {
            session = this.getSessionFactory().openSession();
            tx = session.beginTransaction();
            Query query1 = session.createQuery("delete from NotifyResItem where remoteNotifyRule.id=" + remoteNotifyRule.getId());
            query1.executeUpdate();
            Query query2 = session.createQuery("delete from NotifyAlarmItem where remoteNotifyRule.id=" + remoteNotifyRule.getId());
            query2.executeUpdate();
            Query query3 = session.createQuery("delete from RemoteNotifyRule where id=" + remoteNotifyRule.getId());
            query3.executeUpdate();
            tx.commit();
        }
        catch (Exception e) {
            HibernateUtil.rollbackSession(session);
            LOGGER.error((Object)("delete notify rule exception." + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return true;
    }

    @Override
    public RemoteNotifyRule getRuleByID(String ruleId) {
        try {
            long id = NumberUtil.convertToInteger((Object)ruleId).intValue();
            RemoteNotifyRule remoteNotifyRule = (RemoteNotifyRule)super.getHibernateTemplate().get(RemoteNotifyRule.class, (Serializable)Long.valueOf(id));
            if (remoteNotifyRule == null) {
                throw new LegoCheckedException(1547L);
            }
            long currentTimex = System.currentTimeMillis();
            if (remoteNotifyRule.isUseEnable() && currentTimex >= remoteNotifyRule.getStartTime() && currentTimex <= remoteNotifyRule.getEndTime()) {
                remoteNotifyRule.setValidStatus(true);
            } else {
                remoteNotifyRule.setValidStatus(false);
            }
            if (currentTimex > remoteNotifyRule.getEndTime()) {
                remoteNotifyRule.setExpiredStatus(true);
            } else {
                remoteNotifyRule.setExpiredStatus(false);
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            remoteNotifyRule.setStartTimeStr(sdf.format(remoteNotifyRule.getStartTime()));
            remoteNotifyRule.setEndTimeStr(sdf.format(remoteNotifyRule.getEndTime()));
            return remoteNotifyRule;
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException(101L, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging getRuleAndCountByCondition(Map<String, Object> condition, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        Paging roPaging = new Paging();
        Session session = null;
        try {
            List ruleList;
            session = this.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(RemoteNotifyRule.class);
            Criteria resCriteria = session.createCriteria(NotifyResItem.class);
            this.processCriteria(firstRowIndex, totalRow, orderByField, orderByAscend, criteria);
            if (null == condition || condition.isEmpty()) {
                ruleList = criteria.list();
            } else {
                this.getRuleByCondition(condition, criteria, resCriteria);
                ruleList = criteria.list();
            }
            this.processRuleList(ruleList);
            roPaging.setData(ruleList);
            Criteria criteria2 = session.createCriteria(RemoteNotifyRule.class);
            Criteria resCriteria2 = session.createCriteria(NotifyResItem.class);
            this.getRuleByCondition(condition, criteria2, resCriteria2);
            criteria2.setProjection(Projections.rowCount());
            int size = ((Number)criteria2.list().get(0)).intValue();
            roPaging.setiCount(size);
        }
        catch (Exception e) {
            LOGGER.error((Object)("query notify rule exception : " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(session);
        }
        return roPaging;
    }

    private void processCriteria(int firstRowIndexs, int totalRows, String orderByFields, boolean orderByAscend, Criteria criteria) {
        if (firstRowIndexs >= 0) {
            criteria.setFirstResult(firstRowIndexs);
        }
        if (totalRows >= 0) {
            criteria.setMaxResults(totalRows);
        }
        String string = orderByFields = "isUseEnable".equals(orderByFields) ? "useEnable" : orderByFields;
        if (orderByAscend) {
            criteria.addOrder(Order.asc((String)orderByFields));
            criteria.addOrder(Order.asc((String)"id"));
        } else {
            criteria.addOrder(Order.desc((String)orderByFields));
            criteria.addOrder(Order.desc((String)"id"));
        }
    }

    private void processRuleList(List<RemoteNotifyRule> ruleList) {
        if (null == ruleList) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (RemoteNotifyRule remoteNotifyRule : ruleList) {
            long currentTime = System.currentTimeMillis();
            if (remoteNotifyRule.isUseEnable() && currentTime >= remoteNotifyRule.getStartTime() && currentTime <= remoteNotifyRule.getEndTime()) {
                remoteNotifyRule.setValidStatus(true);
            } else {
                remoteNotifyRule.setValidStatus(false);
            }
            if (currentTime > remoteNotifyRule.getEndTime()) {
                remoteNotifyRule.setExpiredStatus(true);
            } else {
                remoteNotifyRule.setExpiredStatus(false);
            }
            remoteNotifyRule.setStartTimeStr(sdf.format(remoteNotifyRule.getStartTime()));
            remoteNotifyRule.setEndTimeStr(sdf.format(remoteNotifyRule.getEndTime()));
        }
    }

    private void getRuleByCondition(Map<String, Object> condition, Criteria criteria, Criteria resCriteria) {
        if (condition != null) {
            String resNames;
            String ruleNames;
            String ruleId = (String)condition.get("id");
            if (null != ruleId && !"".equals(ruleId.trim())) {
                criteria.add((Criterion)Restrictions.eq((String)"id", (Object)NumberUtil.convertToLong((Object)ruleId)));
            }
            if (null != (ruleNames = (String)condition.get("ruleName")) && !"".equals(ruleNames.trim())) {
                String destString = ConverterUtil.convertString(ruleNames.trim(), true);
                criteria.add(Restrictions.ilike((String)"ruleName", (Object)destString));
            }
            if (null != (resNames = (String)condition.get("moName")) && !"".equals(resNames.trim())) {
                String destString = ConverterUtil.convertString(resNames.trim(), true);
                resCriteria.add(Restrictions.ilike((String)"moName", (Object)destString));
                List resList = resCriteria.list();
                HashSet<Long> rule = new HashSet<Long>();
                rule.add(0L);
                for (NotifyResItem res : resList) {
                    rule.add(res.getRemoteNotifyRule().getId());
                }
                criteria.add(Restrictions.in((String)"id", rule));
            }
        }
    }

    @Override
    public TopoObject getTopoObjectById(long moId) {
        TopoObject topoOb = null;
        List topoObListq = null;
        topoObListq = super.getHibernateTemplate().find("from TopoObject u where u.moId=?", new Object[]{moId});
        if (topoObListq != null && !topoObListq.isEmpty()) {
            return (TopoObject)topoObListq.get(0);
        }
        return topoOb;
    }

    @Override
    public boolean modifyBaseRule(RemoteNotifyRule remoteNotifyRule) {
        try {
            super.getHibernateTemplate().saveOrUpdate((Object)remoteNotifyRule);
            return true;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)101L, null, (Log)LOGGER);
            return false;
        }
    }

    @Override
    public boolean addAlarm(Set<NotifyAlarmItem> alarmSet) {
        try {
            for (NotifyAlarmItem item : alarmSet) {
                super.getHibernateTemplate().saveOrUpdate((Object)item);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("add alarm exception in notify rule : " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            return false;
        }
    }

    @Override
    public boolean addResource(Set<NotifyResItem> resSet) {
        try {
            for (NotifyResItem item : resSet) {
                super.getHibernateTemplate().saveOrUpdate((Object)item);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error((Object)("add resource exception in notify rule : " + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
            return false;
        }
    }

    @Override
    public boolean deleteAlarmItem(NotifyAlarmItem notifyAlarmItem) {
        try {
            super.getHibernateTemplate().delete((Object)notifyAlarmItem);
            return true;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)101L, null, (Log)LOGGER);
            return false;
        }
    }

    @Override
    public boolean deleteResourceItem(NotifyResItem notifyResItem) {
        try {
            super.getHibernateTemplate().delete((Object)notifyResItem);
            return true;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)101L, null, (Log)LOGGER);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NotifyResItem> getResourceItem(String alarmSource) {
        Session session = null;
        try {
            session = this.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(NotifyResItem.class);
            criteria.add((Criterion)Restrictions.eq((String)"alarmSource", (Object)alarmSource));
            List list = criteria.list();
            return list;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)101L, null, (Log)LOGGER);
            List<NotifyResItem> list = null;
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public boolean deleteResourceItems(List<NotifyResItem> resList) {
        try {
            super.getHibernateTemplate().deleteAll(resList);
            return true;
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)101L, null, (Log)LOGGER);
            return false;
        }
    }

    @Override
    public NotifyAlarmItem getAlarmItem(long id) {
        try {
            return (NotifyAlarmItem)super.getHibernateTemplate().get(NotifyAlarmItem.class, (Serializable)Long.valueOf(id));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, null, (long)101L, null, (Log)LOGGER);
            return null;
        }
    }

    @Override
    public NotifyResItem getResourceItem(long id) {
        try {
            return (NotifyResItem)super.getHibernateTemplate().get(NotifyResItem.class, (Serializable)Long.valueOf(id));
        }
        catch (Exception em) {
            ExceptionUtil.rethrowException((Throwable)em, null, (long)101L, null, (Log)LOGGER);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging queryAlarmItem(String ruleId, String alarmLevel, int firstRowIndex, int totalRow, String orderByField, boolean orderByAscend) {
        Session session = null;
        Paging roPaging = new Paging();
        try {
            session = this.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(NotifyAlarmItem.class);
            Criteria criteria2 = session.createCriteria(NotifyAlarmItem.class);
            this.processCriteria(firstRowIndex, totalRow, orderByField, orderByAscend, criteria);
            if (null != alarmLevel && !"".equals(alarmLevel) && !"0".equals(alarmLevel)) {
                criteria.add((Criterion)Restrictions.eq((String)"alarmLevel", (Object)NumberUtil.convertToInteger((Object)alarmLevel)));
                criteria2.add((Criterion)Restrictions.eq((String)"alarmLevel", (Object)NumberUtil.convertToInteger((Object)alarmLevel)));
            }
            criteria.createCriteria("remoteNotifyRule").add((Criterion)Restrictions.eq((String)"id", (Object)NumberUtil.convertToLong((Object)ruleId)));
            List alarmList = criteria.list();
            roPaging.setData(alarmList);
            criteria2.createCriteria("remoteNotifyRule").add((Criterion)Restrictions.eq((String)"id", (Object)NumberUtil.convertToLong((Object)ruleId)));
            criteria2.setProjection(Projections.rowCount());
            int size = (Integer)criteria2.list().get(0);
            roPaging.setiCount(size);
        }
        catch (Exception e) {
            LOGGER.error((Object)("query shield alarm exception, alarm level is : " + alarmLevel + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            HibernateUtil.closeSession(session);
        }
        return roPaging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Paging queryResourceItem(String ruleId, String name, FaultQueryInfo queryInfo, List<String> moIdList) {
        int firstRowIndex = queryInfo.getFirstRowIndex();
        int totalRow = queryInfo.getTotalRow();
        String orderByField = queryInfo.getOrderByField();
        boolean orderByAscend = queryInfo.isOrderByAscend();
        Session sessionsx = null;
        Paging roPaging = new Paging();
        try {
            sessionsx = this.getSessionFactory().openSession();
            Criteria criteriax = sessionsx.createCriteria(NotifyResItem.class);
            this.processCriteria(firstRowIndex, totalRow, orderByField, orderByAscend, criteriax);
            if (null == name) {
                name = "";
            }
            String destString = ConverterUtil.convertString(name.trim(), true);
            criteriax.add(Restrictions.ilike((String)"moName", (Object)destString));
            criteriax.createCriteria("remoteNotifyRule").add((Criterion)Restrictions.eq((String)"id", (Object)NumberUtil.convertToLong((Object)ruleId)));
            List alarmList = criteriax.list();
            roPaging.setData(alarmList);
            Criteria criteria2 = sessionsx.createCriteria(NotifyResItem.class);
            criteria2.add(Restrictions.ilike((String)"moName", (Object)destString));
            criteria2.createCriteria("remoteNotifyRule").add((Criterion)Restrictions.eq((String)"id", (Object)NumberUtil.convertToLong((Object)ruleId)));
            criteria2.setProjection(Projections.rowCount());
            int size = (Integer)criteria2.list().get(0);
            roPaging.setiCount(size);
        }
        catch (Exception e) {
            LOGGER.error((Object)("query shield alarm exception, alarm name is : " + name + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        finally {
            this.closeSession(sessionsx);
        }
        return roPaging;
    }

    private void closeSession(Session session) {
        HibernateUtil.closeSession(session);
    }

    @Override
    public int updateResourceIp(String ip, long moId) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.getSessionFactory().openSession();
            transaction = session.beginTransaction();
            StringBuffer hql = new StringBuffer();
            hql.append("update NotifyResItem set moIP = ? ");
            hql.append(" where alarmSource = '");
            hql.append(moId);
            hql.append('\'');
            Query query = session.createQuery(hql.toString());
            query.setString(0, ip);
            int result = query.executeUpdate();
            transaction.commit();
            int n = result;
            return n;
        }
        catch (Exception ex) {
            HibernateUtil.rollbackSession(session);
            throw ExceptionUtil.convertException((Throwable)ex, (String)"Failed to update NotifyResItem", (long)-1L, null, (Log)LOGGER);
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public boolean isExistRuleName(String ruleName) {
        try {
            List<RemoteNotifyRule> ruleList = this.getRuleByName(ruleName);
            if (null != ruleList && !ruleList.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)("isExistRuleName" + ExceptionUtil.getErrorMessage((Throwable)e)), 1L);
        }
        return false;
    }

    private List<RemoteNotifyRule> getRuleByName(String ruleName) {
        Session session = null;
        try {
            session = this.getSessionFactory().openSession();
            Criteria criteria = session.createCriteria(RemoteNotifyRule.class);
            if (null != ruleName && !"".equals(ruleName.trim())) {
                criteria.add((Criterion)Restrictions.eq((String)"ruleName", (Object)ruleName));
            }
            List list = criteria.list();
            return list;
        }
        catch (DataAccessException e) {
            throw new LegoCheckedException(101L, (Throwable)e);
        }
        finally {
            this.closeSession(session);
        }
    }
}

