/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.lego.nem.fault.service;

import com.huawei.lego.core.sdk.base.BaseService;
import com.huawei.lego.core.sdk.base.annotation.Service;
import com.huawei.lego.core.sdk.comm.BatchOperation;
import com.huawei.lego.core.sdk.comm.BatchOperationResult;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUncheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.nem.fault.dao.IAlertExperienceDAO;
import com.huawei.lego.nem.fault.sdk.model.AlertExperience;
import com.huawei.lego.nem.fault.sdk.service.IAlertExperienceService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@Service(name="alertExperienceService", desc="", interfaceClass=IAlertExperienceService.class)
public class AlertExperienceService
extends BaseService
implements IAlertExperienceService {
    private static final int VALUE_10 = 10;
    private static final Log logger = LogFactory.getInstance(AlertExperienceService.class);
    private IAlertExperienceDAO alertExperienceDAO = null;

    public Long addAlertExperience(AlertExperience alertExperience) {
        if (null == alertExperience) {
            logger.error((Object)"addAlertExperience error:alertExperience is null.", 653110170222597L);
            return -1L;
        }
        boolean result = this.isNullOrEmpty(alertExperience.getAlertId(), alertExperience.getExperience(), alertExperience.getUserName());
        if (result) {
            return null;
        }
        List<AlertExperience> expList = this.alertExperienceDAO.getAlertExperiences(alertExperience.getAlertId());
        if (expList.size() >= 10) {
            throw new LegoCheckedException(1569L);
        }
        if (alertExperience.getTime() <= 0L) {
            long time = new Date().getTime();
            alertExperience.setTime(time);
        }
        return this.alertExperienceDAO.addAlertExperience(alertExperience);
    }

    public Long addAlertExperience(String alertId, String userName, String experience) {
        String id = AlertExperienceService.convertEntity(alertId);
        boolean result = this.isNullOrEmpty(id, experience, userName);
        if (result) {
            return null;
        }
        List<AlertExperience> expList = this.alertExperienceDAO.getAlertExperiences(alertId);
        if (expList.size() >= 10) {
            throw new LegoCheckedException(1569L);
        }
        AlertExperience alertExperience = new AlertExperience();
        alertExperience.setAlertId(alertId);
        alertExperience.setExperience(experience);
        alertExperience.setUserName(userName);
        long time = new Date().getTime();
        alertExperience.setTime(time);
        return this.alertExperienceDAO.addAlertExperience(alertExperience);
    }

    public AlertExperience deleteAlertExperience(long id) {
        return this.alertExperienceDAO.deleteAlertExperience(id);
    }

    public BatchOperationResult deleteAlertExperiences(List<BatchOperation> ids) {
        BatchOperationResult result = new BatchOperationResult();
        ArrayList<BatchOperation> resultList = new ArrayList<BatchOperation>();
        int fail = 0;
        int operCount = 0;
        if (ids != null) {
            operCount = ids.size();
            for (BatchOperation batchOperation : ids) {
                fail = this.deleteAlertExperiences(fail, batchOperation);
                resultList.add(batchOperation);
            }
        }
        result.setResult(resultList);
        result.setFailCount(fail);
        result.setTotalCount(operCount);
        result.setSucceedCount(operCount - fail);
        return result;
    }

    private int deleteAlertExperiences(int fail, BatchOperation batchOperation) {
        try {
            AlertExperience alertExperience = this.alertExperienceDAO.getAlertExperience(batchOperation.getTargetId());
            this.alertExperienceDAO.deleteAlertExperience(alertExperience);
        }
        catch (LegoCheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        catch (LegoUncheckedException e) {
            ++fail;
            batchOperation.setErrorCode(e.getErrorCode());
        }
        return fail;
    }

    public List<AlertExperience> deleteAlertExperiences(String alertId) {
        String id = AlertExperienceService.convertEntity(alertId);
        return this.alertExperienceDAO.deleteAlertExperiences(id);
    }

    public AlertExperience getAlertExperience(long id) {
        return this.alertExperienceDAO.getAlertExperience(id);
    }

    public List<AlertExperience> getAlertExperiences(String alertId) {
        String id = AlertExperienceService.convertEntity(alertId);
        return this.alertExperienceDAO.getAlertExperiences(id);
    }

    public long getCountByAlertID(String alertId) {
        String id = AlertExperienceService.convertEntity(alertId);
        return this.alertExperienceDAO.getCountByAlertID(id);
    }

    public long getTotalCount() {
        return this.alertExperienceDAO.getTotalCount();
    }

    public boolean modifyAlertExperience(long id, String userName, String experience) {
        if (null == userName || "".equals(userName) || null == experience || "".equals(experience)) {
            return false;
        }
        return this.alertExperienceDAO.modifyAlertExperience(id, userName, experience);
    }

    private boolean isNullOrEmpty(String alertId, String experience, String userName) {
        if (null == alertId || "".equals(alertId)) {
            return true;
        }
        if (null == experience || "".equals(experience)) {
            return true;
        }
        return null == userName || "".equals(userName);
    }

    private static String convertEntity(String entity) {
        if (entity == null) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < entity.length(); ++i) {
            char c = entity.charAt(i);
            if (c == '\\') {
                ++i;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    public IAlertExperienceDAO getAlertExperienceDAO() {
        return this.alertExperienceDAO;
    }

    public void setAlertExperienceDAO(IAlertExperienceDAO alertExperienceDAO) {
        this.alertExperienceDAO = alertExperienceDAO;
    }
}

