/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.configbackup;

import com.huawei.ism.drm.configbackup.ExceptionUtil;
import com.huawei.ism.drm.configbackup.GaussDBrestoreImpl;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class AESUtil {
    private static final Log LOG = LogFactory.getInstance(AESUtil.class);
    private static final int ITERATION_COUNT = 50000;
    private static final int KEY_LEN = 128;
    private static final int SM4_KEY_LEN = 16;
    private static final String ALGORITHM_NAME_SM3 = "SM3";
    private static final String ALGORITHM_NAME_CBC_PADDING = "SM4/CBC/PKCS5Padding";
    private static final String ALGORITHM_NAME_GCM_NOPADDING = "SM4/GCM/NoPadding";
    private static final String AES_CBC_MODE = "AES/CBC/PKCS5Padding";
    private static final String AES_GCM_MODE = "AES/GCM/PKCS5Padding";
    private static final String ALGORITHM_NAME_SM4 = "SM4";
    private static AESUtil instance = new AESUtil();

    private AESUtil() {
    }

    public static AESUtil getInstance() {
        return instance;
    }

    private static Cipher initAESCipher(String sKey, boolean isDecryptByGCM) {
        Cipher cipher = null;
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            byte[] salt = GaussDBrestoreImpl.getSalt();
            byte[] iv = GaussDBrestoreImpl.getIV();
            PBEKeySpec keyspec = new PBEKeySpec(sKey.toCharArray(), salt, 50000, 128);
            SecretKeySpec key = new SecretKeySpec(factory.generateSecret(keyspec).getEncoded(), "AES");
            if (isDecryptByGCM) {
                GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
                cipher = Cipher.getInstance(AES_GCM_MODE);
                cipher.init(2, (Key)key, gcmSpec);
            } else {
                IvParameterSpec ivSpec = new IvParameterSpec(iv);
                cipher = Cipher.getInstance(AES_CBC_MODE);
                cipher.init(2, (Key)key, ivSpec);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("InvalidKeyException when initAESCipher!" + ExceptionUtil.getErrorMessage(e)), "");
        }
        return cipher;
    }

    public File decryptFile(File sourceFile, String fileType, String sKey) {
        File decryptFile = this.getDecryptFile(sourceFile, fileType, sKey, true);
        if (decryptFile == null || decryptFile.length() <= 0L) {
            decryptFile = this.getDecryptFile(sourceFile, fileType, sKey, false);
        }
        return decryptFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getDecryptFile(File sourceFile, String fileType, String sKey, boolean isDecryptByGCM) {
        File decryptFile;
        FileInputStream inputStream = null;
        FileOutputStream outputStream = null;
        CipherOutputStream cipherOutputStream = null;
        try {
            int readLen;
            decryptFile = File.createTempFile("apmrestore", fileType);
            Cipher cipher = this.initCipher(sKey, isDecryptByGCM);
            inputStream = new FileInputStream(sourceFile);
            outputStream = new FileOutputStream(decryptFile);
            cipherOutputStream = new CipherOutputStream(outputStream, cipher);
            byte[] buffer = new byte[1024];
            while ((readLen = ((InputStream)inputStream).read(buffer)) >= 0) {
                cipherOutputStream.write(buffer, 0, readLen);
                cipherOutputStream.flush();
            }
        }
        catch (Exception e) {
            File file;
            try {
                LOG.error((Object)("IOException when decryptFile!" + ExceptionUtil.getErrorMessage(e)), "");
                file = null;
            }
            catch (Throwable throwable) {
                AESUtil.releaseStream(cipherOutputStream);
                AESUtil.releaseStream(inputStream);
                AESUtil.releaseStream(outputStream);
                throw throwable;
            }
            AESUtil.releaseStream(cipherOutputStream);
            AESUtil.releaseStream(inputStream);
            AESUtil.releaseStream(outputStream);
            return file;
        }
        AESUtil.releaseStream(cipherOutputStream);
        AESUtil.releaseStream(inputStream);
        AESUtil.releaseStream(outputStream);
        return decryptFile;
    }

    private Cipher initCipher(String sKey, boolean isDecryptByGCM) {
        if (GaussDBrestoreImpl.isIsSaltFileExist()) {
            return AESUtil.initAESCipher(sKey, isDecryptByGCM);
        }
        return this.initSM4Cipher(sKey, isDecryptByGCM);
    }

    private Cipher initSM4Cipher(String sKey, boolean isDecryptByGCM) {
        Cipher cipher = null;
        try {
            this.addBCProvider();
            MessageDigest digest = MessageDigest.getInstance(ALGORITHM_NAME_SM3, "BC");
            byte[] key = digest.digest(sKey.getBytes(StandardCharsets.UTF_8));
            byte[] keyData = Arrays.copyOfRange(key, 0, 16);
            byte[] iv = GaussDBrestoreImpl.getIV();
            cipher = Cipher.getInstance(isDecryptByGCM ? ALGORITHM_NAME_GCM_NOPADDING : ALGORITHM_NAME_CBC_PADDING, "BC");
            SecretKeySpec sm4Key = new SecretKeySpec(keyData, ALGORITHM_NAME_SM4);
            IvParameterSpec ivParameterSpec = new IvParameterSpec(iv);
            cipher.init(2, (Key)sm4Key, ivParameterSpec);
            return cipher;
        }
        catch (Exception e) {
            LOG.error((Object)("InvalidKeyException when initSM4Cipher!" + ExceptionUtil.getErrorMessage(e)), "");
            return cipher;
        }
    }

    private void addBCProvider() {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    private static void releaseStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Release Stream is Error:", e.getMessage());
            }
        }
    }
}

