/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dbtool;

import com.huawei.common.CmdUtil;
import com.huawei.dbtool.ConfigFailoverMode;
import com.huawei.dbtool.DataBaseInfo;
import com.huawei.lego.common.util.SysConfigDataUtil;
import com.huawei.lego.common.util.SystemExitUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.lego.install.log.Log;
import com.huawei.lego.install.log.LogFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class DBTool {
    private static final Log logger = LogFactory.getInstance(DBTool.class);
    private static final int EXIT_FAILED = 1;
    private static final int ARGSLEN = 1;
    private static final String GS_CTL = "/gs/bin/control.sh";

    public static void main(String[] stringArray) {
        if (VerifyUtil.isEmpty((Object[])stringArray)) {
            logger.error((Object)"Exec cmd failed: param error!");
            SystemExitUtil.exitFail();
        }
        String string = stringArray[0];
        int n = 1;
        try {
            Object object;
            if ("configAutoFailover".equals(string)) {
                if (stringArray.length < 3) {
                    logger.error((Object)"Exec cmd failed: param error!");
                    SystemExitUtil.exitFail();
                }
                object = new ConfigFailoverMode();
                ((ConfigFailoverMode)object).configAutoFailover(stringArray[1], stringArray[2]);
            }
            if ("backup".equals(string)) {
                if (stringArray.length < 2) {
                    logger.error((Object)"Exec cmd failed: param error!");
                    SystemExitUtil.exitFail();
                }
                object = new DataBaseInfo(true);
                SysConfigDataUtil.backupSystemData((String)stringArray[1], (String)((DataBaseInfo)object).getDbaPwd(), (boolean)true);
                System.exit(0);
            }
            if ("queryAutoFailover".equals(string)) {
                if (stringArray.length < 2) {
                    logger.error((Object)"Exec cmd failed: param error!");
                    SystemExitUtil.exitFail();
                }
                object = new ConfigFailoverMode();
                ((ConfigFailoverMode)object).queryAutoFailover(stringArray[1]);
                SystemExitUtil.exitOK();
            }
            DBTool.checkParameter(stringArray);
            n = DBTool.operation(new DataBaseInfo(false), string);
        }
        catch (Exception exception) {
            logger.error((Object)("Exec cmd failed: " + ExceptionUtil.getErrorMessage((Throwable)exception)), "");
        }
        System.exit(n);
    }

    private static void checkParameter(String[] stringArray) throws IOException {
        String string = new File("../").getCanonicalPath();
        String string2 = string + GS_CTL;
        File file = new File(string2);
        if (!file.exists()) {
            throw new FileNotFoundException("Can't find the control.sh.");
        }
        if (stringArray.length != 1 || !"query".equals(stringArray[0]) && !"switchover".equals(stringArray[0]) && !"failover".equals(stringArray[0])) {
            logger.error((Object)"Parameter error, a operation type is need.", "");
            throw new IOException("CheckParameter failed.");
        }
    }

    private static int operation(DataBaseInfo dataBaseInfo, String string) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("sudo -u GaussDB -S ");
        String string2 = new File("../").getCanonicalPath();
        stringBuffer.append(string2).append(GS_CTL);
        stringBuffer.append(" ").append(string);
        stringBuffer.append(" ");
        stringBuffer.append(dataBaseInfo.getManagerUser());
        stringBuffer.append(" ");
        stringBuffer.append(dataBaseInfo.getDbDataPath());
        return CmdUtil.exec(stringBuffer.toString());
    }
}

