/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huawei.ism.cbb.base.task.AbstractBackTask;
import com.huawei.ism.drm.cert.sdk.model.CertUse;
import com.huawei.ism.drm.cert.sdk.model.CertificateOperateStatus;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.ICertificateService;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;

public class CertificateSummary
implements Serializable,
Cloneable {
    public static final int DEFAULT_KEY_SIZE = 2048;
    private static final long serialVersionUID = 6533807025038625496L;
    private String certName;
    private String use;
    private String certFormat;
    private String subjectName;
    private String strExtentions;
    private String keyAlgorithm = "rsa";
    private int keySize = 2048;
    private String notBefore;
    private String notAfter;
    private String description;
    private String dependServiceName;
    private String dependCertName;
    private String dependCertFormat;
    private String dependType;
    private Map<String, Object> extendMap;
    private Boolean supportSM = false;
    private Integer caType = 0;
    private String certUsage = "COMMON";
    private List<CertificateSummary> smCertList;
    @JsonIgnore
    private String type;
    @JsonIgnore
    private String category;
    @JsonIgnore
    private String certType;
    @JsonIgnore
    private Integer priority = 1;
    @JsonIgnore
    private List<CertificateSummary> children = new ArrayList<CertificateSummary>();
    @JsonIgnore
    private transient ICertificateService certificateService;

    public CertificateSummary() {
    }

    public CertificateSummary(String certName, String certFormat) {
        this.certName = certName;
        this.certFormat = certFormat;
    }

    public String getCertName() {
        return this.certName;
    }

    public void setCertName(String certName) {
        this.certName = certName;
    }

    public String getUse() {
        return this.use;
    }

    public void setUse(String use) {
        this.use = this.cast(use);
    }

    public String getCertFormat() {
        return this.certFormat;
    }

    public void setCertFormat(String certFormat) {
        this.certFormat = certFormat;
    }

    public String getSubjectName() {
        return this.subjectName;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public String getStrExtentions() {
        return this.strExtentions;
    }

    public void setStrExtentions(String strExtentions) {
        this.strExtentions = strExtentions;
    }

    public String getKeyAlgorithm() {
        return this.keyAlgorithm;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setKeySize(int keySize) {
        this.keySize = keySize;
    }

    public String getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(String notBefore) {
        this.notBefore = notBefore;
    }

    public String getNotAfter() {
        return this.notAfter;
    }

    public void setNotAfter(String notAfter) {
        this.notAfter = notAfter;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDependServiceName() {
        return this.dependServiceName;
    }

    public void setDependServiceName(String dependServiceName) {
        this.dependServiceName = dependServiceName;
    }

    public String getDependCertName() {
        return this.dependCertName;
    }

    public void setDependCertName(String dependCertName) {
        this.dependCertName = dependCertName;
    }

    public String getDependCertFormat() {
        return this.dependCertFormat;
    }

    public void setDependCertFormat(String dependCertFormat) {
        this.dependCertFormat = dependCertFormat;
    }

    public String getDependType() {
        return this.dependType;
    }

    public void setDependType(String dependType) {
        this.dependType = this.cast(dependType);
    }

    public Map<String, Object> getExtendMap() {
        return this.extendMap;
    }

    public void setExtendMap(Map<String, Object> extendMap) {
        this.extendMap = extendMap;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public List<CertificateSummary> getChildren() {
        return this.children;
    }

    public void setChildren(List<CertificateSummary> children) {
        this.children = children;
    }

    public ICertificateService getCertificateService() {
        return this.certificateService;
    }

    public void setCertificateService(ICertificateService certificateService) {
        this.certificateService = certificateService;
    }

    private String cast(String useInfo) {
        return Optional.ofNullable(CertUse.get(useInfo)).map(CertUse::toString).orElse(null);
    }

    public String getCertType() {
        return this.certType;
    }

    public void setCertType(String certType) {
        this.certType = certType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + JSONObject.fromObject((Object)this);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Boolean getSupportSM() {
        return this.supportSM;
    }

    public void setSupportSM(Boolean supportSM) {
        this.supportSM = supportSM;
    }

    public Integer getCaType() {
        return this.caType;
    }

    public void setCaType(Integer caType) {
        this.caType = caType;
    }

    public String getCertUsage() {
        return this.certUsage;
    }

    public void setCertUsage(String certUsage) {
        this.certUsage = certUsage;
    }

    public List<CertificateSummary> getSmCertList() {
        return this.smCertList;
    }

    public void setSmCertList(List<CertificateSummary> smCertList) {
        this.smCertList = smCertList;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public CertificateOperateStatus submitCertificateUpdateTask(BlockingQueue<? extends AbstractBackTask> queue, CertificateUpdateParam param, boolean independent, boolean onlyRegisterable) {
        return this.certificateService.submitCertificateUpdateTask(queue, this, param, independent, onlyRegisterable);
    }

    @JsonIgnore
    public String getComponentName() {
        if (VerifyUtil.isEmpty((String)this.certName)) {
            return "";
        }
        String[] items = this.certName.split("-");
        String name = items.length > 1 ? items[1] : "";
        return LegoConfig.getInstance().getKeyValue("cert." + name + ".name", name);
    }
}

