/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.sdk.service;

import com.huawei.ism.drm.cert.sdk.model.CertificateOperateStatus;
import com.huawei.ism.drm.cert.sdk.model.CertificateSummary;
import com.huawei.ism.drm.cert.sdk.model.CertificateUpdateParam;
import com.huawei.ism.drm.cert.sdk.service.ISystemCertificateService;
import com.huawei.ism.drm.cert.sdk.service.command.CommandReaction;
import com.huawei.ism.drm.cert.sdk.service.command.Parameter;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.NodeAgentLocalService;
import com.huawei.nodeagent.thrift.Response;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.stream.Stream;

@ServiceBoundInfo(methodName="addComponentCertificateService", targetBeanName="systemCertificateService")
public interface ICertificateService {
    public void initialize();

    public NodeAgentLocalService.Iface getNodeAgentLocalService();

    public void setNodeAgentLocalService(NodeAgentLocalService.Iface var1);

    public ISystemCertificateService getSystemCertificateService();

    public void setSystemCertificateService(ISystemCertificateService var1);

    public List<CertificateSummary> getCertificateSummaries();

    default public CertificateSummary getCertificateSummaryByCertName(String certName) {
        Stream summaries = Optional.ofNullable(this.getCertificateSummaries()).orElse(Collections.emptyList()).stream();
        return summaries.filter(summary -> Objects.equals(summary.getCertName(), certName)).findFirst().orElse(null);
    }

    default public CommandReaction<Map<Node, Response>> confirmCertificate(List<Node> nodes, Parameter ... params) {
        return CommandReaction.genSuccessNodeResponses(nodes);
    }

    public CertificateOperateStatus submitCertificateUpdateTask(BlockingQueue var1, CertificateSummary var2, CertificateUpdateParam var3, boolean var4, boolean var5);
}

