/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.cert.sdk.service.command;

import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.PathUtil;
import com.huawei.nodeagent.api.NodeUtil;
import com.huawei.nodeagent.api.ThriftSupplier;
import com.huawei.nodeagent.thrift.Node;
import com.huawei.nodeagent.thrift.Response;
import com.huawei.nodeagent.util.NetUtil;
import com.huawei.nodeagent.util.PropUtil;
import com.huawei.nodeagent.util.Strings;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.thrift.TException;

public class CommandReaction<T> {
    private static final Log logger = LogFactory.getInstance(CommandReaction.class);
    private T result;
    private Throwable cause;
    private Map<String, Object> context = new HashMap<String, Object>();

    public CommandReaction(T result) {
        this.result = result;
    }

    public CommandReaction(Throwable cause) {
        this.cause = cause;
    }

    public T getResult() {
        return this.result;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public boolean success() {
        return this.check(-1L, false);
    }

    public boolean failed() {
        return !this.success();
    }

    public CommandReaction<T> check() {
        return this.check(-1L);
    }

    public CommandReaction<T> check(long errorCode) {
        this.check(errorCode, true);
        return this;
    }

    public static CommandReaction<Map<Node, Response>> genUnifiedNodeResponses(List<Node> nodes, int code, String cause) {
        HashMap map = new HashMap();
        nodes.forEach(node -> map.put(node, new Response((long)code, cause)));
        return new CommandReaction<Map<Node, Response>>(map);
    }

    public static CommandReaction<Map<Node, Response>> genSuccessNodeResponses(List<Node> nodes) {
        return CommandReaction.genUnifiedNodeResponses(nodes, 0, null);
    }

    public static <T> CommandReaction<T> get(ThriftSupplier<T> supplier) {
        return CommandReaction.get(supplier, -1L);
    }

    public static <T> CommandReaction<T> get(ThriftSupplier<T> supplier, long errorCode) {
        return CommandReaction.get(supplier, true, errorCode);
    }

    public static <T> CommandReaction<T> get(ThriftSupplier<T> supplier, boolean check) {
        return CommandReaction.get(supplier, check, -1L);
    }

    public static <T> CommandReaction<T> get(ThriftSupplier<T> supplier, boolean raise, long errorCode) {
        Object result;
        try {
            result = supplier.get();
        }
        catch (TException e) {
            LegoCheckedException legoCheckedException = CommandReaction.genNodeAgentStatusException(e);
            if (raise) {
                throw legoCheckedException;
            }
            return new CommandReaction<T>((Throwable)legoCheckedException);
        }
        CommandReaction<Object> commandReaction = new CommandReaction<Object>(result);
        commandReaction.check(errorCode, raise);
        return commandReaction;
    }

    public static LegoCheckedException genNodeAgentStatusException(Throwable e) {
        Path path = Paths.get(PathUtil.getInstallPath(), "NodeAgent/conf/nodeAgent.properties");
        Properties properties = PropUtil.loadProperties((Path)path);
        List localAddresses = NetUtil.getLocalAddresses();
        String address = NodeUtil.getNodeAddressConfigItemStream((Properties)properties).map(properties::getProperty).map(nodeConfig -> Strings.splitrim((String)nodeConfig, (String)";")[0]).map(addresses -> Arrays.asList(Strings.splitrim((String)addresses, (String)","))).filter(addresses -> addresses.stream().anyMatch(localAddresses::contains)).findFirst().flatMap(addresses -> addresses.stream().findFirst()).orElse("unknown");
        return CommandReaction.genNodeAgentStatusException(Collections.singletonList(address), e);
    }

    public static LegoCheckedException genNodeAgentStatusException(List<String> addresses, Throwable e) {
        return new LegoCheckedException(1073949720L, new String[]{String.join((CharSequence)",", addresses)}, e);
    }

    private static LegoCheckedException castAsResponseException(Response response) {
        if (response == null || response.code == 0L) {
            return null;
        }
        return new LegoCheckedException(response.code, response.details);
    }

    public boolean check(long errorCode, boolean raise) {
        if (this.cause != null) {
            if (!raise) {
                return false;
            }
            if (this.cause instanceof LegoCheckedException) {
                throw (LegoCheckedException)this.cause;
            }
            throw new LegoCheckedException(errorCode, this.cause).log(logger);
        }
        if (this.result == null) {
            return true;
        }
        if (this.result instanceof Response) {
            return CommandReaction.checkResponse((Response)this.result, raise, errorCode);
        }
        if (this.result instanceof Collection) {
            return CommandReaction.checkResponseCollection((Collection)this.result, raise, errorCode);
        }
        if (this.result instanceof Map) {
            return CommandReaction.checkResponseMap((Map)this.result, raise, errorCode);
        }
        return true;
    }

    private static boolean checkResponse(Response response, boolean raise, long errorCode) {
        boolean error;
        boolean bl = error = response != null && response.code != 0L;
        if (raise && error) {
            throw new LegoCheckedException(errorCode, (Throwable)CommandReaction.castAsResponseException(response)).log(logger);
        }
        return true;
    }

    private static boolean checkResponseCollection(Collection<?> responseList, boolean raise, long errorCode) {
        LegoCheckedException[] exceptions = (LegoCheckedException[])responseList.stream().filter(Response.class::isInstance).map(Response.class::cast).filter(response -> response.code != 0L).map(response -> new LegoCheckedException(response.code, response.details)).toArray(LegoCheckedException[]::new);
        return CommandReaction.check(raise, exceptions, errorCode, new String[0]);
    }

    private static LegoCheckedException castAsLegoCheckedException(Map.Entry<Node, Response> entry, long errorCode) {
        Response response = entry.getValue();
        if (response.code == 0L) {
            return null;
        }
        return new LegoCheckedException(errorCode, new String[]{CommandReaction.getNodeIdentification(entry.getKey())}, response.details);
    }

    private static <E> boolean checkResponseMap(Map<E, E> responseMap, boolean raise, long errorCode) {
        List items = responseMap.entrySet().stream().filter(e -> e.getKey() instanceof Node && e.getValue() instanceof Response).map(e -> e).filter(e -> e.getKey() != null && e.getValue() != null && ((Response)e.getValue()).code != 0L).collect(Collectors.toList());
        LegoCheckedException[] exceptions = (LegoCheckedException[])items.stream().map(e -> CommandReaction.castAsLegoCheckedException(e, errorCode)).toArray(LegoCheckedException[]::new);
        String nodeAddressList = items.stream().map(item -> CommandReaction.getNodeIdentification((Node)item.getKey())).distinct().collect(Collectors.joining(", "));
        return CommandReaction.check(raise, exceptions, errorCode, nodeAddressList);
    }

    private static String getNodeIdentification(Node node) {
        return (String)Optional.ofNullable(node.addresses).orElse(Collections.emptyList()).stream().findFirst().orElseThrow(() -> new LegoCheckedException("not found node address").log(logger));
    }

    private static boolean check(boolean raise, LegoCheckedException[] exceptions, long errorCode, String ... args) {
        boolean error;
        boolean bl = error = exceptions != null && exceptions.length > 0;
        if (error) {
            if (raise) {
                throw new LegoCheckedException(errorCode, args, (Throwable)LegoCheckedException.combine((Log)logger, (LegoCheckedException[])exceptions)).log(logger);
            }
            Arrays.stream(exceptions).forEach(e -> e.log(logger));
        }
        return !error;
    }
}

