/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.common.sdk.service;

import com.huawei.ism.drm.common.sdk.model.MessageEvent;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;

@ServiceBoundInfo(methodName="addObserver,addObserver", targetBeanName="protectGroupService,recoveryPlanObserverManager")
public interface IObjectObserver {
    public static final Log logger = LogFactory.getInstance(IObjectObserver.class);
    public static final String OBSERVER_ERROR = "observerError";

    default public void onMessage(MessageEvent event, String notifyType) {
        switch (notifyType) {
            case "before": {
                this.before(event);
                break;
            }
            case "after": {
                this.after(event);
                break;
            }
            case "onError": {
                try {
                    this.onError(event);
                }
                catch (Exception e) {
                    logger.error((Object)"failed to notify observer.Type:%s, Exception: %s", new Object[]{notifyType, ExceptionUtil.getErrorMessage((Throwable)e)});
                    if (event.getMessageMap() == null) {
                        event.setMessageMap(new HashMap<String, Object>());
                    }
                    event.getMessageMap().put(this.getClass().getName() + "_onError_Exception", e);
                }
                break;
            }
            case "onFinal": {
                try {
                    this.onFinal(event);
                }
                catch (Exception e) {
                    logger.error((Object)"failed to notify observer.Type:%s, Exception: %s", new Object[]{notifyType, ExceptionUtil.getErrorMessage((Throwable)e)});
                    if (event.getMessageMap() == null) {
                        event.setMessageMap(new HashMap<String, Object>());
                    }
                    event.getMessageMap().put(this.getClass().getName() + "_onFinal_Exception", e);
                }
                break;
            }
            default: {
                logger.error((Object)"notifyType is:Type:%s.", new Object[]{notifyType});
            }
        }
    }

    public void before(MessageEvent var1);

    default public void after(MessageEvent event) {
    }

    default public void onFinal(MessageEvent event) {
    }

    default public void onError(MessageEvent event) {
    }

    public String getObserverType();

    default public int getPriority() {
        return 0;
    }
}

