/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.constant;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class DrmEnumDefine {
    private DrmEnumDefine() {
    }

    public static enum RecoveryActionType {
        DISASTER_RECOVERY("disasterRecovery"),
        PLANED_MOTION("planedMotion"),
        DRILLING("drilling"),
        CLEAN_DRILLING("cleanDrilling"),
        SNAPSHOT_ROLLBACK("snapshotRollback"),
        REPROTECT("reprotect"),
        HOT_MIGRATION("hotMigration");

        private String value;

        private RecoveryActionType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ConsistentTypeEnum {
        UNKNOWN(-1),
        CRASH_CONSISTENT(0),
        APP_CONSISTENT(1);

        private Integer type;

        private ConsistentTypeEnum(Integer type) {
            this.type = type;
        }

        public Integer getType() {
            return this.type;
        }

        public static ConsistentTypeEnum getType(Integer value) {
            for (ConsistentTypeEnum type : ConsistentTypeEnum.values()) {
                if (!type.getType().equals(value)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static enum RecoveryTargetType {
        HOST_WITH_AGENT("HostWithAgent"),
        CLOUD_SERVER("CloudServer");

        private String type;

        private RecoveryTargetType(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static RecoveryTargetType getType(String value) {
            for (RecoveryTargetType type : RecoveryTargetType.values()) {
                if (!type.getType().equals(value)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum RoleType {
        DEFAULT(-1),
        PRIORITY(0),
        NONE_PRIORITY(1);

        private int value;

        private RoleType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RoleType getType(int value) {
            for (RoleType type : RoleType.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            return DEFAULT;
        }
    }

    public static enum RecoveryExtendAttributes {
        REFACTOR_CONFIGURATION_SUCCESS(0);

        private int value;

        private RecoveryExtendAttributes(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RecoveryExtendAttributes getType(int value) {
            RecoveryExtendAttributes enumType = null;
            for (RecoveryExtendAttributes type : RecoveryExtendAttributes.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum DeviceCapabilityE {
        HYPER_CLONE(1),
        HYPER_REPLIATION_RATE(2),
        INVALID(-1);

        private int value;

        private DeviceCapabilityE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static DeviceCapabilityE getType(int value) {
            DeviceCapabilityE enumType = null;
            for (DeviceCapabilityE type : DeviceCapabilityE.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum RecoveryPlanOperationType {
        DISASTER_RECOVERY(RecoveryPlanExecuteTypeE.DISASTER_RECOVERY.getValue()),
        PLANED_MOTION(RecoveryPlanExecuteTypeE.PLANED_MOTION.getValue()),
        DRILLING(RecoveryPlanExecuteTypeE.DRILLING.getValue()),
        CLEAN_DRILLING(RecoveryPlanExecuteTypeE.CLEAN_DRILLING.getValue()),
        SNAPSHOT_ROLLBACK(RecoveryPlanExecuteTypeE.SNAPSHOT_ROLLBACK.getValue()),
        REPROTECT(RecoveryPlanExecuteTypeE.REPROTECT.getValue()),
        SWAP(RecoveryPlanExecuteTypeE.SWAP.getValue()),
        MODIFY_BASIC_INFO(20),
        MOIFY_RECOVERY_SETTING(21),
        EDIT_RECOVERY_PROCESSOR(22),
        DELETE_RECOVERY_PLAN(23),
        MOUNT_REPLICA(RecoveryPlanExecuteTypeE.MOUNT_REPLICA.getValue()),
        UMOUNT_REPLICA(RecoveryPlanExecuteTypeE.UMOUNT_REPLICA.getValue()),
        HOT_MIGRATION(RecoveryPlanExecuteTypeE.HOT_MIGRATION.getValue());

        private int value;

        private RecoveryPlanOperationType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RecoveryPlanOperationType getType(int value) {
            RecoveryPlanOperationType enumType = null;
            for (RecoveryPlanOperationType type : RecoveryPlanOperationType.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum TriggerStateStatus {
        NORMAL(0),
        PAUSED(1),
        COMPLETE(2),
        ERROR(3),
        BLOCKED(4),
        NONE(5);

        private int status;

        private TriggerStateStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static TriggerStateStatus valueOf(int status) {
            TriggerStateStatus result = null;
            for (TriggerStateStatus value : TriggerStateStatus.values()) {
                if (status != value.getStatus()) continue;
                result = value;
                break;
            }
            return result;
        }
    }

    public static enum ProtectGroupStatus {
        NORMAL(1),
        DISABLED(0),
        WAITTING(2),
        LOCKED(4),
        INVALID(3),
        RUNNING(5);

        private int status;

        private ProtectGroupStatus(int status) {
            this.status = status;
        }

        public int getStatus() {
            return this.status;
        }

        public static ProtectGroupStatus valueOf(int status) {
            ProtectGroupStatus result = null;
            for (ProtectGroupStatus value : ProtectGroupStatus.values()) {
                if (status != value.getStatus()) continue;
                result = value;
                break;
            }
            return result;
        }
    }

    public static enum ProtectLocation {
        A_A(0),
        A_B(1),
        A_C(2),
        B_C(3),
        B_B(4),
        C_C(5);

        private int value;

        private ProtectLocation(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ProtectLocation getType(int value) {
            ProtectLocation enumType = null;
            for (ProtectLocation type : ProtectLocation.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }

        public static ProtectLocation getValueOf(int value) {
            ProtectLocation enumType = null;
            for (ProtectLocation type : ProtectLocation.values()) {
                if (type.value != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum ProviderTypeE {
        STORAGE_DEVICE(0),
        HOST(1),
        HOSTGROUP(2),
        CLOUD_PLATFORM(3);

        private int value;

        private ProviderTypeE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ProviderTypeE getType(int value) {
            ProviderTypeE enumType = null;
            for (ProviderTypeE type : ProviderTypeE.values()) {
                if (value != type.getValue()) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum RecoveryPlanTypeE {
        LOCAL(1),
        REMOTE(2);

        private int value;

        private RecoveryPlanTypeE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RecoveryPlanTypeE getType(int value) {
            RecoveryPlanTypeE enumType = null;
            for (RecoveryPlanTypeE type : RecoveryPlanTypeE.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum ReplicaStatus {
        UNACTIVE_STATUS(0),
        ACTIVE_STATUS(1),
        ERROR_STATUS(3);

        private int value;

        private ReplicaStatus(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ReplicaStatus getType(int value) {
            for (ReplicaStatus type : ReplicaStatus.values()) {
                if (value != type.getValue()) continue;
                return type;
            }
            return null;
        }
    }

    public static enum StorageTypeE {
        UNKNOWN(-1),
        NORMAL(0),
        PRIMAL(1),
        ASM_LIB(2),
        ASM_PRIMAL(3),
        ASM_LINK(4),
        ASM_UDEV(5),
        ASM_WINDOWS(6);

        private int value;

        private StorageTypeE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static StorageTypeE getType(int value) {
            StorageTypeE enumType = null;
            for (StorageTypeE type : StorageTypeE.values()) {
                if (value != type.getValue()) continue;
                enumType = type;
            }
            return enumType;
        }
    }

    public static enum ResourceTypeE {
        LUN(1),
        VIS(2),
        NAS(3);

        private int value;

        private ResourceTypeE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ResourceTypeE getType(int value) {
            ResourceTypeE enumType = null;
            for (ResourceTypeE type : ResourceTypeE.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
            }
            return enumType;
        }
    }

    public static enum ClusterTypeE {
        ORACLE_RAC(1),
        DB2_VCS(2),
        SQL_SERVER_MSFC(3),
        DB2_HACMP(4);

        private int clusterType = 0;

        private ClusterTypeE(int type) {
            this.clusterType = type;
        }

        public int getValue() {
            return this.clusterType;
        }

        public static ClusterTypeE getType(int value) {
            ClusterTypeE enumType = null;
            for (ClusterTypeE type : ClusterTypeE.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
            }
            return enumType;
        }

        public static int getAppType(int value) {
            ClusterTypeE enumType = ClusterTypeE.getType(value);
            if (enumType == null) {
                return -1;
            }
            if (enumType == ORACLE_RAC) {
                return enumType.getValue();
            }
            if (enumType == DB2_VCS || enumType == DB2_HACMP) {
                return 3;
            }
            if (enumType == SQL_SERVER_MSFC) {
                return 2;
            }
            return -1;
        }
    }

    public static enum ReportTimeRangeE {
        LAST_THREE_MONTHS(7776000L),
        LAST_ONE_MONTH(2592000L),
        LAST_HALF_YEAR(15552000L),
        LAST_ONE_YEAR(31536000L),
        LAST_24_HOURS(86400L),
        LAST_ONE_DAY(86400L),
        LAST_THREE_DAYS(259200L),
        LAST_SEVEN_DAYS(604800L),
        LAST_30_DAYS(2592000L),
        ALL_TIME(-1L);

        private long value = 0L;

        private ReportTimeRangeE(long value) {
            this.value = value;
        }

        public long getValue() {
            return this.value * 1000L;
        }
    }

    public static enum ProtectObjectRecoveryStatusE {
        NOT_STARTED(0),
        COMPLETED(1),
        FAILED(2),
        RUNNING(3);

        private int value;

        private ProtectObjectRecoveryStatusE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ProtectObjectRecoveryStatusE getType(int value) {
            ProtectObjectRecoveryStatusE enumType = null;
            for (ProtectObjectRecoveryStatusE type : ProtectObjectRecoveryStatusE.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum AppType {
        ORACLE(1),
        SQL_SERVER(2),
        DB2(3),
        FILE_SYSTEM(9),
        VM(10),
        LUN(11),
        EXCHANGE(8),
        GALAX_VM(12),
        EXCHANGE2007(13),
        NAS_FILESYSTEM(14),
        CACHE(15),
        SAPHANA(16),
        NAS_FILE_SYSTEM(17),
        NAS(18);

        private int value;

        private AppType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static AppType getType(int value) {
            if (value == 99) {
                return LUN;
            }
            if (value == 101) {
                return NAS_FILESYSTEM;
            }
            AppType enumType = null;
            for (AppType type : AppType.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }

        public static AppType getValueOf(int value) {
            AppType enumType = null;
            for (AppType type : AppType.values()) {
                if (type.value != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum RecoveryPlanExecuteTypeE {
        PLANED_MOTION(1, RecoveryPlanStatusE.PLANED_MOTION_RUNNING.getValue(), RecoveryPlanStatusE.PLANED_MOTION_COMPLETED.getValue(), RecoveryPlanStatusE.PLANED_MOTION_FAILED.getValue(), RecoveryPlanStatusE.PLANED_MOTION_PAUSED.getValue()),
        DISASTER_RECOVERY(0, RecoveryPlanStatusE.DISASTER_RECOVERY_RUNNING.getValue(), RecoveryPlanStatusE.DISASTER_RECOVERY_COMPLETED.getValue(), RecoveryPlanStatusE.DISASTER_RECOVERY_FAILED.getValue()),
        DRILLING(2, RecoveryPlanStatusE.TEST_RUNNING.getValue(), RecoveryPlanStatusE.TEST_COMPLETED.getValue(), RecoveryPlanStatusE.TEST_FAILED.getValue()),
        CLEAN_DRILLING(3, RecoveryPlanStatusE.CLEAN_RUNNING.getValue(), RecoveryPlanStatusE.CLEAN_COMPLETED.getValue(), RecoveryPlanStatusE.CLEAN_FAILED.getValue()),
        SNAPSHOT_ROLLBACK(4, RecoveryPlanStatusE.ROLLBACK_RUNNING.getValue(), RecoveryPlanStatusE.ROLLBACK_COMPLETED.getValue(), RecoveryPlanStatusE.ROLLBACK_FAILED.getValue()),
        REPROTECT(7, RecoveryPlanStatusE.REPROTECT_RUNNING.getValue(), RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue(), RecoveryPlanStatusE.REPROTECT_FAILED.getValue()),
        SWAP(8, RecoveryPlanStatusE.SWAP_RUNNING.getValue(), RecoveryPlanStatusE.READY.getValue(), RecoveryPlanStatusE.SWAP_FAILED.getValue()),
        MOUNT_REPLICA(9, RecoveryPlanStatusE.MOUNTING_REPLICA.getValue(), RecoveryPlanStatusE.MOUNT_COMPLETED.getValue(), RecoveryPlanStatusE.MOUNT_FAILED.getValue()),
        UMOUNT_REPLICA(10, RecoveryPlanStatusE.UMOUNTING_REPLICA.getValue(), RecoveryPlanStatusE.UMOUNT_COMPLETED.getValue(), RecoveryPlanStatusE.UMOUNT_FAILED.getValue()),
        HOT_MIGRATION(11, RecoveryPlanStatusE.HOT_MIGRATION_RUNNING.getValue(), RecoveryPlanStatusE.REPROTECT_COMPLETED.getValue(), RecoveryPlanStatusE.HOT_MIGRATION_FAILED.getValue());

        private int planRunningStatus;
        private int value;
        private int planSuccessStatus;
        private int planFailedStatus;
        private int planPausedStatus;

        private RecoveryPlanExecuteTypeE(int value, int planRunningStatus, int planSuccessStatus, int planFailedStatus) {
            this(value, planRunningStatus, planSuccessStatus, planFailedStatus, 0);
        }

        private RecoveryPlanExecuteTypeE(int value, int planRunningStatus, int planSuccessStatus, int planFailedStatus, Integer planPausedStatus) {
            this.value = value;
            this.planRunningStatus = planRunningStatus;
            this.planSuccessStatus = planSuccessStatus;
            this.planFailedStatus = planFailedStatus;
            this.planPausedStatus = planPausedStatus;
        }

        public int getPlanRunningStatus() {
            return this.planRunningStatus;
        }

        public int getValue() {
            return this.value;
        }

        public int getPlanSuccessStatus() {
            return this.planSuccessStatus;
        }

        public int getPlanFailedStatus() {
            return this.planFailedStatus;
        }

        public int getPlanPausedStatus() {
            return this.planPausedStatus;
        }

        public static RecoveryPlanExecuteTypeE getType(int value) {
            RecoveryPlanExecuteTypeE enumType = null;
            for (RecoveryPlanExecuteTypeE type : RecoveryPlanExecuteTypeE.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum RecoveryPlanExecuteResultE {
        SUCCESS(0),
        FAILED(1),
        PART_SUCCESS(2),
        RUNNING(3),
        PAUSED(4),
        OTHER(-1);

        private int value;

        private RecoveryPlanExecuteResultE(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static RecoveryPlanExecuteResultE getType(int value) {
            RecoveryPlanExecuteResultE enumType = null;
            for (RecoveryPlanExecuteResultE type : RecoveryPlanExecuteResultE.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }

    public static enum RecoveryPlanStatusE {
        READY(0, Arrays.asList(0, 1)),
        PLANED_MOTION_RUNNING(1, 3),
        PLANED_MOTION_COMPLETED(2, Collections.singletonList(7)),
        PLANED_MOTION_FAILED(3),
        PLANED_MOTION_PAUSED(99),
        DISASTER_RECOVERY_RUNNING(10, 12),
        DISASTER_RECOVERY_COMPLETED(11),
        DISASTER_RECOVERY_FAILED(12),
        TEST_RUNNING(4, 6),
        TEST_COMPLETED(5, Collections.singletonList(3)),
        TEST_FAILED(6, Collections.singletonList(3)),
        CLEAN_RUNNING(7, 9),
        CLEAN_COMPLETED(8, Collections.singletonList(2)),
        CLEAN_FAILED(9),
        ROLLBACK_RUNNING(15, 18),
        ROLLBACK_FAILED(18),
        ROLLBACK_COMPLETED(19),
        REPROTECT_FAILED(16),
        REPROTECT_RUNNING(17, 16),
        REPROTECT_COMPLETED(20),
        SWAP_RUNNING(21, 22),
        SWAP_FAILED(22),
        MOUNTING_REPLICA(23, 25),
        UMOUNTING_REPLICA(24, 28),
        MOUNT_FAILED(25, Collections.singletonList(10)),
        MOUNT_COMPLETED(26, Collections.singletonList(10)),
        UMOUNT_COMPLETED(27, Collections.singletonList(9)),
        UMOUNT_FAILED(28),
        HOT_MIGRATION_RUNNING(29, 30),
        HOT_MIGRATION_FAILED(30),
        INVALID(-1);

        private int value;
        private List<Integer> cleanExecuteTypes;
        private Integer failStatusWhenRunning;

        private RecoveryPlanStatusE(int value) {
            this.value = value;
        }

        private RecoveryPlanStatusE(int value, List<Integer> cleanExecuteTypes) {
            this.value = value;
            this.cleanExecuteTypes = cleanExecuteTypes;
        }

        private RecoveryPlanStatusE(int value, Integer failStatusWhenRunning) {
            this.value = value;
            this.failStatusWhenRunning = failStatusWhenRunning;
        }

        public int getValue() {
            return this.value;
        }

        public boolean containsExecuteType(int executeType) {
            if (this.cleanExecuteTypes == null) {
                return false;
            }
            return this.cleanExecuteTypes.contains(executeType);
        }

        public Integer getFailStatusWhenRunning() {
            return this.failStatusWhenRunning;
        }

        public static RecoveryPlanStatusE getType(int value) {
            RecoveryPlanStatusE enumType = null;
            for (RecoveryPlanStatusE type : RecoveryPlanStatusE.values()) {
                if (type.getValue() != value) continue;
                enumType = type;
                break;
            }
            return enumType;
        }
    }
}

