/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.constant.coreenum;

import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Locale;

public class ServiceInstaceEnumDefine {

    public static enum ObjectType {
        SFS("SFS"),
        ECS_BMS("ECS_BMS"),
        NAS("NAS");

        private String value;

        private ObjectType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static String getObjectType(String objectType) {
            if (VerifyUtil.isEmpty((String)objectType)) {
                return ECS_BMS.getValue();
            }
            for (ObjectType type : ObjectType.values()) {
                if (!type.getValue().equalsIgnoreCase(objectType)) continue;
                return type.getValue();
            }
            return "";
        }
    }

    public static enum ServiceInstanceOperateType {
        ADD_INSTANCE("add_instance"),
        ADD_SERVERS("add_servers"),
        ADD_VOLUMES("add_volumes"),
        DEL_INSTANCE("del_instance"),
        DEL_SERVERS("del_servers"),
        DEL_VOLUMES("del_volumes"),
        UPGRADE_INSTANCE("upgrade_instance"),
        DOWNGRADE_INSTANCE("downgrade_instance");

        private String value;

        private ServiceInstanceOperateType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public boolean isCurrent(String opType) {
            return this.getValue().equalsIgnoreCase(opType);
        }
    }

    public static enum ServiceInstanceOrderExecuteStatusE {
        EXECUTING("executing"),
        SUCCESSED("successed"),
        FAILED("failed");

        private String value;

        private ServiceInstanceOrderExecuteStatusE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ServiceInstanceReplicationTypeE {
        SYNCHRONIZE("synchronize"),
        ASYNCHRONIZE("asynchronize");

        private String value;

        private ServiceInstanceReplicationTypeE(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }

    public static enum ServiceInstanceTypeE {
        HYPERMETRO("hypermetro", "csha"),
        REPLICATION("replication", "csdr"),
        VHA("vha", "vha"),
        VHA_REPLICATION("hyperMetroReplication", "vha_csdr"),
        CSHA_REPLICATION("IntraCityHyperMetroReplication", "csha_csdr");

        private String value;
        private String frontValue;

        private ServiceInstanceTypeE(String value, String frontValue) {
            this.value = value;
            this.frontValue = frontValue;
        }

        public String getValue() {
            return this.value;
        }

        public String getFrontValue() {
            return this.frontValue;
        }

        public static ServiceInstanceTypeE getTypeFromValue(String value) {
            for (ServiceInstanceTypeE type : ServiceInstanceTypeE.values()) {
                if (!type.isCurrent(value)) continue;
                return type;
            }
            return null;
        }

        public static String getServiceIdFromServiceType(String value) {
            ServiceInstanceTypeE type = ServiceInstanceTypeE.getTypeFromValue(value);
            if (type != null) {
                return type.getFrontValue();
            }
            return null;
        }

        public static String getFrontInstanceType(String instanceProtectType) {
            if (instanceProtectType == null) {
                return "";
            }
            ServiceInstanceTypeE typeEnum = ServiceInstanceTypeE.getTypeFromValue(instanceProtectType);
            if (typeEnum == null) {
                return "";
            }
            if (typeEnum == VHA_REPLICATION || typeEnum == CSHA_REPLICATION) {
                return REPLICATION.getFrontValue().toUpperCase(Locale.ENGLISH);
            }
            return typeEnum.getFrontValue().toUpperCase(Locale.ENGLISH);
        }

        public boolean isCurrent(String instanceType) {
            return this.getValue().equals(instanceType) || this.getFrontValue().equals(instanceType);
        }
    }

    public static enum ServiceInstanceStatusE {
        NORMAL("normal"),
        DELETING("deleting"),
        ERR_DELETE("err-delete"),
        LOCKED("locked"),
        PLANED_MIGRATION_RUNNING("switchovering"),
        PLANED_MIGRATION_FAILED("err-switchover"),
        PLANED_MIGRATION_COMPLETED("switchoverd"),
        PLANED_MIGRATION_PAUSED("paused-switchover"),
        HOT_MIGRATION_RUNNING("hotmigrationing"),
        HOT_MIGRATION_FAILED("err-hotmigration"),
        DISASTER_RECOVERY_RUNNING("failovering"),
        DISASTER_RECOVERY_COMPLETED("failovered"),
        DISASTER_RECOVERY_FAILED("err-failover"),
        REPROTECT_FAILED("err-reprotect"),
        REPROTECT_RUNNING("reprotecting"),
        TESTING("testing"),
        ERR_TEST("err-test"),
        TESTED("tested"),
        CLEARING("clearing"),
        ERR_CLEAR("err-clear"),
        MAINTAIN("maintain"),
        ERR_MODIFY_TYPE("err-modify-type");

        private String value;

        private ServiceInstanceStatusE(String value) {
            this.value = value;
        }

        public static ServiceInstanceStatusE getType(String value) {
            ServiceInstanceStatusE enumType = null;
            for (ServiceInstanceStatusE type : ServiceInstanceStatusE.values()) {
                if (!type.getValue().equals(value)) continue;
                enumType = type;
                break;
            }
            return enumType;
        }

        public String getValue() {
            return this.value;
        }
    }
}

