/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.drp.sdk.model;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessorDetail;
import com.huawei.ism.drm.protection.group.sdk.model.PropertyAccessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.process.IProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecoveryProcessor
implements Serializable,
IProcessor,
Cloneable,
PropertyAccessor {
    private static final long serialVersionUID = -3422572174696238010L;
    private String procId;
    private String procName;
    private int procType;
    private int procStatus = DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue();
    private String startTime;
    private String endTime;
    private Set<RecoveryProcessor> childProc;
    private RecoveryProcessor parentProc;
    private String planId;
    private RecoveryProcessorDetail curProcessDetail;
    private RecoveryProcessor previousProcessor;
    private RecoveryProcessor nextProcessor;
    private RecoveryProcessor nextCascadeProcessor;
    private int progressRatio = Integer.MIN_VALUE;
    private Boolean isEnabled = true;
    private Boolean isEditable = true;
    private Boolean isPreset = false;
    private String processId;
    private Boolean isNeedSave = true;
    private Boolean isResultProcessor = true;
    private Boolean isNeedCreateDetail = true;
    private Map<String, String> props = new HashMap<String, String>();
    private Boolean hasChildProc = false;
    private String parentProcId;
    private String preProcId;
    private String nextProcId;
    private String nextCascadeProcId;
    private String procDetail;
    private String[] procDetailParams;
    private String description = "--";

    public RecoveryProcessor() {
        this.procId = UUIDGenerator.getUUID();
        this.procName = this.getName();
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public RecoveryProcessor(RecoveryProcessor parentProc) {
        this.procId = UUIDGenerator.getUUID();
        this.procName = this.getName();
        this.parentProc = parentProc;
        this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.OTHER.getValue());
    }

    public String getProcId() {
        return this.procId;
    }

    public void setProcId(String procId) {
        this.procId = procId;
    }

    public String getProcName() {
        return this.procName;
    }

    public void setProcName(String procName) {
        this.procName = procName;
    }

    public int getProcType() {
        return this.procType;
    }

    public void setProcType(int procType) {
        this.procType = procType;
    }

    public int getProcStatus() {
        return this.procStatus;
    }

    public void setProcStatus(int procStatus) {
        this.procStatus = procStatus;
    }

    public boolean updateExecuteResult(boolean result) {
        if (result) {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.SUCCESS.getValue());
        } else {
            this.setProcStatus(DrmEnumDefine.RecoveryPlanExecuteResultE.FAILED.getValue());
        }
        return result;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public void setIsEditable(Boolean isEditable) {
        this.isEditable = isEditable;
    }

    public Boolean getIsEditable() {
        return this.isEditable;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsPreset(Boolean isPreset) {
        this.isPreset = isPreset;
    }

    public Boolean getIsPreset() {
        return this.isPreset;
    }

    public Boolean getIsResultProcessor() {
        return this.isResultProcessor;
    }

    public void setIsResultProcessor(Boolean isResultProcessor) {
        this.isResultProcessor = isResultProcessor;
    }

    public Set<RecoveryProcessor> getChildProc() {
        return this.childProc == null ? new HashSet() : this.childProc;
    }

    public void setChildProc(Set<RecoveryProcessor> childProc) {
        this.childProc = childProc;
    }

    public RecoveryProcessor getParentProc() {
        return this.parentProc;
    }

    public void setParentProc(RecoveryProcessor parentProc) {
        this.parentProc = parentProc;
        if (this.parentProc != null) {
            this.setPlanId(this.parentProc.getPlanId());
            this.setProcessId(this.parentProc.getProcessId());
            this.setProcType(this.parentProc.getProcType());
        }
    }

    public void setCurProcessDetail(RecoveryProcessorDetail curProcessDetail) {
        this.curProcessDetail = curProcessDetail;
    }

    public RecoveryProcessorDetail getCurProcessDetail() {
        return this.curProcessDetail;
    }

    public int getProgressRatio() {
        return this.progressRatio;
    }

    public void setProgressRatio(int progressRatio) {
        this.progressRatio = progressRatio;
    }

    public RecoveryProcessor getPreviousProcessor() {
        return this.previousProcessor;
    }

    public void setPreviousProcessor(RecoveryProcessor previousProcessor) {
        this.previousProcessor = previousProcessor;
    }

    public RecoveryProcessor getNextProcessor() {
        return this.nextProcessor;
    }

    public void setNextProcessor(RecoveryProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    public RecoveryProcessor getNextCascadeProcessor() {
        return this.nextCascadeProcessor;
    }

    public void setNextCascadeProcessor(RecoveryProcessor nextCascadeProcessor) {
        this.nextCascadeProcessor = nextCascadeProcessor;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    public String getPlanId() {
        return this.planId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setIsNeedSave(Boolean isNeedSave) {
        this.isNeedSave = isNeedSave;
    }

    public Boolean getIsNeedSave() {
        return this.isNeedSave;
    }

    public Boolean getIsNeedCreateDetail() {
        return this.isNeedCreateDetail;
    }

    public void setIsNeedCreateDetail(Boolean isNeedCreateDetail) {
        this.isNeedCreateDetail = isNeedCreateDetail;
    }

    public void setHasChildProc(Boolean hasChildProc) {
        this.hasChildProc = hasChildProc;
    }

    public Boolean getHasChildProc() {
        return this.hasChildProc;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Object clone() throws CloneNotSupportedException {
        Object obj = super.clone();
        if (obj != null) {
            RecoveryProcessor processor = (RecoveryProcessor)obj;
            processor.setProcId(UUIDGenerator.getUUID());
        }
        return obj;
    }

    public boolean equals(Object paramObject) {
        if (paramObject == null) {
            return false;
        }
        if (!(paramObject instanceof RecoveryProcessor)) {
            return false;
        }
        RecoveryProcessor processor = (RecoveryProcessor)paramObject;
        if (null != processor.getProcId()) {
            return processor.getProcId().equals(this.procId);
        }
        return processor.getProcId() == null && this.procId == null;
    }

    public int hashCode() {
        if (this.procId == null) {
            return UUIDGenerator.getUUID().hashCode();
        }
        return this.procId.hashCode();
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public boolean process(RecoveryProcessorContext context) {
        return false;
    }

    public void setParentProcId(String parentProcId) {
        this.parentProcId = parentProcId;
    }

    public String getParentProcId() {
        return this.parentProcId;
    }

    public void setPreProcId(String preProcId) {
        this.preProcId = preProcId;
    }

    public String getPreProcId() {
        return this.preProcId;
    }

    public void setNextProcId(String nextProcId) {
        this.nextProcId = nextProcId;
    }

    public String getNextProcId() {
        return this.nextProcId;
    }

    public void setNextCascadeProcId(String nextCascadeProcId) {
        this.nextCascadeProcId = nextCascadeProcId;
    }

    public String getNextCascadeProcId() {
        return this.nextCascadeProcId;
    }

    public String getProcDetail() {
        return this.procDetail;
    }

    public void setProcDetail(String procDetail) {
        this.procDetail = procDetail;
    }

    public String[] getProcDetailParams() {
        return this.procDetailParams;
    }

    public void setProcDetailParams(String[] procDetailParams) {
        this.procDetailParams = procDetailParams;
    }

    public void updateProcessName() {
    }

    public void updateProcNameParams() {
    }

    public void updateDescription() {
    }

    @Override
    public Map<String, String> getProps() {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RecoveryPlanExecuteTypeE execType) {
    }

    public void addInteger(String key, Integer value) {
        this.addObject(key, value);
    }

    public void addBoolean(String key, Integer value) {
        this.addObject(key, value);
    }

    public void addFloat(String key, Float value) {
        this.addObject(key, value);
    }

    public void addDouble(String key, Double value) {
        this.addObject(key, value);
    }

    public void addLong(String key, Long value) {
        this.addObject(key, value);
    }

    public void addString(String key, String value) {
        this.addObject(key, value);
    }

    public Boolean getBoolean(String key) {
        if (this.props == null || !this.props.containsKey(key)) {
            return Boolean.FALSE;
        }
        String value = this.props.get(key);
        return Boolean.valueOf(value);
    }

    public String getString(String key) {
        if (this.props == null || !this.props.containsKey(key)) {
            return null;
        }
        return this.props.get(key);
    }

    public Long getLong(String key) {
        if (this.props == null || !this.props.containsKey(key)) {
            return null;
        }
        String value = this.props.get(key);
        return NumberUtil.convertToLong((Object)value);
    }

    public Double getDouble(String key) {
        if (this.props == null || !this.props.containsKey(key)) {
            return null;
        }
        String value = this.props.get(key);
        return NumberUtil.convertToDouble((Object)value);
    }

    public Float getFloat(String key) {
        if (this.props == null || !this.props.containsKey(key)) {
            return null;
        }
        String value = this.props.get(key);
        return NumberUtil.convertToFloat((Object)value);
    }

    public Integer getInteger(String key) {
        if (this.props == null || !this.props.containsKey(key)) {
            return null;
        }
        String value = this.props.get(key);
        return NumberUtil.convertToInteger((Object)value);
    }

    private void addObject(String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            this.props.remove(key);
            return;
        }
        this.props.put(key, String.valueOf(value));
    }

    public String getStepPosition() {
        if (!this.isPreset.booleanValue()) {
            return this.getProps().get("position");
        }
        return "";
    }
}

