/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.group.sdk.model;

import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public interface PropertyAccessor {
    default public Map<String, String> getProps() {
        return Collections.emptyMap();
    }

    default public boolean hasProperty(String name) {
        return this.getProps().containsKey(name);
    }

    default public String getProperty(String name) {
        Map<String, String> props = this.getProps();
        return props.get(name);
    }

    default public <T> T getProperty(String name, Class<T> type) {
        String value = this.getProperty(name);
        if (value == null || "null".equals(value)) {
            return null;
        }
        if (String.class.isAssignableFrom(type)) {
            return (T)value;
        }
        if (JSONObject.class.isAssignableFrom(type)) {
            return (T)JSONObject.fromObject((Object)value);
        }
        if (JSONArray.class.isAssignableFrom(type)) {
            return (T)JSONArray.fromObject((Object)value);
        }
        return (T)JSONObject.toBean((String)value, type);
    }

    default public <T> Collection<T> getProperties(String name, Class<T> type) {
        JSONArray array = this.getProperty(name, JSONArray.class);
        if (array == null) {
            return null;
        }
        ArrayList<Object> items = new ArrayList<Object>();
        for (Object item : array) {
            if (item instanceof JSONObject) {
                items.add(JSONObject.toBean((JSONObject)((JSONObject)item), type));
                continue;
            }
            if (!type.isInstance(item)) continue;
            items.add(type.cast(item));
        }
        return items;
    }

    default public <T> void setProperty(String name, T value) {
        if (value == null) {
            this.getProps().remove(name);
        } else if (value instanceof String) {
            this.getProps().put(name, (String)value);
        } else if (value instanceof JSONObject) {
            this.getProps().put(name, ((JSONObject)value).toString());
        } else if (value instanceof JSONArray) {
            this.getProps().put(name, ((JSONArray)value).toString());
        } else {
            this.getProps().put(name, JSONObject.fromObject(value).toString());
        }
    }
}

