/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.group.sdk.model;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.protection.group.sdk.model.PropertyAccessor;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.util.Base64;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProtectObject
extends DRMObject
implements Cloneable,
PropertyAccessor {
    private static final long serialVersionUID = 4872370523734845345L;
    private static final Log logger = LogFactory.getInstance(ProtectObject.class);
    private String poId;
    private String moUuid;
    private int poType;
    private int poStatus;
    private int poRecoveryStatus;
    private String providerSN;
    private String providerName;
    private Map<String, String> props;
    private ProtectGroup protectGroup;
    private ManagedObject protectMo;
    private Set<ProtectObjectStorageInfo> usedStorageResourceSet = new HashSet<ProtectObjectStorageInfo>();
    private String storageMetadata;

    private String getPoId() {
        return this.poId;
    }

    private void setPoId(String poId) {
        this.poId = poId;
        super.setUuid(poId);
    }

    @Override
    public void setUuid(String uuid) {
        this.poId = uuid;
        super.setUuid(uuid);
    }

    @Override
    public String getName() {
        if (this.protectMo != null && this.protectMo.getName() != null && !this.protectMo.getName().isEmpty()) {
            return this.protectMo.getName();
        }
        return super.getName();
    }

    public int getPoType() {
        return this.poType;
    }

    public void setPoType(int poType) {
        this.poType = poType;
    }

    public int getPoStatus() {
        return this.poStatus;
    }

    public void setPoStatus(int poStatus) {
        this.poStatus = poStatus;
    }

    public void setPoRecoveryStatus(int poRecoveryStatus) {
        this.poRecoveryStatus = poRecoveryStatus;
    }

    public int getPoRecoveryStatus() {
        return this.poRecoveryStatus;
    }

    public ProtectGroup getProtectGroup() {
        return this.protectGroup;
    }

    public void setProtectGroup(ProtectGroup protectGroup) {
        this.protectGroup = protectGroup;
    }

    public String getMoUuid() {
        return this.moUuid;
    }

    public void setMoUuid(String moUuid) {
        this.moUuid = moUuid;
    }

    @Override
    public Map<String, String> getProps() {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public ManagedObject getProtectMo() {
        return this.protectMo;
    }

    public void setProtectMo(ManagedObject protectMo) {
        this.protectMo = protectMo;
    }

    public String getProviderSN() {
        return this.providerSN;
    }

    public void setProviderSN(String providerSN) {
        this.providerSN = providerSN;
    }

    public Set<ProtectObjectStorageInfo> getUsedStorageResourceSet() {
        return this.usedStorageResourceSet;
    }

    public void setUsedStorageResourceSet(Set<ProtectObjectStorageInfo> usedStorageResourceSet) {
        this.usedStorageResourceSet = usedStorageResourceSet;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) {
        this.providerName = providerName;
    }

    public String getStorageMetadata() {
        if (this.usedStorageResourceSet == null || this.usedStorageResourceSet.isEmpty()) {
            this.storageMetadata = null;
        } else {
            JSONArray array = new JSONArray();
            for (ProtectObjectStorageInfo info : this.usedStorageResourceSet) {
                array.add((Object)info.toJSONObject());
            }
            this.storageMetadata = array.toString();
        }
        return this.storageMetadata;
    }

    public void setStorageMetadata(String storageMetadata) {
        this.storageMetadata = storageMetadata;
        if (!VerifyUtil.isEmpty((String)storageMetadata)) {
            JSONArray array = JSONArray.fromObject((Object)storageMetadata);
            Class<ProtectObjectStorageInfo> clazz = ProtectObjectStorageInfo.class;
            List collection = JSONArray.toCollection((JSONArray)array, clazz);
            for (ProtectObjectStorageInfo storageInfo : collection) {
                storageInfo.setProtectObject(this);
            }
            this.usedStorageResourceSet = new HashSet<ProtectObjectStorageInfo>(collection);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.moUuid == null ? 0 : this.moUuid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProtectObject other = (ProtectObject)obj;
        return !(this.moUuid == null ? other.moUuid != null : !this.moUuid.equals(other.moUuid));
    }

    public void addHostStorageResourceInfo(ProtectObjectStorageInfo protectObjectStorageInfo) {
        if (protectObjectStorageInfo != null) {
            this.getUsedStorageResourceSet().add(protectObjectStorageInfo);
            protectObjectStorageInfo.setProtectObject(this);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        ProtectObject result = (ProtectObject)super.clone();
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.putAll(this.getProps());
        result.setProps(newMap);
        HashSet<ProtectObjectStorageInfo> protectObjectStorageInfoList = new HashSet<ProtectObjectStorageInfo>();
        for (ProtectObjectStorageInfo info : result.getUsedStorageResourceSet()) {
            ProtectObjectStorageInfo cloneProtectObjectStorageInfo = (ProtectObjectStorageInfo)info.clone();
            cloneProtectObjectStorageInfo.setProtectObject(result);
            protectObjectStorageInfoList.add(cloneProtectObjectStorageInfo);
        }
        result.setUsedStorageResourceSet(protectObjectStorageInfoList);
        return result;
    }

    public String toJSONString() {
        HashSet<String> ignoreSet = new HashSet<String>();
        ignoreSet.add("protectGroup");
        ignoreSet.add("props");
        ignoreSet.add("usedStorageResourceSet");
        JSONObject jsonObject = JSONObject.fromObject((Object)this, ignoreSet);
        JSONObject propsObject = new JSONObject();
        if (!VerifyUtil.isEmpty(this.props)) {
            for (Map.Entry<String, String> entry : this.props.entrySet()) {
                try {
                    if (null == entry.getValue()) continue;
                    propsObject.put((Object)entry.getKey(), (Object)Base64.byteArrayToBase64(entry.getValue().getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException e) {
                    logger.error((Object)e);
                }
            }
        }
        jsonObject.put((Object)"props", (Object)propsObject);
        return jsonObject.toString();
    }

    public static ProtectObject toProtectObject(JSONObject jsonObject) {
        if (jsonObject == null || jsonObject.isEmpty()) {
            return null;
        }
        String storageMetaDataJson = jsonObject.getString("storageMetadata");
        jsonObject.remove((Object)"storageMetadata");
        ProtectObject result = (ProtectObject)JSONObject.toBean((JSONObject)jsonObject, ProtectObject.class);
        if (!VerifyUtil.isEmpty((String)storageMetaDataJson)) {
            result.setStorageMetadata(storageMetaDataJson);
        }
        for (Map.Entry<String, String> entry : result.getProps().entrySet()) {
            try {
                result.getProps().put(entry.getKey(), new String(Base64.base64ToByteArray(entry.getValue()), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e);
            }
        }
        return result;
    }

    public void clearUsedStorageResource() {
        this.setStorageMetadata(null);
        if (!VerifyUtil.isEmpty(this.usedStorageResourceSet)) {
            this.usedStorageResourceSet.clear();
        }
    }
}

