/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.schedule.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import java.io.Serializable;

public class RetentionPolicy
implements Serializable {
    private static final long serialVersionUID = 613974871848075589L;
    private static final int MAX_LATEST_COPY = 2048;
    private static final int MIN_LATEST_COPY = 1;
    private static final int MAX_DAIYLY_COPY = 365;
    private static final int MAX_WEEKLY_COPY = 52;
    private static final int MAX_MONTHLY_COPY = 60;
    private static final int MIN_COPY = 0;
    private static final int MAX_SECOND_SNAPSHOT_LATEST_COPY = 256;
    private static final int MAX_CDP_COPY = 60000;
    private static final int MAX_CDP_DAIYLY_COPY = 256;
    private static final int MAX_CDP_WEEKLY_COPY = 256;
    private static final int MAX_CDP_MONTHLY_COPY = 256;
    private int latestCopies;
    private int dailyCopies;
    private int weeklyCopies;
    private int monthlyCopyies;

    public int getLatestCopies() {
        return this.latestCopies;
    }

    public void setLatestCopies(int latestCopies) {
        if (latestCopies < 1 || latestCopies > 60000) {
            throw new LegoCheckedException(1073947393L);
        }
        this.latestCopies = latestCopies;
    }

    public int getDailyCopies() {
        return this.dailyCopies;
    }

    public void setDailyCopies(int dailyCopies) {
        this.dailyCopies = dailyCopies;
    }

    public int getWeeklyCopies() {
        return this.weeklyCopies;
    }

    public void setWeeklyCopies(int weeklyCopies) {
        this.weeklyCopies = weeklyCopies;
    }

    public int getMonthlyCopyies() {
        return this.monthlyCopyies;
    }

    public void setMonthlyCopyies(int monthlyCopyies) {
        this.monthlyCopyies = monthlyCopyies;
    }

    @JsonIgnore
    public int getTotalCopyies() {
        return this.latestCopies + this.dailyCopies + this.weeklyCopies + this.monthlyCopyies;
    }

    public void checkCDPCopies() {
        this.checkCopies(60000, 256, 256, 256);
    }

    public void checkSecondSnapshotCopies() {
        if (this.latestCopies < 1 || this.latestCopies > 256) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public void checkCopies() {
        this.checkCopies(2048, 365, 52, 60);
    }

    private void checkCopies(int maxLatestCopies, int maxDailyCopies, int maxWeeklyCopies, int maxMonthlyCopies) {
        if (this.latestCopies < 1 || this.latestCopies > maxLatestCopies) {
            throw new LegoCheckedException(1073947393L);
        }
        if (this.dailyCopies < 0 || this.dailyCopies > maxDailyCopies) {
            throw new LegoCheckedException(1073947393L);
        }
        if (this.weeklyCopies < 0 || this.weeklyCopies > maxWeeklyCopies) {
            throw new LegoCheckedException(1073947393L);
        }
        if (this.monthlyCopyies < 0 || this.monthlyCopyies > maxMonthlyCopies) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    public String toString() {
        return "RetentionPolicy{latestCopies=" + this.latestCopies + ", dailyCopies=" + this.dailyCopies + ", weeklyCopies=" + this.weeklyCopies + ", monthlyCopyies=" + this.monthlyCopyies + '}';
    }
}

