/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.schedule.sdk.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.huawei.ism.drm.protection.schedule.sdk.model.ExpectedRPO;
import com.huawei.ism.drm.protection.schedule.sdk.model.ReplicationSpeedPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.RetentionPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleProtectedType;
import com.huawei.ism.drm.protection.schedule.sdk.model.ScheduleRangeTime;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.task.sdk.model.ISchedule;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Schedule
implements Serializable,
Cloneable,
ISchedule {
    public static final String PROTECTEDGROUP_SCHEDULE_ENABLE_OPERATE_NAME = "protectedGroup_schedule_enable_operateName";
    public static final String PROTECTEDGROUP_SCHEDULE_ENABLE_OPERATE_DETAIL = "protectedGroup_schedule_enable_operateDetail";
    public static final String PROTECTEDGROUP_SCHEDULE_DISABLE_OPERATE_NAME = "protectedGroup_schedule_disable_operateName";
    public static final String PROTECTEDGROUP_SCHEDULE_DISABLE_OPERATE_DETAIL = "protectedGroup_schedule_disable_operateDetail";
    public static final String PROTECTEDGROUP_SCHEDULE_UPDATE_OPERATE_NAME = "protectedGroup_schedule_update_operateName";
    public static final String PROTECTEDGROUP_SCHEDULE_UPDATE_OPERATE_ETAIL = "protectedGroup_schedule_update_operateDetail";
    public static final String PROTECTEDGROUP_SCHEDULE_ADD_OPERATE_NAME = "protectedGroup_schedule_add_operateName";
    public static final String PROTECTEDGROUP_SCHEDULE_ADD_OPERATED_ETAIL = "protectedGroup_schedule_add_operateDetail";
    public static final String PROTECTEDGROUP_SCHEDULE_OFFLINE_STATUS_OPERATE_NAME = "protectedGroup_schedule_offline_%s_operateName";
    public static final String PROTECTEDGROUP_SCHEDULE_OFFLINE_STATUS_OPERATE_DETAIL = "protectedGroup_schedule_offline_%s_operateName";
    private static List<String> appConistentFlagList = new ArrayList<String>();
    private static List<String> extParameterKeyList = new ArrayList<String>();
    private static List<Integer> types = Arrays.stream(ScheduleProtectedType.values()).map(item -> item.getValue()).collect(Collectors.toList());
    private static final long serialVersionUID = 2164253650210710442L;
    private String scheduleId = UUIDGenerator.getUUID();
    private String name;
    private String startTime;
    private String endTime;
    private int periodType;
    private int periodInterval;
    private String daysOfWeek;
    private String daysOfMonth;
    private int lastDayOfMonth;
    private int scheduleMode;
    private int protectLocation;
    private String hours;
    private String minutes;
    private String seconds;
    private String abortTaskTime;
    private Set<ScheduleRangeTime> scheduleRanges = new HashSet<ScheduleRangeTime>();
    @JsonIgnore
    private PolicyTemplate policyTemplate;
    private int protectedType = -1;
    private Boolean enable = Boolean.TRUE;
    private RetentionPolicy retentionPolicy;
    @JsonIgnore
    private String retentionPolicyData;
    private Boolean enableRpoCheck;
    private ExpectedRPO expectedRPO;
    @JsonIgnore
    private String expectionRPOData;
    private Boolean appConsistent;
    private String sourceSn;
    private String targetSn;
    private String sourceSiteId;
    private String targetSiteId;
    private Map<String, String> extParameters = new HashMap<String, String>();
    @JsonIgnore
    private String extParameterDatas;
    private List<ReplicationSpeedPolicy> replicationSpeedPolicies;
    @JsonIgnore
    private String replicationSpeedPolicyData;
    private int timeout;
    private int repeatTimes = -1;

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setRepeatTimes(Integer repeatTimes) {
        this.repeatTimes = repeatTimes;
    }

    public void setScheduleId(String scheduleId) {
        this.scheduleId = scheduleId;
    }

    @Override
    public String getScheduleId() {
        return this.scheduleId;
    }

    @Override
    public String getStartTime() {
        return this.startTime;
    }

    public void setStartTime(String startTime) {
        this.startTime = startTime;
    }

    @Override
    public String getEndTime() {
        return this.endTime;
    }

    public void setEndTime(String endTime) {
        this.endTime = endTime;
    }

    public void setPeriodType(int periodType) {
        this.periodType = periodType;
    }

    @Override
    public int getPeriodType() {
        return this.periodType;
    }

    public void setPeriodInterval(int periodInterval) {
        this.periodInterval = periodInterval;
    }

    @Override
    public int getPeriodInterval() {
        return this.periodInterval;
    }

    public void setDaysOfWeek(String daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    @Override
    public String getDaysOfWeek() {
        return this.daysOfWeek;
    }

    public void setDaysOfMonth(String daysOfMonth) {
        this.daysOfMonth = daysOfMonth;
    }

    @Override
    public String getDaysOfMonth() {
        return this.daysOfMonth;
    }

    public void setLastDayOfMonth(int lastDayOfMonth) {
        this.lastDayOfMonth = lastDayOfMonth;
    }

    @Override
    public int getLastDayOfMonth() {
        return this.lastDayOfMonth;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setScheduleMode(int scheduleMode) {
        this.scheduleMode = scheduleMode;
    }

    @Override
    public int getScheduleMode() {
        return this.scheduleMode;
    }

    public int getProtectLocation() {
        return this.protectLocation;
    }

    public void setProtectLocation(int protectLocation) {
        this.protectLocation = protectLocation;
    }

    @Override
    public Set<ScheduleRangeTime> getScheduleRanges() {
        return this.scheduleRanges;
    }

    public void setScheduleRanges(Set<ScheduleRangeTime> scheduleRanges) {
        this.scheduleRanges = scheduleRanges;
    }

    public PolicyTemplate getPolicyTemplate() {
        return this.policyTemplate;
    }

    public void setPolicyTemplate(PolicyTemplate policyTemplate) {
        this.policyTemplate = policyTemplate;
    }

    @Override
    public String getHours() {
        return this.hours;
    }

    public void setHours(String hours) {
        this.hours = hours;
    }

    @Override
    public String getMinutes() {
        return this.minutes;
    }

    public void setMinutes(String minutes) {
        this.minutes = minutes;
    }

    @Override
    public String getAbortTaskTime() {
        return this.abortTaskTime;
    }

    public void setAbortTaskTime(String abortTaskTime) {
        this.abortTaskTime = abortTaskTime;
    }

    @Override
    public String getSeconds() {
        return this.seconds;
    }

    public void setSeconds(String seconds) {
        this.seconds = seconds;
    }

    public int getProtectedType() {
        return this.protectedType;
    }

    public void setProtectedType(int protectedType) {
        this.protectedType = protectedType;
    }

    public Boolean isEnable() {
        return this.enable;
    }

    public void setEnable(Boolean enable) {
        this.enable = enable;
    }

    public List<ReplicationSpeedPolicy> getReplicationSpeedPolicies() {
        if (types.contains(this.getProtectedType())) {
            return null;
        }
        if (this.replicationSpeedPolicies != null && !this.replicationSpeedPolicies.isEmpty()) {
            return this.replicationSpeedPolicies;
        }
        if (this.replicationSpeedPolicyData != null) {
            this.replicationSpeedPolicies = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)this.replicationSpeedPolicyData), ReplicationSpeedPolicy.class);
            return this.replicationSpeedPolicies;
        }
        this.loadReplicationSpeedFromTemplate();
        return this.replicationSpeedPolicies;
    }

    private void loadReplicationSpeedFromTemplate() {
        if (this.policyTemplate == null) {
            return;
        }
        String replicationSpeedString = this.policyTemplate.getProps().get("syncRateRecords");
        if (replicationSpeedString == null) {
            return;
        }
        JSONArray jsonArray = JSONArray.fromObject((Object)replicationSpeedString);
        this.replicationSpeedPolicies = JSONArray.toCollection((JSONArray)jsonArray, ReplicationSpeedPolicy.class);
    }

    public void setReplicationSpeedPolicies(List<ReplicationSpeedPolicy> replicationSpeedPolicies) {
        this.replicationSpeedPolicies = replicationSpeedPolicies;
    }

    public String getReplicationSpeedPolicyData() {
        if (this.replicationSpeedPolicies != null && !this.replicationSpeedPolicies.isEmpty()) {
            return JSONArray.fromObject(this.replicationSpeedPolicies).toString();
        }
        return this.replicationSpeedPolicyData;
    }

    public void setReplicationSpeedPolicyData(String replicationSpeedPolicyData) {
        this.replicationSpeedPolicyData = replicationSpeedPolicyData;
    }

    public RetentionPolicy getRetentionPolicy() {
        if (!types.contains(this.getProtectedType())) {
            return null;
        }
        if (this.retentionPolicy != null) {
            return this.retentionPolicy;
        }
        if (this.retentionPolicyData != null && !this.retentionPolicyData.equals("{}")) {
            this.retentionPolicy = (RetentionPolicy)JSONObject.toBean((String)this.retentionPolicyData, RetentionPolicy.class);
            return this.retentionPolicy;
        }
        this.loadFromTemplate();
        return this.retentionPolicy;
    }

    private void loadFromTemplate() {
        int latestCopies;
        if (this.policyTemplate == null) {
            return;
        }
        String snapshotCountStr = this.policyTemplate.getProps().get("PP_SNAPSHOT_COUNT");
        if (snapshotCountStr == null) {
            snapshotCountStr = this.policyTemplate.getProps().get("PP_SNAPSHOT_COUNT" + this.protectLocation);
        }
        if (snapshotCountStr == null) {
            return;
        }
        try {
            latestCopies = Integer.parseInt(snapshotCountStr);
        }
        catch (NumberFormatException e) {
            return;
        }
        this.retentionPolicy = new RetentionPolicy();
        this.retentionPolicy.setLatestCopies(latestCopies);
        String retentionPolicyString = this.policyTemplate.getProps().get("ReplicaRetentionPolicy");
        if (retentionPolicyString == null) {
            return;
        }
        JSONObject data = JSONObject.fromObject((Object)retentionPolicyString);
        JSONObject specLocationData = data.getJSONObject("ProtectLocation_" + this.protectLocation);
        if (specLocationData == null) {
            return;
        }
        JSONObject propsData = specLocationData.getJSONObject("props");
        if (propsData == null) {
            return;
        }
        int dailyCopies = propsData.getInt("dailyRetention");
        int weeklyCopies = propsData.getInt("weeklyRetention");
        int monthlyCopyies = propsData.getInt("monthlyRetention");
        this.retentionPolicy.setDailyCopies(dailyCopies);
        this.retentionPolicy.setWeeklyCopies(weeklyCopies);
        this.retentionPolicy.setMonthlyCopyies(monthlyCopyies);
    }

    public void setRetentionPolicy(RetentionPolicy retentionPolicy) {
        this.retentionPolicy = retentionPolicy;
    }

    public String getRetentionPolicyData() {
        if (this.retentionPolicy != null) {
            this.retentionPolicyData = JSONObject.fromObject((Object)this.retentionPolicy).toString();
        }
        return this.retentionPolicyData;
    }

    public void setRetentionPolicyData(String retentionPolicyData) {
        this.retentionPolicyData = retentionPolicyData;
    }

    public Boolean isEnableRpoCheck() {
        if (this.enableRpoCheck != null) {
            return this.enableRpoCheck;
        }
        this.loadRPOConfigFromTemplate();
        return this.enableRpoCheck;
    }

    public void setEnableRpoCheck(Boolean enableRpoCheck) {
        this.enableRpoCheck = enableRpoCheck;
    }

    public ExpectedRPO getExpectedRPO() {
        if (this.expectedRPO != null) {
            return this.expectedRPO;
        }
        if (this.expectionRPOData != null) {
            this.expectedRPO = (ExpectedRPO)JSONObject.toBean((String)this.expectionRPOData, ExpectedRPO.class);
            return this.expectedRPO;
        }
        this.loadRPOConfigFromTemplate();
        return this.expectedRPO;
    }

    private void loadRPOConfigFromTemplate() {
        if (this.policyTemplate == null) {
            return;
        }
        String rpoConfig = this.policyTemplate.getProps().get("RPO_SETTINGS");
        if (null == rpoConfig) {
            return;
        }
        JSONObject rpoConfigObject = JSONObject.fromObject((Object)rpoConfig);
        JSONObject specLocationRpoData = rpoConfigObject.getJSONObject("ProtectLocation_" + this.protectLocation);
        if (specLocationRpoData == null) {
            return;
        }
        JSONObject rpoData = specLocationRpoData.getJSONObject("RPO_SETTING_VALUE");
        if (rpoData == null) {
            return;
        }
        boolean enableRPOCheck = specLocationRpoData.getBoolean("ENABLE_RPO_CHECKING");
        this.enableRpoCheck = enableRPOCheck;
        this.expectedRPO = new ExpectedRPO();
        this.expectedRPO.setDay(rpoData.getInt("DAY"));
        this.expectedRPO.setHour(rpoData.getInt("HOUR"));
        this.expectedRPO.setMinute(rpoData.getInt("MINUTE"));
    }

    public void setExpectedRPO(ExpectedRPO expectedRPO) {
        this.expectedRPO = expectedRPO;
    }

    public String getExpectionRPOData() {
        if (this.expectedRPO != null) {
            this.expectionRPOData = JSONObject.fromObject((Object)this.expectedRPO).toString();
            return this.expectionRPOData;
        }
        return this.expectionRPOData;
    }

    public void setExpectionRPOData(String expectionRPOData) {
        this.expectionRPOData = expectionRPOData;
    }

    public Boolean isAppConsistent() {
        if (this.appConsistent != null) {
            return this.appConsistent;
        }
        if (null == this.policyTemplate) {
            return this.appConsistent;
        }
        String appConsistentFlag = null;
        for (String key : appConistentFlagList) {
            appConsistentFlag = this.policyTemplate.getProps().get(key);
            if (appConsistentFlag == null && (appConsistentFlag = this.policyTemplate.getProps().get(key + this.protectLocation)) == null) continue;
            break;
        }
        return "1".equals(appConsistentFlag);
    }

    public void setAppConsistent(Boolean appConsistent) {
        this.appConsistent = appConsistent;
    }

    public Map<String, String> getExtParameters() {
        if (this.policyTemplate != null) {
            for (String key : extParameterKeyList) {
                String value = this.policyTemplate.getProps().get(key);
                if (value == null) {
                    value = this.policyTemplate.getProps().get(key + this.protectLocation);
                }
                if (value == null) continue;
                this.extParameters.remove(key);
                this.extParameters.put(key, value);
            }
        }
        if (this.extParameterDatas != null) {
            this.extParameters.putAll((Map)JSONObject.toBean((String)this.extParameterDatas, Map.class));
        }
        return this.extParameters;
    }

    public void setExtParameters(Map<String, String> extParameters) {
        this.extParameters = extParameters;
    }

    public String getExtParameterDatas() {
        if (!VerifyUtil.isEmpty(this.extParameters)) {
            this.extParameterDatas = JSONObject.fromObject(this.extParameters).toString();
        }
        return this.extParameterDatas;
    }

    public String getSourceSn() {
        return this.sourceSn;
    }

    public void setSourceSn(String sourceSn) {
        this.sourceSn = sourceSn;
    }

    public String getTargetSn() {
        return this.targetSn;
    }

    public void setTargetSn(String targetSn) {
        this.targetSn = targetSn;
    }

    public String getSourceSiteId() {
        return this.sourceSiteId;
    }

    public void setSourceSiteId(String sourceSiteId) {
        this.sourceSiteId = sourceSiteId;
    }

    public String getTargetSiteId() {
        return this.targetSiteId;
    }

    public void setTargetSiteId(String targetSiteId) {
        this.targetSiteId = targetSiteId;
    }

    public void setExtParameterDatas(String extParameterDatas) {
        this.extParameterDatas = extParameterDatas;
    }

    @Override
    public int getRepeatTimes() {
        return this.repeatTimes;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = null == this.getScheduleId() ? 31 * result + super.hashCode() : 31 * result + this.getScheduleId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Schedule other = (Schedule)obj;
        if (null == this.getScheduleId() || null == other.getScheduleId()) {
            return false;
        }
        return this.getScheduleId().equals(other.getScheduleId());
    }

    public Object clone() throws CloneNotSupportedException {
        Schedule schedule = (Schedule)super.clone();
        Set<ScheduleRangeTime> rangeTimes = schedule.getScheduleRanges();
        HashSet<ScheduleRangeTime> rangeTimeList = new HashSet<ScheduleRangeTime>();
        for (ScheduleRangeTime time : rangeTimes) {
            rangeTimeList.add((ScheduleRangeTime)time.clone());
        }
        schedule.setScheduleRanges(rangeTimeList);
        return schedule;
    }

    public boolean isEqual(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Schedule other = (Schedule)obj;
        StringBuilder sb = new StringBuilder();
        sb.append(this.scheduleId).append(this.name).append(this.startTime).append(this.endTime).append(this.periodType).append(this.periodInterval).append(this.daysOfWeek).append(this.daysOfMonth).append(this.lastDayOfMonth).append(this.scheduleMode).append(this.protectLocation).append(this.abortTaskTime).append(this.hours).append(this.minutes).append(this.seconds).append(this.protectedType);
        StringBuilder otherSb = new StringBuilder();
        otherSb.append(other.getScheduleId()).append(other.getName()).append(other.getStartTime()).append(other.getEndTime()).append(other.getPeriodType()).append(other.getPeriodInterval()).append(other.daysOfWeek).append(other.daysOfMonth).append(other.lastDayOfMonth).append(other.scheduleMode).append(other.protectLocation).append(other.abortTaskTime).append(other.hours).append(other.minutes).append(other.seconds).append(other.getProtectedType());
        return this.checkSheduleRangeTimeEqual(other, sb, otherSb);
    }

    private boolean checkSheduleRangeTimeEqual(Schedule other, StringBuilder sb, StringBuilder otherSb) {
        if (!sb.toString().equals(otherSb.toString())) {
            return false;
        }
        if (this.scheduleRanges == null) {
            if (other.scheduleRanges != null) {
                return false;
            }
        } else if (other.getScheduleRanges() != null) {
            if (!this.scheduleRanges.containsAll(other.getScheduleRanges()) || this.scheduleRanges.size() != other.getScheduleRanges().size()) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void checkPeriodInterval() {
        if (this.appConsistent == null || !this.appConsistent.booleanValue()) {
            return;
        }
        if (this.scheduleMode == 1) {
            return;
        }
        if (this.periodType == 5) {
            throw new LegoCheckedException(1073947393L);
        }
        if (this.periodType == 0 && this.getPeriodInterval() < 15) {
            throw new LegoCheckedException(1073947393L);
        }
    }

    static {
        appConistentFlagList.add("ORACLE_FREEZE_FLAG");
        appConistentFlagList.add("vmSnapshotFlag");
        appConistentFlagList.add("APP_FREEZE_FLAG");
        extParameterKeyList.add("ORACLE_CAP_THREASHOLD");
        extParameterKeyList.add("hostOrGroupId");
        extParameterKeyList.add("thawScript");
        extParameterKeyList.add("queryFreezeStatusScript");
        extParameterKeyList.add("freezeTimeout");
        extParameterKeyList.add("freezeScript");
        extParameterKeyList.add("scriptSchemeId");
        extParameterKeyList.add("userFreezeParam");
        extParameterKeyList.add("unfreezeFile");
        extParameterKeyList.add("unfreezeParam");
        extParameterKeyList.add("userUnfreezeParam");
        extParameterKeyList.add("queryParam");
        extParameterKeyList.add("userQueryParam");
        extParameterKeyList.add("publicParam");
        extParameterKeyList.add("freezeParams");
        extParameterKeyList.add("queryFile");
        extParameterKeyList.add("queryParam");
        extParameterKeyList.add("userQueryParam");
        extParameterKeyList.add("beforeParam");
        extParameterKeyList.add("userBeforeParam");
        extParameterKeyList.add("afterParam");
        extParameterKeyList.add("userAfterParam");
        extParameterKeyList.add("isUserDefined");
        extParameterKeyList.add("0");
    }
}

