/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.protection.template.sdk.model;

import com.huawei.ism.drm.common.sdk.model.DRMObject;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.lego.core.sdk.util.UUIDGenerator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PolicyTemplate
extends DRMObject
implements Cloneable {
    private static final long serialVersionUID = 3322703200437655407L;
    private String ptId;
    private int type;
    private int subType;
    private String sketch;
    private String viewTemplateUrl;
    private String editTemplateUrl;
    private Boolean isSystemDefine;
    private Set<Schedule> schedules = new HashSet<Schedule>();
    private byte[] protectFlowDefine;
    private int replicationType;
    private Map<String, String> props;
    private String parentId;
    private boolean available = true;
    private long errorCode;
    private String[] parameters;

    public PolicyTemplate() {
        this.ptId = UUIDGenerator.getUUID();
        this.setUuid(this.ptId);
    }

    public Map<String, String> getProps() {
        if (this.props == null) {
            this.props = new HashMap<String, String>();
        }
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public void setPtId(String ptId) {
        this.ptId = ptId;
    }

    public String getPtId() {
        return this.ptId;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public String getSketch() {
        return this.sketch;
    }

    public void setSketch(String sketch) {
        this.sketch = sketch;
    }

    public String getViewTemplateUrl() {
        return this.viewTemplateUrl;
    }

    public void setViewTemplateUrl(String viewTemplateUrl) {
        this.viewTemplateUrl = viewTemplateUrl;
    }

    public String getEditTemplateUrl() {
        return this.editTemplateUrl;
    }

    public void setEditTemplateUrl(String editTemplateUrl) {
        this.editTemplateUrl = editTemplateUrl;
    }

    public Set<Schedule> getSchedules() {
        return this.schedules;
    }

    public void setSchedules(Set<Schedule> schedules) {
        this.schedules = schedules;
    }

    public byte[] getProtectFlowDefine() {
        return this.protectFlowDefine;
    }

    public void setProtectFlowDefine(byte[] protectFlowDefine) {
        this.protectFlowDefine = protectFlowDefine;
    }

    public void setIsSystemDefine(Boolean isSystemDefine) {
        this.isSystemDefine = isSystemDefine;
    }

    public Boolean getIsSystemDefine() {
        return this.isSystemDefine;
    }

    public void setReplicationType(int replicationType) {
        this.replicationType = replicationType;
    }

    public int getReplicationType() {
        return this.replicationType;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public long getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(long errorCode) {
        this.errorCode = errorCode;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public void setParameters(String[] parameters) {
        this.parameters = parameters;
    }

    public int getSubType() {
        return this.subType;
    }

    public void setSubType(int subType) {
        this.subType = subType;
    }

    public Object clone() throws CloneNotSupportedException {
        PolicyTemplate result = (PolicyTemplate)super.clone();
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.putAll(this.getProps());
        result.setProps(newMap);
        result.setIsSystemDefine(false);
        HashSet<Schedule> scheduleList = new HashSet<Schedule>();
        for (Schedule schedule : result.getSchedules()) {
            scheduleList.add((Schedule)schedule.clone());
        }
        result.setSchedules(scheduleList);
        return result;
    }

    public boolean removeSchedule(String scheduleId) {
        if (this.schedules == null) {
            return false;
        }
        Schedule schedule = this.schedules.stream().filter(item -> item.getScheduleId().equals(scheduleId)).findFirst().orElse(null);
        if (schedule == null) {
            return false;
        }
        return this.getSchedules().remove(schedule);
    }

    public boolean addSchedule(Schedule schedule) {
        if (this.schedules == null) {
            return false;
        }
        return this.schedules.add(schedule);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

