/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.util;

import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeDefTemplate;
import com.huawei.ism.drm.common.sdk.model.ScriptSchemeStep;
import com.huawei.ism.drm.protection.action.service.IHostScriptSchemeService;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.WccEncryptor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ScriptParamsUtils {
    private static final Log logger = LogFactory.getInstance(ScriptParamsUtils.class);
    private static ScriptParamsUtils instance = new ScriptParamsUtils();

    public static ScriptParamsUtils getInstance() {
        return instance;
    }

    public static String decryptSensitiveParam(Map<String, String[]> paramValidation, String params) {
        if (VerifyUtil.isEmpty((String)params)) {
            return new JSONObject().toString();
        }
        JSONObject jsonParams = JSONObject.fromObject((Object)params);
        for (Object key : jsonParams.keySet()) {
            String value = jsonParams.getString((String)key);
            if (VerifyUtil.isEmpty((Object[])paramValidation.get(key))) continue;
            String sensitive = paramValidation.get(key)[3];
            String decryptValue = "";
            if ("true".equals(sensitive) && !VerifyUtil.isEmpty((String)value)) {
                decryptValue = WccEncryptor.decrypt((String)value);
            } else if (!VerifyUtil.isEmpty((String)value)) {
                decryptValue = value;
            }
            jsonParams.put(key, (Object)decryptValue);
        }
        return jsonParams.toString();
    }

    public static JSONObject decryptSensitiveParam(JSONObject data, List<Map<String, Object>> rules) {
        boolean changed = false;
        for (Map<String, Object> rule : rules) {
            String name = String.valueOf(rule.get("name"));
            if (!data.containsKey((Object)name) || !"true".equals(String.valueOf(rule.get("sensitive")))) continue;
            String value = data.getString(name);
            data.put((Object)name, (Object)WccEncryptor.decrypt((String)value));
            changed = true;
        }
        return changed ? data : null;
    }

    public static void filterSensitiveParams(Schedule schedule) {
        Map<String, String> props = schedule.getExtParameters();
        if (!"0".equals(props.get("isUserDefined"))) {
            logger.info((Object)"user use user-defined scripts.");
            return;
        }
        String schemeId = props.get("scriptSchemeId");
        String freezeScriptParam = props.get("freezeParams");
        String thawScriptParam = props.get("unfreezeParam");
        String queryFreezeScriptParam = props.get("queryParam");
        logger.info((Object)"user use script scheme, filtering key of params, id: %s", new Object[]{schemeId});
        Map<String, String[]> paramValidation = ((IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class)).getParamValidation(schemeId);
        props.put("freezeParams", ScriptParamsUtils.filterSensitiveParam(paramValidation, freezeScriptParam));
        props.put("unfreezeParam", ScriptParamsUtils.filterSensitiveParam(paramValidation, thawScriptParam));
        props.put("queryParam", ScriptParamsUtils.filterSensitiveParam(paramValidation, queryFreezeScriptParam));
        String beforeScriptParam = props.get("beforeParam");
        props.put("beforeParam", ScriptParamsUtils.filterSensitiveParam(paramValidation, beforeScriptParam));
        String afterScriptParam = props.get("afterParam");
        props.put("afterParam", ScriptParamsUtils.filterSensitiveParam(paramValidation, afterScriptParam));
        String publicScriptParam = props.get("publicParam");
        props.put("publicParam", ScriptParamsUtils.filterSensitiveParam(paramValidation, publicScriptParam));
        schedule.getExtParameterDatas();
    }

    public static String filterSensitiveParam(Map<String, String[]> paramValidation, String params) {
        JSONObject jsonParams = JSONObject.fromObject((Object)params);
        Iterator it = jsonParams.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = (Map.Entry)it.next();
            Object key = entry.getKey();
            if (VerifyUtil.isEmpty((Object[])paramValidation.get(key))) continue;
            Object value = entry.getValue();
            String sensitive = paramValidation.get(key)[3];
            if (!"true".equals(sensitive) || VerifyUtil.isEmpty(value)) continue;
            it.remove();
        }
        return jsonParams.toString();
    }

    public static void validateScriptParams(Map<String, String[]> paramValidation, String params) {
        if (VerifyUtil.isEmpty((String)params)) {
            return;
        }
        JSONObject jsonParams = JSONObject.fromObject((Object)params);
        for (Object key : jsonParams.keySet()) {
            String value = jsonParams.getString((String)key);
            if (VerifyUtil.isEmpty((Object[])paramValidation.get(key))) continue;
            String optional = paramValidation.get(key)[0];
            String length = paramValidation.get(key)[1];
            String expr = paramValidation.get(key)[2];
            if (!"true".equals(optional) && VerifyUtil.isEmpty((String)value)) {
                logger.error((Object)("check param failed , " + value + " cannot be null"), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            if (CommUtil.checkParam(value, expr, 0, Integer.parseInt(length))) continue;
            logger.error((Object)("check param failed , " + value + " is not match"), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void validateScriptParams(JSONObject param, List<Map<String, Object>> validations) {
        for (Map<String, Object> rule : validations) {
            Integer length;
            String name = String.valueOf(rule.get("name"));
            if (!param.containsKey((Object)name)) continue;
            String value = param.getString(name);
            if (VerifyUtil.isEmpty((String)value)) {
                if ("true".equals(String.valueOf(rule.get("optional")))) continue;
                logger.error((Object)("not provide param " + name), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            String expr = String.valueOf(rule.get("expr"));
            if (CommUtil.checkParam(value, expr, 0, length = NumberUtil.convertToInteger((Object)rule.get("length"), (int)256))) continue;
            logger.error((Object)("check param failed , " + name + " is not match length"), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static void checkParamsNullable(Map<String, String[]> paramValidation, String params) {
        if (VerifyUtil.isEmpty((String)params)) {
            return;
        }
        JSONObject jsonParams = JSONObject.fromObject((Object)params);
        for (Object key : jsonParams.keySet()) {
            String optional;
            if ("scriptScheme".equals((String)key)) continue;
            String value = jsonParams.getString((String)key);
            if (VerifyUtil.isEmpty((Object[])paramValidation.get(key)) || "true".equals(optional = paramValidation.get(key)[0]) || !VerifyUtil.isEmpty((String)value)) continue;
            logger.error((Object)("script " + key + " cannot be null "));
            String[] errorParams = new String[]{jsonParams.getString("scriptScheme")};
            throw new LegoCheckedException(1073947466L, errorParams);
        }
    }

    public static void ecryptScriptStepParams(Map<String, String> props, String position, String name, ScriptSchemeDefTemplate scheme) {
        ScriptSchemeStep step = ScriptParamsUtils.getStepByPosition(scheme, position);
        ScriptParamsUtils.ecryptScriptParams(props, name, step.getParams(), false);
    }

    public static JSONObject ecryptScriptParams(JSONObject data, List<Map<String, Object>> opts, boolean strict) {
        if (data == null || opts == null) {
            return data;
        }
        boolean changed = false;
        for (Map<String, Object> opt : opts) {
            if (!opt.containsKey("sensitive")) {
                if (!strict) continue;
                throw new LegoCheckedException(1073947393L);
            }
            String name = String.valueOf(opt.get("name"));
            String value = data.getString(name);
            String sensitive = String.valueOf(opt.get("sensitive"));
            if (!"true".equals(sensitive) || VerifyUtil.isEmpty((String)value)) continue;
            data.put((Object)name, (Object)WccEncryptor.encrypt((String)value));
            changed = true;
        }
        return changed ? data : null;
    }

    public static void ecryptScriptParams(Map<String, String> props, String name, List<Map<String, Object>> opts, boolean strict) {
        String param = props.get(name);
        JSONObject json = JSONObject.fromObject((Object)param);
        if (ScriptParamsUtils.ecryptScriptParams(json, opts, strict) != null) {
            props.put(name, json.toString());
        }
    }

    public static ScriptSchemeStep getStepByPosition(ScriptSchemeDefTemplate scheme, String position) {
        return scheme.getSteps().stream().filter(item -> position.equals(item.getPosition())).findFirst().orElseThrow(() -> new LegoCheckedException(0L));
    }

    public static String updateSensitiveParam(Map<String, String[]> paramValidation, String frontScriptParams, String backScriptParams) {
        JSONObject frontJsonParams = ScriptParamsUtils.jsonify(frontScriptParams);
        JSONObject backJsonParams = ScriptParamsUtils.jsonify(backScriptParams);
        if (VerifyUtil.isEmpty((Map)backJsonParams)) {
            for (Map.Entry<String, String[]> paramInfo : paramValidation.entrySet()) {
                String paramKey = paramInfo.getKey();
                String sensitive = paramInfo.getValue()[3];
                if (!frontJsonParams.containsKey((Object)paramKey) || !"true".equals(sensitive)) continue;
                String frontValue = frontJsonParams.getString(paramKey);
                String encryptFrontValue = VerifyUtil.isEmpty((String)frontValue) ? "" : WccEncryptor.encrypt((String)frontValue);
                frontJsonParams.put((Object)paramKey, (Object)encryptFrontValue);
            }
        } else {
            for (Map.Entry<String, String[]> paramInfo : paramValidation.entrySet()) {
                String paramKey = paramInfo.getKey();
                String sensitive = paramInfo.getValue()[3];
                if (!backJsonParams.containsKey((Object)paramKey) || !"true".equals(sensitive)) continue;
                String backValue = backJsonParams.getString(paramKey);
                if (!frontJsonParams.containsKey((Object)paramKey)) {
                    frontJsonParams.put((Object)paramKey, (Object)backValue);
                    continue;
                }
                String frontValue = frontJsonParams.getString(paramKey);
                String encryptFrontValue = VerifyUtil.isEmpty((String)frontValue) ? "" : WccEncryptor.encrypt((String)frontValue);
                frontJsonParams.put((Object)paramKey, (Object)encryptFrontValue);
            }
        }
        return frontJsonParams.toString();
    }

    private static JSONObject jsonify(String data) {
        JSONObject json = !VerifyUtil.isEmpty((String)data) ? JSONObject.fromObject((Object)data) : new JSONObject();
        return json;
    }

    public static void validateUserDefinedParams(String userScriptParams) {
        if (VerifyUtil.isEmpty((String)userScriptParams)) {
            return;
        }
        JSONObject jsonParams = JSONObject.fromObject((Object)userScriptParams);
        for (Object key : jsonParams.keySet()) {
            String value = jsonParams.getString((String)key);
            if (VerifyUtil.isEmpty(key)) {
                logger.error((Object)("script param key\uff1a" + key + " cannot be null "));
                throw new LegoCheckedException(1073947393L);
            }
            if (jsonParams.size() > 128) {
                logger.error((Object)"The number of parameters cannot exceed 128 pairs");
                throw new LegoCheckedException(1073947393L);
            }
            String keyStr = (String)key;
            if (keyStr.length() > 128) {
                logger.error((Object)("script param key: " + keyStr + "length cannot be greater than 128"), 90160758787071L);
                throw new LegoCheckedException(1073947393L);
            }
            if (value.length() <= 512) continue;
            logger.error((Object)("script param value: " + value + "length cannot be greater than 512"), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    public static Map<String, String> getFreezeThawFrontScriptParams(Map<String, String> extParameters) {
        String schemeId = extParameters.get("scriptSchemeId");
        String freezeScriptParam = extParameters.get("freezeParams");
        String userFreezeScriptParam = extParameters.get("userFreezeParam");
        freezeScriptParam = ScriptParamsUtils.mergeParams(userFreezeScriptParam, freezeScriptParam);
        String unfreezeScriptParam = extParameters.get("unfreezeParam");
        String userUnfreezeScriptParam = extParameters.get("userUnfreezeParam");
        unfreezeScriptParam = ScriptParamsUtils.mergeParams(userUnfreezeScriptParam, unfreezeScriptParam);
        String queryFreezeScriptParam = extParameters.get("queryParam");
        String userQueryFreezeScriptParam = extParameters.get("userQueryParam");
        queryFreezeScriptParam = ScriptParamsUtils.mergeParams(userQueryFreezeScriptParam, queryFreezeScriptParam);
        String publicScriptParam = extParameters.get("publicParam");
        Map<String, String[]> paramValidation = ((IHostScriptSchemeService)ServiceLocator.getInstance().getService(IHostScriptSchemeService.class)).getParamValidation(schemeId);
        publicScriptParam = ScriptParamsUtils.decryptSensitiveParam(paramValidation, publicScriptParam);
        HashMap<String, String> scriptParams = new HashMap<String, String>();
        scriptParams.put("freezeParams", ScriptParamsUtils.mergeParams(publicScriptParam, ScriptParamsUtils.decryptSensitiveParam(paramValidation, freezeScriptParam)));
        scriptParams.put("unfreezeParam", ScriptParamsUtils.mergeParams(publicScriptParam, ScriptParamsUtils.decryptSensitiveParam(paramValidation, unfreezeScriptParam)));
        scriptParams.put("queryParam", ScriptParamsUtils.mergeParams(publicScriptParam, ScriptParamsUtils.decryptSensitiveParam(paramValidation, queryFreezeScriptParam)));
        return scriptParams;
    }

    public static String mergeParams(String mergedScriptParam, String scriptParam) {
        Map mergedScriptJsonParam = new HashMap();
        if (!VerifyUtil.isEmpty((String)mergedScriptParam)) {
            mergedScriptJsonParam = (Map)JSONObject.toBean((String)mergedScriptParam, Map.class);
        }
        JSONObject scriptJsonParam = JSONObject.fromObject((Object)scriptParam);
        scriptJsonParam.putAll(mergedScriptJsonParam);
        return scriptJsonParam.toString();
    }

    public static void validateSchemeScriptParams(Map<String, String[]> paramValidation, String params) {
        if (VerifyUtil.isEmpty((String)params)) {
            return;
        }
        JSONObject jsonParams = JSONObject.fromObject((Object)params);
        for (Map.Entry<String, String[]> entry : paramValidation.entrySet()) {
            String expr;
            String length;
            boolean result;
            String key = entry.getKey();
            if (!jsonParams.containsKey((Object)key)) continue;
            String[] validation = entry.getValue();
            String value = jsonParams.getString(key);
            int i = 0;
            String optional = validation[i++];
            if (result = ScriptParamsUtils.validateParam(value, optional, length = validation[i++], expr = validation[i++])) continue;
            logger.error((Object)("check param failed , " + value + " is not match"), 90160758787071L);
            throw new LegoCheckedException(1073947393L);
        }
    }

    private static boolean validateParam(String value, String optional, String length, String expr) {
        if (!"true".equals(optional) && VerifyUtil.isEmpty((String)value)) {
            return false;
        }
        return CommUtil.checkParam(value, expr, 0, Integer.parseInt(length));
    }
}

