/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.SetupQueryRunner;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.ProtocolConnectionImpl;
import org.postgresql.gss.MakeGSS;
import org.postgresql.hostchooser.CandidateHost;
import org.postgresql.hostchooser.GlobalHostStatusTracker;
import org.postgresql.hostchooser.HostChooser;
import org.postgresql.hostchooser.HostChooserFactory;
import org.postgresql.hostchooser.HostRequirement;
import org.postgresql.hostchooser.HostStatus;
import org.postgresql.ssl.MakeSSL;
import org.postgresql.util.GT;
import org.postgresql.util.HostSpec;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.PSQLWarning;
import org.postgresql.util.ServerErrorMessage;
import org.postgresql.util.UnixCrypt;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_SCM = 6;
    private static final int AUTH_REQ_GSS = 7;
    private static final int AUTH_REQ_GSS_CONTINUE = 8;
    private static final int AUTH_REQ_SSPI = 9;
    private static final int AUTH_REQ_SHA256 = 10;
    private static final int PLAIN_PASSWORD = 0;
    private static final int SHA256_PASSWORD = 2;
    private static final int ERROR_PASSWORD = 3;
    private static final int AUTH_REQ_SHA256_RFC = 12;
    private static final int SHA256_PASSWORD_RFC = 6;
    public static String CLIENT_ENCODING = "UTF8";
    public static String USE_BOOLEAN = "false";
    public static String DATABASE_TYPE = "GaussDB";
    public static String THIRD_PART = "";
    public static String USE_RAW = "false";

    @Override
    public ProtocolConnection openConnectionImpl(HostSpec[] hostSpecs, String user, String database, Properties info, Logger logger) throws SQLException {
        HostRequirement targetServerType;
        boolean requireSSL;
        boolean trySSL = requireSSL = info.getProperty("ssl") != null;
        if (info.getProperty("characterEncoding") != null && ("UTF8".equals(info.getProperty("characterEncoding").toUpperCase()) || "GBK".equals(info.getProperty("characterEncoding").toUpperCase()))) {
            CLIENT_ENCODING = info.getProperty("characterEncoding").toUpperCase();
        }
        boolean mytrySSL = true;
        mytrySSL = !"true".equals(info.getProperty("trySSL"));
        if (info.getProperty("use_boolean") != null) {
            USE_BOOLEAN = info.getProperty("use_boolean").toUpperCase();
        }
        if (info.getProperty("database_type") != null) {
            DATABASE_TYPE = info.getProperty("database_type").toUpperCase();
        }
        if (info.getProperty("third_part") != null) {
            THIRD_PART = info.getProperty("third_part").toUpperCase();
        }
        if (info.getProperty("use_raw") != null) {
            USE_RAW = info.getProperty("use_raw").toUpperCase();
        }
        boolean requireTCPKeepAlive = Boolean.valueOf(info.getProperty("tcpKeepAlive"));
        try {
            targetServerType = HostRequirement.getTargetServerType(info.getProperty("targetServerType", HostRequirement.any.name()));
        }
        catch (IllegalArgumentException ex) {
            throw new PSQLException(GT.tr("Invalid targetServerType value: {0}", info.getProperty("targetServerType")), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
        }
        HostChooser hostChooser = HostChooserFactory.createHostChooser(hostSpecs, targetServerType, info);
        Iterator<CandidateHost> hostIter = hostChooser.iterator();
        HashMap<HostSpec, HostStatus> knownStates = new HashMap<HostSpec, HostStatus>();
        while (hostIter.hasNext()) {
            HostStatus knownStatus;
            CandidateHost candidateHost = hostIter.next();
            HostSpec hostSpec = candidateHost.hostSpec;
            if (logger.logDebug()) {
                logger.debug("Trying to establish a protocol version 3 connection to " + hostSpec);
            }
            if ((knownStatus = (HostStatus)((Object)knownStates.get(hostSpec))) != null && !candidateHost.targetServerType.allowConnectingTo(knownStatus)) continue;
            PGStream newStream = null;
            try {
                newStream = new PGStream(hostSpec);
                if (trySSL) {
                    newStream = this.enableSSL(newStream, mytrySSL, info, logger);
                }
                String socketTimeoutProperty = info.getProperty("socketTimeout", "0");
                try {
                    int socketTimeout = Integer.parseInt(socketTimeoutProperty);
                    if (socketTimeout > 0) {
                        newStream.getSocket().setSoTimeout(socketTimeout * 1000);
                    }
                }
                catch (NumberFormatException nfe) {
                    logger.info("Couldn't parse socketTimeout value:" + socketTimeoutProperty);
                }
                newStream.getSocket().setKeepAlive(requireTCPKeepAlive);
                database = database.toUpperCase();
                String[][] params = new String[][]{{"user", user}, {"database", database}, {"client_encoding", CLIENT_ENCODING}, {"DateStyle", "ISO"}, {"extra_float_digits", "2"}};
                this.sendStartupPacket(newStream, params, logger);
                this.doAuthentication(newStream, hostSpec.getHost(), user, info, logger);
                ProtocolConnectionImpl protoConnection = new ProtocolConnectionImpl(newStream, user, database, info, logger);
                this.readStartupMessages(newStream, protoConnection, logger);
                HostStatus hostStatus = HostStatus.ConnectOK;
                if (candidateHost.targetServerType != HostRequirement.any) {
                    hostStatus = this.isMaster(protoConnection) ? HostStatus.Master : HostStatus.Secondary;
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpec, hostStatus);
                knownStates.put(hostSpec, hostStatus);
                if (!candidateHost.targetServerType.allowConnectingTo(hostStatus)) {
                    protoConnection.close();
                    continue;
                }
                this.runInitialQueries(protoConnection, info, logger);
                return protoConnection;
            }
            catch (UnsupportedProtocolException upe) {
                if (logger.logDebug()) {
                    logger.debug("Protocol not supported, abandoning connection.");
                }
                try {
                    newStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return null;
            }
            catch (ConnectException cex) {
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) continue;
                throw new PSQLException(GT.tr("Connection refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)cex);
            }
            catch (IOException ioe) {
                if (newStream != null) {
                    try {
                        newStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) continue;
                throw new PSQLException(GT.tr("The connection attempt failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
            }
            catch (SQLException se) {
                if (newStream != null) {
                    try {
                        newStream.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                GlobalHostStatusTracker.reportHostStatus(hostSpec, HostStatus.ConnectFail);
                knownStates.put(hostSpec, HostStatus.ConnectFail);
                if (hostIter.hasNext()) continue;
                throw se;
            }
        }
        throw new PSQLException(GT.tr("Could not find a server with specified targetServerType: {0}", (Object)targetServerType), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private PGStream enableSSL(PGStream pgStream, boolean requireSSL, Properties info, Logger logger) throws IOException, SQLException {
        if (logger.logDebug()) {
            logger.debug(" FE=> SSLRequest");
        }
        pgStream.SendInteger4(8);
        pgStream.SendInteger2(1234);
        pgStream.SendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.ReceiveChar();
        switch (beresp) {
            case 69: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLError");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_REJECTED);
                }
                pgStream.close();
                return new PGStream(pgStream.getHostSpec());
            }
            case 78: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLRefused");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_REJECTED);
                }
                return pgStream;
            }
            case 83: {
                if (logger.logDebug()) {
                    logger.debug(" <=BE SSLOk");
                }
                MakeSSL.convert(pgStream, info, logger);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occured while setting up the SSL connection."), PSQLState.PROTOCOL_VIOLATION);
    }

    private void sendStartupPacket(PGStream pgStream, String[][] params, Logger logger) throws IOException {
        int i;
        if (logger.logDebug()) {
            String details = "";
            for (int i2 = 0; i2 < params.length; ++i2) {
                if (i2 != 0) {
                    details = details + ", ";
                }
                details = details + params[i2][0] + "=" + params[i2][1];
            }
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.length * 2][];
        for (i = 0; i < params.length; ++i) {
            encodedParams[i * 2] = params[i][0].getBytes("UTF-8");
            encodedParams[i * 2 + 1] = params[i][1].getBytes("UTF-8");
            length += encodedParams[i * 2].length + 1 + encodedParams[i * 2 + 1].length + 1;
        }
        pgStream.SendInteger4(++length);
        pgStream.SendInteger2(3);
        pgStream.SendInteger2(0);
        for (i = 0; i < encodedParams.length; ++i) {
            pgStream.Send(encodedParams[i]);
            pgStream.SendChar(0);
        }
        pgStream.SendChar(0);
        pgStream.flush();
    }

    private void doAuthentication(PGStream pgStream, String host, String user, Properties info, Logger logger) throws IOException, SQLException {
        String password = info.getProperty("password");
        String authuser = user.toUpperCase();
        block13: while (true) {
            int beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 69: {
                    int l_elen = pgStream.ReceiveInteger4();
                    if (l_elen > 30000) {
                        throw new UnsupportedProtocolException();
                    }
                    ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.ReceiveString(l_elen - 4), logger.getLogLevel());
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ErrorMessage(" + errorMsg + ")");
                    }
                    throw new PSQLException(errorMsg);
                }
                case 82: {
                    int l_msgLen = pgStream.ReceiveInteger4();
                    int areq = pgStream.ReceiveInteger4();
                    switch (areq) {
                        case 4: {
                            byte[] salt = pgStream.Receive(2);
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqCrypt(salt='" + new String(salt, "US-ASCII") + "')");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] encodedResult = UnixCrypt.crypt(salt, password.getBytes("UTF-8"));
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + encodedResult.length + 1);
                            pgStream.Send(encodedResult);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block13;
                        }
                        case 10: {
                            byte[] digest = new byte[]{0};
                            byte[] random16code = pgStream.Receive(16);
                            byte[] md5Salt = pgStream.Receive(4);
                            int passwordStoredMethod = pgStream.ReceiveInteger4();
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqSHA256(salt=" + Utils.toHexString(md5Salt) + ")");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            if (passwordStoredMethod != 0 && passwordStoredMethod != 2) {
                                throw new PSQLException(GT.tr("FATAL: Invalid username/password,login denied."), PSQLState.CONNECTION_REJECTED);
                            }
                            digest = MD5Digest.SHA256encode(random16code, password.getBytes("UTF-8"), md5Salt);
                            if (logger.logDebug()) {
                                logger.debug(" FE=> Password(sha256digest=" + new String(digest, "US-ASCII") + ")");
                            }
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + digest.length + 1);
                            pgStream.Send(digest);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block13;
                        }
                        case 12: {
                            byte[] digest = new byte[]{0};
                            int passwordStoredMethod = pgStream.ReceiveInteger4();
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            if (passwordStoredMethod == 0 || passwordStoredMethod == 6) {
                                String random64code = pgStream.ReceiveString(64);
                                String token = pgStream.ReceiveString(8);
                                String server_signature = pgStream.ReceiveString(64);
                                byte[] result = MD5Digest.RFC5802Algorithm(password, random64code, token, server_signature);
                                pgStream.SendChar(112);
                                pgStream.SendInteger4(4 + result.length + 1);
                                pgStream.Send(result);
                                pgStream.SendChar(0);
                                pgStream.flush();
                                continue block13;
                            }
                            throw new PSQLException(GT.tr("The password-stored method is not supported ,must be sha256."), PSQLState.CONNECTION_REJECTED);
                        }
                        case 3: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqPassword");
                                logger.debug(" FE=> Password(password=<not shown>)");
                            }
                            throw new PSQLException(GT.tr("Authentication of sending password directly is not supported any longer."), PSQLState.CONNECTION_REJECTED);
                        }
                        case 7: {
                            MakeGSS.authenticate(pgStream, host, user, password, info.getProperty("jaasApplicationName"), info.getProperty("kerberosServerName"), logger);
                            continue block13;
                        }
                        case 9: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationReqSSPI");
                            }
                            throw new PSQLException(GT.tr("SSPI authentication is not supported because it is not portable.  Try configuring the server to use GSSAPI instead."), PSQLState.CONNECTION_REJECTED);
                        }
                        case 0: {
                            if (logger.logDebug()) {
                                logger.debug(" <=BE AuthenticationOk");
                            }
                            return;
                        }
                    }
                    if (logger.logDebug()) {
                        logger.debug(" <=BE AuthenticationReq (unsupported type " + areq + ")");
                    }
                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", new Integer(areq)), PSQLState.CONNECTION_REJECTED);
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
    }

    private void readStartupMessages(PGStream pgStream, ProtocolConnectionImpl protoConnection, Logger logger) throws IOException, SQLException {
        int beresp;
        block12: while (true) {
            beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    if (pgStream.ReceiveInteger4() != 5) {
                        throw new IOException("unexpected length of ReadyForQuery packet");
                    }
                    char tStatus = (char)pgStream.ReceiveChar();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ReadyForQuery(" + tStatus + ")");
                    }
                    switch (tStatus) {
                        case 'I': {
                            protoConnection.setTransactionState(0);
                            break;
                        }
                        case 'T': {
                            protoConnection.setTransactionState(1);
                            break;
                        }
                        case 'E': {
                            protoConnection.setTransactionState(2);
                            break;
                        }
                    }
                    return;
                }
                case 75: {
                    int l_msgLen = pgStream.ReceiveInteger4();
                    if (l_msgLen != 12) {
                        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
                    }
                    int pid = pgStream.ReceiveInteger4();
                    int ckey = pgStream.ReceiveInteger4();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE BackendKeyData(pid=" + pid + ",ckey=" + ckey + ")");
                    }
                    protoConnection.setBackendKeyData(pid, ckey);
                    continue block12;
                }
                case 69: {
                    int l_elen = pgStream.ReceiveInteger4();
                    ServerErrorMessage l_errorMsg = new ServerErrorMessage(pgStream.ReceiveString(l_elen - 4), logger.getLogLevel());
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ErrorMessage(" + l_errorMsg + ")");
                    }
                    throw new PSQLException(l_errorMsg);
                }
                case 78: {
                    int l_nlen = pgStream.ReceiveInteger4();
                    ServerErrorMessage l_warnMsg = new ServerErrorMessage(pgStream.ReceiveString(l_nlen - 4), logger.getLogLevel());
                    if (logger.logDebug()) {
                        logger.debug(" <=BE NoticeResponse(" + l_warnMsg + ")");
                    }
                    protoConnection.addWarning(new PSQLWarning(l_warnMsg));
                    continue block12;
                }
                case 83: {
                    int l_len = pgStream.ReceiveInteger4();
                    String name = pgStream.ReceiveString();
                    String value = pgStream.ReceiveString();
                    if (logger.logDebug()) {
                        logger.debug(" <=BE ParameterStatus(" + name + " = " + value + ")");
                    }
                    if (name.equals("server_version")) {
                        protoConnection.setServerVersion(value);
                        continue block12;
                    }
                    if (name.equals("client_encoding")) {
                        if (!value.equals("UTF8") && !value.equals("GBK")) {
                            throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
                        }
                        pgStream.setEncoding(Encoding.getDatabaseEncoding(value));
                        continue block12;
                    }
                    if (!name.equals("standard_conforming_strings")) continue block12;
                    if (value.equals("on")) {
                        protoConnection.setStandardConformingStrings(true);
                        continue block12;
                    }
                    if (value.equals("off")) {
                        protoConnection.setStandardConformingStrings(false);
                        continue block12;
                    }
                    throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
                }
            }
            break;
        }
        if (logger.logDebug()) {
            logger.debug("invalid message type=" + (char)beresp);
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.PROTOCOL_VIOLATION);
    }

    private void runInitialQueries(ProtocolConnection protoConnection, Properties info, Logger logger) throws SQLException {
        String appName;
        String dbVersion = protoConnection.getServerVersion();
        if (dbVersion.compareTo("9.0") >= 0) {
            String setSql = "SET extra_float_digits = 3;set client_encoding = '" + CLIENT_ENCODING + "';";
            SetupQueryRunner.run(protoConnection, setSql, false);
        }
        if ((appName = info.getProperty("ApplicationName")) != null && dbVersion.compareTo("9.0") >= 0) {
            StringBuffer sql = new StringBuffer();
            sql.append("SET application_name = '");
            Utils.appendEscapedLiteral(sql, appName, protoConnection.getStandardConformingStrings());
            sql.append("'");
            SetupQueryRunner.run(protoConnection, sql.toString(), false);
        }
    }

    private boolean isMaster(ProtocolConnectionImpl protoConnection) throws SQLException, IOException {
        byte[][] results = SetupQueryRunner.run(protoConnection, "show transaction_read_only", true);
        String value = protoConnection.getEncoding().decode(results[0]);
        return value.equalsIgnoreCase("off");
    }

    private static class UnsupportedProtocolException
    extends IOException {
        private UnsupportedProtocolException() {
        }
    }
}

