/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.jdbc4;

import java.io.IOException;
import java.io.InputStream;

public class GaussDBBufferedStream
extends InputStream {
    private byte[] data;

    public GaussDBBufferedStream(byte[] data) {
        this.data = data;
    }

    @Override
    public int read() throws IOException {
        return 0;
    }

    @Override
    public int read(byte[] abyte0) throws IOException {
        return this.data == null ? 0 : this.read(abyte0, 1, this.data.length - 1);
    }

    @Override
    public int read(byte[] abyte0, int i, int len) throws IOException {
        if (abyte0 == null) {
            throw new NullPointerException();
        }
        if (i < 0 || len < 0 || len > this.data.length - i) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        if (len + i > this.data.length) {
            System.arraycopy(this.data, i, abyte0, 0, this.data.length - i);
            return this.data.length - i;
        }
        System.arraycopy(this.data, i, abyte0, 0, len);
        return len;
    }

    public long getLength() {
        if (this.data == null) {
            return 0L;
        }
        return this.data.length;
    }
}

