/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.framework.AppProperties;
import com.huawei.wcc.framework.log.AppLogger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Auditor {
    private static final String PROP_AUDIT_LOG_ENABLED = "crypt_audit_log_enabled";
    private static final boolean AUDIT_LOG_ENABLED_DEFAULT = true;
    private static boolean auditLogEnabled = AppProperties.getAsBoolean((String)"crypt_audit_log_enabled", (boolean)true);
    private static AppLogger logger = null;
    private static final String LOG_TEMPLATE = "[User: WHO] [Time: WHEN] [WHAT] [Result: RESULT]";

    public static void log(String what, boolean success) {
        Auditor.log(what, success, "");
    }

    public static void log(String what, boolean success, Throwable throwable) {
        if (!auditLogEnabled || logger == null) {
            return;
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             PrintStream printStream = new PrintStream((OutputStream)baos, false, "UTF-8");){
            throwable.printStackTrace(printStream);
            String moreInfo = baos.toString("UTF-8");
            Auditor.log(what, success, moreInfo);
        }
        catch (UnsupportedEncodingException e) {
            Auditor.log(what, success);
        }
        catch (IOException e) {
            Auditor.log(what, success);
        }
    }

    public static void log(String what, boolean success, String moreInfo) {
        if (!auditLogEnabled || logger == null) {
            return;
        }
        String who = System.getProperty("user.name");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        String when = df.format(new Date());
        String log = LOG_TEMPLATE;
        log = log.replace("WHO", who);
        log = log.replace("WHEN", when);
        log = log.replace("WHAT", what);
        String result = success ? "Success" : "Fail";
        log = log.replace("RESULT", result);
        if (moreInfo != null && !moreInfo.isEmpty()) {
            log = log + " [" + moreInfo + "]";
        }
        logger.info((Object)log);
    }

    static {
        if (auditLogEnabled) {
            try {
                logger = AppLogger.getInstance(Auditor.class);
            }
            catch (Throwable t) {
                auditLogEnabled = false;
                logger = null;
            }
        }
    }
}

