/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.crypt.CrypterFactory;
import com.huawei.wcc.crypt.Formatter;
import com.huawei.wcc.crypt.FormatterV0;
import com.huawei.wcc.crypt.FormatterV1;
import com.huawei.wcc.framework.AppRuntimeException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class Crypter {
    protected static final int PARAM_INDEX_ALGORITHM = 0;
    protected static final int PARAM_INDEX_ENCRYPTED = 1;
    protected static final int PARAM_INDEX_ROOTKEY_TIMESTAMP = 2;
    protected static final int PARAM_INDEX_KEYGEN_ITERATION_COUNT = 3;
    protected static final int ALGO_PARAM_START = 4;
    private static ThreadLocal<Map<Integer, byte[]>> crypterParam = new ThreadLocal<Map<Integer, byte[]>>(){

        @Override
        public Map<Integer, byte[]> initialValue() {
            return new HashMap<Integer, byte[]>();
        }
    };

    public static final char[] decryptChars(char[] cipher) {
        String algorithm = Crypter.getAlgorithmFromCipher(cipher);
        Crypter crypt = CrypterFactory.getCrypter(algorithm);
        return crypt.decrypt(cipher);
    }

    public static boolean erase(char[] data) {
        if (data == null) {
            return true;
        }
        int size = data.length;
        for (int i = 0; i < size; ++i) {
            data[i] = '\u0000';
        }
        return true;
    }

    protected static List<byte[]> getParam() {
        return new LinkedList<byte[]>(crypterParam.get().values());
    }

    protected static void setParam(List<byte[]> param) {
        if (param == null || param.isEmpty()) {
            throw new AppRuntimeException("null == param or empty");
        }
        HashMap<Integer, byte[]> paramMap = new HashMap<Integer, byte[]>();
        int size = param.size();
        for (int i = 0; i < size; ++i) {
            paramMap.put(i, param.get(i));
        }
        crypterParam.set(paramMap);
    }

    protected static byte[] getParam(int index) {
        return crypterParam.get().get(index);
    }

    protected static void setParam(int index, byte[] param) {
        crypterParam.get().put(index, param);
    }

    protected static void clearParam() {
        crypterParam.remove();
    }

    protected static List<byte[]> getParamsFromCipher(String cipher) {
        FormatterV1 formatter = new FormatterV1();
        List<byte[]> params = ((Formatter)formatter).parse(cipher);
        if (params != null) {
            return params;
        }
        FormatterV0 formatterV0 = new FormatterV0();
        formatterV0.setEncByRootKey(false);
        params = ((Formatter)formatterV0).parse(cipher);
        if (params != null) {
            return params;
        }
        throw new AppRuntimeException("Invalid content");
    }

    private static String getAlgorithmFromCipher(char[] cipher) {
        if (cipher == null) {
            throw new AppRuntimeException("Wrong Param: cipher == null");
        }
        String cipherString = String.valueOf(cipher);
        List<byte[]> params = Crypter.getParamsFromCipher(cipherString);
        return new String(params.get(0), StandardCharsets.UTF_8);
    }

    public char[] decrypt(char[] cipherText) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }

    public abstract char[] decrypt(char[] var1, char[] var2) throws AppRuntimeException;

    public char[] encryptByRootKey(char[] content) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }

    public char[] decryptByRootKey(char[] content) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }

    public String decrypt(String content, String password) throws AppRuntimeException {
        if (content == null || password == null) {
            throw new AppRuntimeException("Param should not be null");
        }
        return String.valueOf(this.decrypt(content.toCharArray(), password.toCharArray()));
    }

    protected char[] encryptByRootKey(char[] content, Key rootKey) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }

    protected char[] decryptByRootKey(char[] content, Key rootKey) throws AppRuntimeException {
        throw new AppRuntimeException("Not Implemented");
    }
}

