/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.wcc.crypt.Crypter;
import com.huawei.wcc.crypt.EncryptHelper;
import com.huawei.wcc.crypt.KeyGen;
import com.huawei.wcc.crypt.KeyManager;
import com.huawei.wcc.crypt.RootKey;
import com.huawei.wcc.crypt.WorkKey;
import com.huawei.wcc.framework.AppProperties;
import com.huawei.wcc.framework.AppRuntimeException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.List;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class CrypterAesCBC
extends Crypter {
    protected static final int PARAM_INDEX_IV = 4;
    protected static final int PARAM_INDEX_SALT = 5;
    protected static final int PARAM_INDEX_ID = 6;
    private static final String PROP_IV_LENGTH = "crypt_aes_cbc_iv_length";
    private static final int DEFAULT_IV_LENGTH = 16;
    private static final int IV_LENGTH_MIN = 1;
    private static final String PROP_KEY_LENGTH = "crypt_aes_cbc_key_length";
    private static final String PROP_KEY_LENGTH_OLD = "crypt_keygen_key_length";
    private static final int KEY_LENGTH_128 = 128;
    private static final int KEY_LENGTH_192 = 192;
    private static final int KEY_LENGTH_256 = 256;
    private static final int DEFAULT_KEY_LENGTH = 256;
    private static final String ALGORITHM = "AES/CBC/PKCS5Padding";

    CrypterAesCBC() {
    }

    @Override
    public char[] decrypt(char[] content, char[] password) throws AppRuntimeException {
        if (content == null || password == null) {
            throw new AppRuntimeException("content and password should not be null");
        }
        byte[] iv = CrypterAesCBC.getParam(4);
        byte[] salt = CrypterAesCBC.getParam(5);
        int iterationCount = Integer.parseInt(new String(CrypterAesCBC.getParam(3), StandardCharsets.UTF_8));
        SecretKeySpec key = new SecretKeySpec(KeyGen.genKey(password, salt, this.getKeyLength(), iterationCount).getEncoded(), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        byte[] contentBytes = EncryptHelper.parseHexStr2Byte(String.valueOf(content));
        byte[] result = this.doDecrypt(contentBytes, key, ivSpec);
        return EncryptHelper.getCharsByUTF8(result);
    }

    @Override
    public char[] encryptByRootKey(char[] content) throws AppRuntimeException {
        return this.encryptByRootKey(content, new RootKey(this.getKeyLength(), KeyGen.getIterationCount()).getKey());
    }

    @Override
    public char[] decryptByRootKey(char[] content) throws AppRuntimeException {
        int iterationCount = Integer.parseInt(new String(CrypterAesCBC.getParam(3), StandardCharsets.UTF_8));
        return this.decryptByRootKey(content, new RootKey(this.getKeyLength(), iterationCount).getKey());
    }

    @Override
    public char[] decrypt(char[] cipherText) throws AppRuntimeException {
        char[] cArray;
        if (cipherText == null) {
            throw new AppRuntimeException("cipherText should not be null");
        }
        byte[] idBytes = CrypterAesCBC.getParam(6);
        char[] plainKey = null;
        try {
            String id = new String(idBytes, StandardCharsets.UTF_8);
            List<byte[]> tmp = CrypterAesCBC.getParam();
            CrypterAesCBC.clearParam();
            WorkKey key = KeyManager.getInstance().getKey(id);
            plainKey = key.getPlainKey();
            CrypterAesCBC.setParam(tmp);
            cArray = this.decrypt(cipherText, plainKey);
        }
        catch (Exception e) {
            try {
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                CrypterAesCBC.erase(plainKey);
                throw throwable;
            }
        }
        CrypterAesCBC.erase(plainKey);
        return cArray;
    }

    @Override
    protected char[] encryptByRootKey(char[] content, Key rootKey) throws AppRuntimeException {
        if (content == null) {
            throw new AppRuntimeException("content should not be null");
        }
        byte[] iv = this.genIV();
        CrypterAesCBC.setParam(4, iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        SecretKeySpec aesRootKey = new SecretKeySpec(rootKey.getEncoded(), "AES");
        byte[] ecypted = this.doEncrypt(EncryptHelper.getBytesByUTF8(content), aesRootKey, ivSpec);
        return EncryptHelper.parseByte2HexStr(ecypted).toCharArray();
    }

    @Override
    protected char[] decryptByRootKey(char[] content, Key rootKey) throws AppRuntimeException {
        if (content == null) {
            throw new AppRuntimeException("content should not be null");
        }
        int ivLen = AppProperties.getAsInt((String)PROP_IV_LENGTH, (int)16);
        if (ivLen < 1) {
            throw new AppRuntimeException("Config Error. IV_LENGTH > 1");
        }
        byte[] iv = CrypterAesCBC.getParam(4);
        byte[] ecyptContent = EncryptHelper.parseHexStr2Byte(String.valueOf(content));
        SecretKeySpec aesRootKey = new SecretKeySpec(rootKey.getEncoded(), "AES");
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        return EncryptHelper.getCharsByUTF8(this.doDecrypt(ecyptContent, aesRootKey, ivSpec));
    }

    private byte[] doEncrypt(byte[] content, Key key, IvParameterSpec iv) throws AppRuntimeException {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(1, key, iv);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    private byte[] doDecrypt(byte[] content, Key key, IvParameterSpec iv) throws AppRuntimeException {
        try {
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            cipher.init(2, key, iv);
            return cipher.doFinal(content);
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    private byte[] genIV() throws AppRuntimeException {
        try {
            int length = AppProperties.getAsInt((String)PROP_IV_LENGTH, (int)16);
            if (length < 1) {
                throw new AppRuntimeException("Config Error. IV_LENGTH > 1");
            }
            byte[] iv = new byte[length];
            SecureRandom rand = SecureRandomFactory.getInstanceStrongWithDRBG();
            rand.nextBytes(iv);
            return iv;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    private int getKeyLength() {
        int keyLength;
        String key = AppProperties.get((String)PROP_KEY_LENGTH);
        if (key == null && (key = AppProperties.get((String)PROP_KEY_LENGTH_OLD)) == null) {
            return 256;
        }
        try {
            keyLength = Integer.parseInt(key);
        }
        catch (NumberFormatException ex) {
            throw new AppRuntimeException("NumberFormatException. Please check config: crypt_aes_cbc_key_length");
        }
        if (keyLength != 128 && keyLength != 192 && keyLength != 256) {
            throw new AppRuntimeException("Config Error. Key Length should be 128, 192 or 256");
        }
        return keyLength;
    }
}

