/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.crypt.Crypter;
import com.huawei.wcc.crypt.EncryptHelper;
import com.huawei.wcc.crypt.Formatter;
import com.huawei.wcc.crypt.FormatterV0;
import com.huawei.wcc.crypt.KeyGen;
import com.huawei.wcc.crypt.ProcessLocker;
import com.huawei.wcc.crypt.RootKey;
import com.huawei.wcc.crypt.RootKeyComponent;
import com.huawei.wcc.crypt.RootKeyUpdater;
import com.huawei.wcc.framework.AppProperties;
import com.huawei.wcc.framework.AppRuntimeException;
import java.util.List;

class CrypterProxy
extends Crypter {
    private String algorithm = null;
    private Crypter crypter = null;
    private RootKeyUpdater updater = null;
    private Formatter formatter = null;

    protected CrypterProxy(String algorithm, Crypter crypter, RootKeyUpdater updater, Formatter formatter) {
        this.algorithm = algorithm;
        this.crypter = crypter;
        this.updater = updater;
        this.formatter = formatter;
    }

    @Override
    public char[] decrypt(char[] content, char[] password) throws AppRuntimeException {
        try {
            List<byte[]> params = this.formatter.parse(String.valueOf(content));
            if (params == null) {
                FormatterV0 formatterV0 = new FormatterV0();
                formatterV0.setEncByRootKey(false);
                params = ((Formatter)formatterV0).parse(String.valueOf(content));
                if (params == null) {
                    throw new AppRuntimeException("Invalid content");
                }
            }
            CrypterProxy.setParam(params);
            byte[] encrypted = params.get(1);
            char[] cArray = this.crypter.decrypt(EncryptHelper.getCharsByUTF8(encrypted), password);
            return cArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            CrypterProxy.clearParam();
        }
    }

    @Override
    public char[] encryptByRootKey(char[] content) throws AppRuntimeException {
        try {
            if (this.updater.needUpdate()) {
                this.updateRootKey();
            }
            char[] result = this.crypter.encryptByRootKey(content);
            List<byte[]> param = CrypterProxy.getParam();
            param.add(0, this.algorithm.getBytes("UTF-8"));
            param.add(1, EncryptHelper.getBytesByUTF8(result));
            param.add(2, String.valueOf(RootKeyComponent.currentTimeStamp()).getBytes("UTF-8"));
            param.add(3, String.valueOf(KeyGen.getIterationCount()).getBytes("UTF-8"));
            char[] cArray = this.formatter.format(param).toCharArray();
            return cArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            CrypterProxy.clearParam();
        }
    }

    @Override
    public char[] decryptByRootKey(char[] content) throws AppRuntimeException {
        boolean isFormatV0 = false;
        try {
            RootKey rootKey;
            List<byte[]> params = this.formatter.parse(String.valueOf(content));
            if (params == null) {
                FormatterV0 formatterV0 = new FormatterV0();
                formatterV0.setEncByRootKey(true);
                params = ((Formatter)formatterV0).parse(String.valueOf(content));
                if (params == null) {
                    throw new AppRuntimeException("Invalid content");
                }
                isFormatV0 = true;
            }
            CrypterProxy.setParam(params);
            byte[] encryptedBytes = params.get(1);
            long timeStamp = Long.parseLong(new String(CrypterProxy.getParam(2), "UTF-8"));
            int count = Integer.parseInt(new String(params.get(3), "UTF-8"));
            int keyLength = AppProperties.getAsInt((String)"crypt_aes_cbc_key_length", (int)256);
            RootKeyComponent[] current = RootKeyComponent.getKeyComps();
            if (timeStamp == current[0].getTimeStamp() || isFormatV0) {
                rootKey = new RootKey(current, keyLength, count);
            } else if (timeStamp == Long.MAX_VALUE) {
                rootKey = new RootKey(RootKeyComponent.getDefaultKeyComps(), keyLength, count);
            } else {
                RootKeyComponent[] rkcs = this.updater.getOldRKCS(timeStamp);
                if (rkcs == null) {
                    rkcs = current;
                }
                rootKey = new RootKey(rkcs, keyLength, count);
            }
            char[] result = this.crypter.decryptByRootKey(EncryptHelper.getCharsByUTF8(encryptedBytes), rootKey.getKey());
            if (this.updater.needUpdate()) {
                this.updateRootKey();
            }
            char[] cArray = result;
            return cArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            CrypterProxy.clearParam();
        }
    }

    @Override
    public char[] decrypt(char[] cipherText) throws AppRuntimeException {
        try {
            List<byte[]> params = this.formatter.parse(String.valueOf(cipherText));
            if (params == null) {
                throw new AppRuntimeException("invalid cipherText");
            }
            CrypterProxy.setParam(params);
            byte[] encrypted = params.get(1);
            char[] cArray = this.crypter.decrypt(EncryptHelper.getCharsByUTF8(encrypted));
            return cArray;
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        finally {
            CrypterProxy.clearParam();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRootKey() {
        Class<RootKeyUpdater> clazz = RootKeyUpdater.class;
        synchronized (RootKeyUpdater.class) {
            if (!this.updater.needUpdate()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            ProcessLocker locker = null;
            try {
                locker = ProcessLocker.getInstance("update_lock").getWriteLock();
                locker.lock();
                if (this.updater.needUpdate()) {
                    this.updater.doUpdate();
                }
            }
            catch (Throwable throwable) {
                ProcessLocker.unlock(locker);
                throw throwable;
            }
            ProcessLocker.unlock(locker);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

