/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.crypt.KeyUpdateHandler;
import com.huawei.wcc.framework.AppProperties;
import com.huawei.wcc.framework.AppRuntimeException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class Domain
implements Serializable {
    public static final String DEFAULT_DOMAIN = "WCC_CRYPT_DEFAULT_DOMAIN";
    private static final long serialVersionUID = 6580841607387617176L;
    private static final int MS_OF_SECOND = 1000;
    private static final int MS_OF_DAY = 86400000;
    private static Map<String, Domain> cache = new HashMap<String, Domain>();
    private String name;
    private long lifeTime;
    private transient KeyUpdateHandler updateHandler = null;

    private Domain(String name) {
        this.name = name;
        this.lifeTime = this.getLifeTime(name);
        this.updateHandler = this.getUpdateHandler(name);
    }

    public static synchronized Domain getByName(String name) {
        Domain domain = cache.get(name);
        if (domain != null) {
            return domain;
        }
        domain = new Domain(name);
        cache.put(name, domain);
        return domain;
    }

    public static synchronized void clearCache() {
        cache.clear();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getLifeTime() {
        return this.lifeTime;
    }

    public void setLifeTime(long lifeTime) {
        this.lifeTime = lifeTime;
    }

    public KeyUpdateHandler getUpdateHandler() {
        return this.updateHandler;
    }

    public void setUpdateHandler(KeyUpdateHandler updateHandler) {
        this.updateHandler = updateHandler;
    }

    private long getLifeTime(String domainName) {
        String lifeSecondsKey = "crypt_key_lifetime_seconds";
        String lifeDaysKey = "crypt_key_lifetime_days";
        String domainLifeSenondsKey = lifeSecondsKey + "_" + domainName;
        String domainLifeDaysKey = lifeDaysKey + "_" + domainName;
        String life = AppProperties.get((String)domainLifeSenondsKey);
        if (life != null && !life.isEmpty()) {
            return Long.parseLong(life) * 1000L;
        }
        life = AppProperties.get((String)domainLifeDaysKey);
        if (life != null && !life.isEmpty()) {
            return Long.parseLong(life) * 86400000L;
        }
        life = AppProperties.get((String)lifeSecondsKey);
        if (life != null && !life.isEmpty()) {
            return Long.parseLong(life) * 1000L;
        }
        life = AppProperties.get((String)lifeDaysKey);
        if (life != null && !life.isEmpty()) {
            return Long.parseLong(life) * 86400000L;
        }
        return Long.MAX_VALUE;
    }

    private KeyUpdateHandler getUpdateHandler(String domainName) {
        String handlerKey = "crypt_key_update_handler";
        String domainHandlerKey = handlerKey + "_" + domainName;
        String handler = AppProperties.get((String)domainHandlerKey);
        if ((handler == null || handler.isEmpty()) && ((handler = AppProperties.get((String)handlerKey)) == null || handler.isEmpty())) {
            return null;
        }
        try {
            Class<?> handlerClass = Class.forName(handler);
            return (KeyUpdateHandler)handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new AppRuntimeException("Key Update Handler " + handler + " Not Found", (Throwable)e);
        }
    }
}

