/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.crypt.EncryptHelper;
import com.huawei.wcc.crypt.Formatter;
import com.huawei.wcc.framework.AppProperties;
import com.huawei.wcc.framework.AppRuntimeException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

class FormatterV0
extends Formatter {
    public static final String PROP_IV_LENGTH = "crypt_aes_cbc_iv_length";
    public static final String PROP_SALT_LENGTH = "crypt_aes_cbc_salt_length";
    private static final int DEFAULT_IV_LENGTH = 16;
    private static final int IV_LENGTH_MIN = 1;
    private static final int DEFAULT_SALT_LENGTH = 8;
    private static final int SALT_LENGTH_MIN = 8;
    private boolean encByRootKey = false;

    FormatterV0() {
    }

    @Override
    public List<byte[]> parse(String formatted) {
        byte[] ecyptContent;
        if (formatted == null || formatted.length() == 0) {
            return null;
        }
        int ivLen = AppProperties.getAsInt((String)PROP_IV_LENGTH, (int)16);
        if (ivLen < 1) {
            throw new AppRuntimeException("Config Error. IV_LENGTH > 1");
        }
        int saltLen = AppProperties.getAsInt((String)PROP_SALT_LENGTH, (int)8);
        if (saltLen < 8) {
            throw new AppRuntimeException("Config Error. SALT_LENGTH > 8");
        }
        byte[] decoded = Base64.decodeBase64((String)formatted);
        byte[] iv = Arrays.copyOfRange(decoded, 0, ivLen);
        byte[] salt = null;
        if (this.encByRootKey) {
            ecyptContent = Arrays.copyOfRange(decoded, ivLen, decoded.length);
        } else {
            salt = Arrays.copyOfRange(decoded, ivLen, ivLen + saltLen);
            ecyptContent = Arrays.copyOfRange(decoded, ivLen + saltLen, decoded.length);
        }
        LinkedList<byte[]> result = new LinkedList<byte[]>();
        result.add("AES_CBC".getBytes(StandardCharsets.UTF_8));
        result.add(EncryptHelper.parseByte2HexStr(ecyptContent).getBytes(StandardCharsets.UTF_8));
        result.add(String.valueOf(Long.MAX_VALUE).getBytes(StandardCharsets.UTF_8));
        result.add(String.valueOf(50000).getBytes(StandardCharsets.UTF_8));
        result.add(iv);
        result.add(salt);
        return result;
    }

    public void setEncByRootKey(boolean encByRootKey) {
        this.encByRootKey = encByRootKey;
    }
}

