/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.crypt.EncryptHelper;
import com.huawei.wcc.crypt.Formatter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

class FormatterV1
extends Formatter {
    private static final String MAGIC = "wcc_crypt";
    private static final byte FORMAT_VERSION = 1;
    private static final int CONTENT_START_INDEX = "wcc_crypt".length() + 1;
    private static final String SEPARATOR = ";";

    FormatterV1() {
    }

    @Override
    public String format(List<byte[]> values) {
        if (values == null || values.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        buf.append(this.buildTag());
        for (byte[] value : values) {
            if (value != null) {
                String s = EncryptHelper.parseByte2HexStr(value);
                buf.append(s);
            }
            buf.append(SEPARATOR);
        }
        return new String(Base64.encodeBase64((byte[])buf.toString().getBytes(StandardCharsets.UTF_8), (boolean)false, (boolean)true), StandardCharsets.UTF_8);
    }

    @Override
    public List<byte[]> parse(String formatted) {
        if (formatted == null || formatted.length() == 0) {
            return null;
        }
        String decoded = new String(Base64.decodeBase64((String)formatted), StandardCharsets.UTF_8);
        if (!this.isValid(decoded)) {
            return null;
        }
        String content = decoded.substring(CONTENT_START_INDEX);
        String[] values = content.split(SEPARATOR);
        LinkedList<byte[]> result = new LinkedList<byte[]>();
        for (String v : values) {
            if (v == null || v.isEmpty()) {
                result.add(null);
                continue;
            }
            result.add(EncryptHelper.parseHexStr2Byte(v));
        }
        return result;
    }

    private String buildTag() {
        return "wcc_crypt\u0001";
    }

    private boolean isValid(String decoded) {
        if (decoded == null || decoded.length() <= MAGIC.length()) {
            return false;
        }
        return decoded.substring(0, MAGIC.length()).equals(MAGIC);
    }
}

