/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.framework.AppProperties;
import com.huawei.wcc.framework.AppRuntimeException;
import java.security.Key;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;

class KeyGen {
    public static final String PROP_ITERATION_COUNT = "crypt_keygen_iteration_count";
    protected static final int MIN_ITERATION_COUNT = 50000;
    protected static final int DEFAULT_ITERATION_COUNT = 50000;

    KeyGen() {
    }

    public static Key genKey(char[] password, byte[] salt, int keyLength, int iterationCount) throws AppRuntimeException {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            PBEKeySpec keyspec = new PBEKeySpec(password, salt, iterationCount, keyLength);
            return factory.generateSecret(keyspec);
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    public static int getIterationCount() {
        int iterationCount = AppProperties.getAsInt((String)PROP_ITERATION_COUNT, (int)50000);
        if (iterationCount < 50000 || iterationCount > Integer.MAX_VALUE) {
            throw new AppRuntimeException("The number of iterations does not meet the condition");
        }
        return iterationCount;
    }
}

