/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.crypt.EncryptHelper;
import com.huawei.wcc.crypt.KeyStore;
import com.huawei.wcc.crypt.ProcessLocker;
import com.huawei.wcc.crypt.Util;
import com.huawei.wcc.crypt.WorkKey;
import com.huawei.wcc.framework.AppRuntimeException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public final class KeyManager {
    private static volatile KeyManager instance = null;
    private static ProcessLocker processWriteLock = null;
    private static Lock threadWriteLock = null;

    private KeyManager() {
        KeyManager.initLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyManager getInstance() {
        if (instance != null) return instance;
        Class<KeyManager> clazz = KeyManager.class;
        synchronized (KeyManager.class) {
            if (instance != null) return instance;
            instance = new KeyManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private static void initLock() {
        processWriteLock = ProcessLocker.getInstance(Util.getSecureHash("KeyManager")).getWriteLock();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        threadWriteLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkKey getKey(String id) throws AppRuntimeException {
        KeyStore keyStore = KeyStore.getInstance();
        WorkKey key = keyStore.load(id);
        if (key == null) {
            keyStore.reload();
            key = keyStore.load(id);
            if (key == null) {
                throw new AppRuntimeException("Invalid Key: no key. (id = " + id + ")");
            }
        }
        if (this.needUpdate(key)) {
            block5: {
                try {
                    threadWriteLock.lock();
                    processWriteLock.lock();
                    keyStore.reload();
                    WorkKey newKey = keyStore.load(id);
                    if (!this.needUpdate(newKey)) break block5;
                    newKey.update();
                }
                catch (Throwable throwable) {
                    EncryptHelper.unlock(threadWriteLock, processWriteLock);
                    throw throwable;
                }
            }
            EncryptHelper.unlock(threadWriteLock, processWriteLock);
        }
        return key;
    }

    private boolean needUpdate(WorkKey key) {
        if (key == null || !key.isActive()) {
            return false;
        }
        long lifeTime = key.getDomain().getLifeTime();
        long createTime = key.getCreateTime();
        long currentTime = System.currentTimeMillis();
        return currentTime - createTime > lifeTime;
    }
}

