/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.crypt.Domain;
import com.huawei.wcc.crypt.EncryptHelper;
import com.huawei.wcc.crypt.ProcessLocker;
import com.huawei.wcc.crypt.Util;
import com.huawei.wcc.crypt.WorkKey;
import com.huawei.wcc.framework.AppProperties;
import com.huawei.wcc.framework.AppRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class KeyStore {
    public static final String PROP_KEYSTORE_LOAD_TIMEOUT = "crypt_keystore_load_timeout";
    private static final int DEFAULT_KEYSTORE_LOAD_TIMEOUT = 10000;
    private static volatile KeyStore instance = null;
    private String keystorePath;
    private Document xmlDocOfKeystore;
    private Lock threadReadLock;
    private Lock threadWriteLock;
    private ProcessLocker processWriteLock = null;
    private ProcessLocker processReadLock = null;

    private KeyStore() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KeyStore getInstance() {
        if (instance != null) return instance;
        Class<KeyStore> clazz = KeyStore.class;
        synchronized (KeyStore.class) {
            if (instance != null) return instance;
            instance = new KeyStore();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkKey load(String domain, int type) throws AppRuntimeException {
        Node valueNode;
        block7: {
            Node keyNode;
            block6: {
                Node domainNode;
                block5: {
                    WorkKey workKey;
                    try {
                        this.threadReadLock.lock();
                        domainNode = this.getDomainNode(domain);
                        if (domainNode != null) break block5;
                        workKey = null;
                    }
                    catch (Throwable throwable) {
                        EncryptHelper.threadUnlock(this.threadReadLock);
                        throw throwable;
                    }
                    EncryptHelper.threadUnlock(this.threadReadLock);
                    return workKey;
                }
                keyNode = this.getKeyNode(domainNode, String.valueOf(type));
                if (keyNode != null) break block6;
                WorkKey workKey = null;
                EncryptHelper.threadUnlock(this.threadReadLock);
                return workKey;
            }
            valueNode = this.getActiveValueNode(keyNode);
            if (valueNode != null) break block7;
            WorkKey workKey = null;
            EncryptHelper.threadUnlock(this.threadReadLock);
            return workKey;
        }
        String id = Util.getNodeAttr(valueNode, "id");
        long createTime = Long.parseLong(Util.getNodeAttr(valueNode, "createTime"));
        String cipherKey = Util.getNodeValue(valueNode);
        WorkKey workKey = new WorkKey(id, domain, type, createTime, true, cipherKey.toCharArray());
        EncryptHelper.threadUnlock(this.threadReadLock);
        return workKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkKey load(String id) throws AppRuntimeException {
        Node domainNode;
        Node keyNode;
        Node valueNode;
        block7: {
            block6: {
                block5: {
                    WorkKey workKey;
                    try {
                        this.threadReadLock.lock();
                        valueNode = this.getValueNodeById(id);
                        if (valueNode != null) break block5;
                        workKey = null;
                    }
                    catch (Throwable throwable) {
                        EncryptHelper.threadUnlock(this.threadReadLock);
                        throw throwable;
                    }
                    EncryptHelper.threadUnlock(this.threadReadLock);
                    return workKey;
                }
                keyNode = valueNode.getParentNode();
                if (keyNode != null) break block6;
                WorkKey workKey = null;
                EncryptHelper.threadUnlock(this.threadReadLock);
                return workKey;
            }
            domainNode = keyNode.getParentNode();
            if (domainNode != null) break block7;
            WorkKey workKey = null;
            EncryptHelper.threadUnlock(this.threadReadLock);
            return workKey;
        }
        String domain = Util.getNodeAttr(domainNode, "name");
        int type = Integer.parseInt(Util.getNodeAttr(keyNode, "type"));
        long createTime = Long.parseLong(Util.getNodeAttr(valueNode, "createTime"));
        boolean isActive = Boolean.valueOf(Util.getNodeAttr(valueNode, "active"));
        String cipherKey = Util.getNodeValue(valueNode);
        WorkKey workKey = new WorkKey(id, domain, type, createTime, isActive, cipherKey.toCharArray());
        EncryptHelper.threadUnlock(this.threadReadLock);
        return workKey;
    }

    public List<WorkKey> loadAll() {
        return this.loadKeysByStatus(KeyStatus.ALL_STATUS);
    }

    public List<WorkKey> loadAllActive() {
        return this.loadKeysByStatus(KeyStatus.ACTIVE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WorkKey> loadAll(String domain) throws AppRuntimeException {
        LinkedList<WorkKey> linkedList;
        Node domainNode;
        block6: {
            if (domain == null || domain.isEmpty()) {
                throw new AppRuntimeException("param error: null or empty");
            }
            this.threadReadLock.lock();
            domainNode = this.getDomainNode(domain);
            if (domainNode != null) break block6;
            List<WorkKey> list = Collections.emptyList();
            EncryptHelper.threadUnlock(this.threadReadLock);
            return list;
        }
        try {
            LinkedList<WorkKey> keyList = new LinkedList<WorkKey>();
            for (int i = 0; i < 2; ++i) {
                List<Node> valueNodes;
                Node keyNode = this.getKeyNode(domainNode, String.valueOf(i));
                if (keyNode == null || (valueNodes = this.getValueNodes(keyNode)).isEmpty()) continue;
                for (Node valueNode : valueNodes) {
                    String id = Util.getNodeAttr(valueNode, "id");
                    long createTime = Long.parseLong(Util.getNodeAttr(valueNode, "createTime"));
                    boolean active = Boolean.valueOf(Util.getNodeAttr(valueNode, "active"));
                    String nodeValue = Util.getNodeValue(valueNode);
                    WorkKey key = new WorkKey(id, domain, i, createTime, active, nodeValue.toCharArray());
                    keyList.add(key);
                }
            }
            linkedList = keyList;
        }
        catch (Throwable throwable) {
            EncryptHelper.threadUnlock(this.threadReadLock);
            throw throwable;
        }
        EncryptHelper.threadUnlock(this.threadReadLock);
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save(WorkKey key) throws AppRuntimeException {
        boolean bl;
        try {
            Node keyNode;
            String id = key.getId();
            if (id == null) {
                throw new AppRuntimeException("key id is null");
            }
            String domain = key.getDomain().getName();
            String type = String.valueOf(key.getType());
            String createTime = String.valueOf(key.getCreateTime());
            String cipherValue = String.valueOf(key.getValue());
            this.threadWriteLock.lock();
            Node domainNode = this.getDomainNode(domain);
            if (domainNode == null) {
                domainNode = this.addDomainNode(domain);
                keyNode = this.addKeyNode(domainNode, type);
            } else {
                keyNode = this.getKeyNode(domainNode, type);
                if (keyNode == null) {
                    keyNode = this.addKeyNode(domainNode, type);
                }
            }
            this.setActive(key, keyNode);
            String active = String.valueOf(key.isActive());
            Node valueNode = this.getValueNodeById(id);
            if (valueNode == null) {
                this.addValueNode(keyNode, id, createTime, active, cipherValue);
            } else {
                this.updateValueNode(valueNode, active, cipherValue);
            }
            this.processWriteLock.lock();
            bl = Util.storeToXml((Node)this.xmlDocOfKeystore, this.keystorePath);
        }
        catch (Throwable throwable) {
            EncryptHelper.unlock(this.threadWriteLock, this.processWriteLock);
            throw throwable;
        }
        EncryptHelper.unlock(this.threadWriteLock, this.processWriteLock);
        return bl;
    }

    private void setActive(WorkKey key, Node keyNode) {
        Node activeValueNode;
        if (key.isActive() && (activeValueNode = this.getActiveValueNode(keyNode)) != null) {
            long activeCreateTime = Long.parseLong(Util.getNodeAttr(activeValueNode, "createTime"));
            if (key.getCreateTime() < activeCreateTime) {
                key.setActive(false);
            } else {
                ((Element)activeValueNode).setAttribute("active", "false");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reload() {
        String currentKeyStorePath = AppProperties.get((String)"crypt_keystore");
        if (currentKeyStorePath == null) throw new AppRuntimeException("Error: crypt_keystore is empty or not config");
        if (currentKeyStorePath.isEmpty()) {
            throw new AppRuntimeException("Error: crypt_keystore is empty or not config");
        }
        if (!Util.toAbsolutePath(currentKeyStorePath).equals(this.keystorePath)) {
            this.init();
            Domain.clearCache();
            return;
        }
        try {
            this.threadWriteLock.lock();
            this.processWriteLock.lock();
            this.xmlDocOfKeystore = Util.loadFromXML(this.keystorePath);
        }
        catch (Throwable throwable) {
            EncryptHelper.unlock(this.threadWriteLock, this.processWriteLock);
            throw throwable;
        }
        EncryptHelper.unlock(this.threadWriteLock, this.processWriteLock);
    }

    public void clear() throws AppRuntimeException {
        try {
            this.threadWriteLock.lock();
            this.processWriteLock.lock();
            Util.deleteFile(this.keystorePath);
            File file = new File(this.keystorePath);
            if (!file.createNewFile()) {
                throw new AppRuntimeException("failed to create keystore file");
            }
            this.xmlDocOfKeystore = this.initEmptyKeyStore();
        }
        catch (IOException e) {
            try {
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptHelper.unlock(this.threadWriteLock, this.processWriteLock);
                throw throwable;
            }
        }
        EncryptHelper.unlock(this.threadWriteLock, this.processWriteLock);
    }

    private void init() {
        this.keystorePath = AppProperties.get((String)"crypt_keystore");
        if (this.keystorePath == null || this.keystorePath.isEmpty()) {
            throw new AppRuntimeException("Error: crypt_keystore is empty or not config");
        }
        this.keystorePath = Util.toAbsolutePath(this.keystorePath);
        ProcessLocker processLock = ProcessLocker.getInstance(Util.getSecureHash(this.keystorePath) + ".plock");
        this.processWriteLock = processLock.getWriteLock();
        this.processReadLock = processLock.getReadLock();
        ReentrantReadWriteLock threadLock = new ReentrantReadWriteLock();
        this.threadReadLock = threadLock.readLock();
        this.threadWriteLock = threadLock.writeLock();
        this.createKeystoreFileIfNecessary();
        this.xmlDocOfKeystore = this.loadKeyStore();
    }

    private void createKeystoreFileIfNecessary() {
        if (this.hasValidKeyStoreFile()) {
            return;
        }
        try {
            this.threadWriteLock.lock();
            this.processWriteLock.lock();
            if (!this.hasValidKeyStoreFile()) {
                this.initEmptyKeyStore();
            }
        }
        catch (Throwable throwable) {
            EncryptHelper.unlock(this.threadWriteLock, this.processWriteLock);
            throw throwable;
        }
        EncryptHelper.unlock(this.threadWriteLock, this.processWriteLock);
    }

    private boolean hasValidKeyStoreFile() {
        File keystoreFile = FileUtils.getFile((String[])new String[]{this.keystorePath});
        return keystoreFile.exists() && keystoreFile.length() > 0L;
    }

    private Document initEmptyKeyStore() {
        try {
            EncryptHelper.createFile(FileUtils.getFile((String[])new String[]{this.keystorePath}));
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            docFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            docFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement("keystore");
            doc.appendChild(rootElement);
            Util.storeToXml((Node)doc, this.keystorePath);
            return doc;
        }
        catch (ParserConfigurationException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Document loadKeyStore() {
        Callable<Document> loadTask = new Callable<Document>(){

            @Override
            public Document call() throws Exception {
                return Util.loadFromXML(KeyStore.this.keystorePath);
            }
        };
        ExecutorService executor = null;
        this.threadWriteLock.lock();
        this.processReadLock.lock();
        executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable);
                thread.setDaemon(true);
                thread.setName("ErrHandleTask-execStrCmd-input");
                thread.setUncaughtExceptionHandler((thr, ex) -> {});
                return thread;
            }
        });
        Future<Document> future = executor.submit(loadTask);
        int timeout = AppProperties.getAsInt((String)PROP_KEYSTORE_LOAD_TIMEOUT, (int)10000);
        Document document = future.get(timeout, TimeUnit.MILLISECONDS);
        try {
            if (executor != null) {
                executor.shutdownNow();
            }
        }
        catch (Throwable throwable) {
            EncryptHelper.unlock(this.threadWriteLock, this.processReadLock);
            throw throwable;
        }
        EncryptHelper.unlock(this.threadWriteLock, this.processReadLock);
        return document;
        catch (Exception e) {
            try {
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    if (executor != null) {
                        executor.shutdownNow();
                    }
                }
                catch (Throwable throwable2) {
                    EncryptHelper.unlock(this.threadWriteLock, this.processReadLock);
                    throw throwable2;
                }
                EncryptHelper.unlock(this.threadWriteLock, this.processReadLock);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<WorkKey> loadKeysByStatus(KeyStatus status) {
        LinkedList<WorkKey> linkedList;
        LinkedList<WorkKey> allKeys = new LinkedList<WorkKey>();
        try {
            this.threadReadLock.lock();
            NodeList keyList = Util.searchByXPath(this.xmlDocOfKeystore, "//key");
            int size = keyList.getLength();
            for (int i = 0; i < size; ++i) {
                Node keyNode = keyList.item(i);
                String domainName = Util.getNodeAttr(keyNode.getParentNode(), "name");
                int type = Integer.parseInt(Util.getNodeAttr(keyNode, "type"));
                String valueXpath = this.getValueXPathByStatus(status);
                NodeList valueList = Util.searchByXPath(keyNode, valueXpath);
                int valueSize = valueList.getLength();
                for (int j = 0; j < valueSize; ++j) {
                    Node valueNode = valueList.item(j);
                    String id = Util.getNodeAttr(valueNode, "id");
                    long createTime = Long.parseLong(Util.getNodeAttr(valueNode, "createTime"));
                    boolean isActive = Boolean.valueOf(Util.getNodeAttr(valueNode, "active"));
                    String cipherValue = Util.getNodeValue(valueNode);
                    WorkKey key = new WorkKey(id, domainName, type, createTime, isActive, cipherValue.toCharArray());
                    allKeys.add(key);
                }
            }
            linkedList = allKeys;
        }
        catch (Throwable throwable) {
            EncryptHelper.threadUnlock(this.threadReadLock);
            throw throwable;
        }
        EncryptHelper.threadUnlock(this.threadReadLock);
        return linkedList;
    }

    private String getValueXPathByStatus(KeyStatus status) {
        String valueXpath = "value";
        switch (status) {
            case ACTIVE: {
                valueXpath = "value[@active='true']";
                break;
            }
            case INACTIVE: {
                valueXpath = "value[@active='false']";
                break;
            }
            case ALL_STATUS: {
                valueXpath = "value";
                break;
            }
        }
        return valueXpath;
    }

    private Node getDomainNode(String domain) {
        String xpath = "/keystore/domain[@name='DOMAIN_NAME']";
        xpath = xpath.replace("DOMAIN_NAME", domain);
        return (Node)Util.searchByXPath(this.xmlDocOfKeystore, xpath, XPathConstants.NODE);
    }

    private Node addDomainNode(String name) {
        Element domainNode = this.xmlDocOfKeystore.createElement("domain");
        domainNode.setAttribute("name", name);
        this.xmlDocOfKeystore.getDocumentElement().appendChild(domainNode);
        return domainNode;
    }

    private Node getKeyNode(Node domainNode, String type) {
        String xpath = "/keystore/domain[@name='DOMAIN_NAME']/key[@type='KEY_TYPE']";
        String domainName = Util.getNodeAttr(domainNode, "name");
        xpath = xpath.replace("DOMAIN_NAME", domainName);
        xpath = xpath.replace("KEY_TYPE", type);
        return (Node)Util.searchByXPath(domainNode, xpath, XPathConstants.NODE);
    }

    private Node addKeyNode(Node domainNode, String type) {
        Element keyNode = this.xmlDocOfKeystore.createElement("key");
        keyNode.setAttribute("type", type);
        domainNode.appendChild(keyNode);
        return keyNode;
    }

    private Node getActiveValueNode(Node keyNode) {
        String xpath = "/keystore/domain[@name='DOMAIN_NAME']/key[@type='KEY_TYPE']/value[@active='true']";
        Node domainNode = keyNode.getParentNode();
        String domainName = Util.getNodeAttr(domainNode, "name");
        String keyType = Util.getNodeAttr(keyNode, "type");
        xpath = xpath.replace("DOMAIN_NAME", domainName);
        xpath = xpath.replace("KEY_TYPE", keyType);
        return (Node)Util.searchByXPath(keyNode, xpath, XPathConstants.NODE);
    }

    private List<Node> getValueNodes(Node keyNode) {
        String xpath = "/keystore/domain[@name='DOMAIN_NAME']/key[@type='KEY_TYPE']/value";
        Node domainNode = keyNode.getParentNode();
        String domainName = Util.getNodeAttr(domainNode, "name");
        String keyType = Util.getNodeAttr(keyNode, "type");
        xpath = xpath.replace("DOMAIN_NAME", domainName);
        NodeList nodes = Util.searchByXPath(keyNode, xpath = xpath.replace("KEY_TYPE", keyType));
        int length = nodes.getLength();
        if (length == 0) {
            return Collections.emptyList();
        }
        ArrayList<Node> valueNodes = new ArrayList<Node>(length);
        for (int i = 0; i < length; ++i) {
            Node node = nodes.item(i);
            valueNodes.add(node);
        }
        return valueNodes;
    }

    private Node getValueNodeById(String id) {
        String xpath = "//value[@id='ID']";
        xpath = xpath.replace("ID", id);
        return (Node)Util.searchByXPath(this.xmlDocOfKeystore, xpath, XPathConstants.NODE);
    }

    private Node addValueNode(Node keyNode, String id, String createTime, String active, String cipherValue) {
        Element valueNode = this.xmlDocOfKeystore.createElement("value");
        valueNode.setAttribute("id", id);
        valueNode.setAttribute("createTime", createTime);
        valueNode.setAttribute("active", active);
        valueNode.setTextContent(cipherValue);
        keyNode.insertBefore(valueNode, keyNode.getFirstChild());
        return valueNode;
    }

    private Node updateValueNode(Node valueNode, String active, String cipherValue) {
        Element valueElement = (Element)valueNode;
        valueElement.setAttribute("active", active);
        valueElement.setTextContent(cipherValue);
        return valueNode;
    }

    private static enum KeyStatus {
        ACTIVE,
        INACTIVE,
        ALL_STATUS;

    }
}

