/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.crypt.Auditor;
import com.huawei.wcc.crypt.EncryptHelper;
import com.huawei.wcc.crypt.ReadLocker;
import com.huawei.wcc.crypt.Util;
import com.huawei.wcc.crypt.WriteLocker;
import com.huawei.wcc.framework.AppProperties;
import com.huawei.wcc.framework.AppRuntimeException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;

public class ProcessLocker {
    protected static final int RETRY_TIME = 3;
    private static final String DEFAULT_LOCKER_NAME_STRING = "_wcc_file_locker_";
    private static Map<String, ProcessLocker> instances = new ConcurrentHashMap<String, ProcessLocker>();
    private static final int READ_LOCK = 0;
    private static final int WRITE_LOCK = 1;
    private static final int LOCK_MAP_SIZE = 2;
    private static Map<String, ProcessLocker[]> lockerMap = new HashMap<String, ProcessLocker[]>();
    private static final String PROP_RUN_MODE = "crypt_run_mode";
    private static final String PROP_RUN_MODE_USER = "crypt_run_mode_user";
    private static final String PROP_RUN_MODE_GROUP = "crypt_run_mode_group";
    private static final String PROP_LOCK_DIR = "crypt_lock_dir";
    protected int count = 0;
    protected FileChannel fc = null;
    protected FileLock flocker = null;
    protected String lockName = null;
    protected RandomAccessFile lockRandomAccessFile = null;
    protected File lockFile = null;

    protected ProcessLocker(String lockFileName) throws AppRuntimeException {
        File lockDirFile;
        this.lockName = lockFileName;
        String lockDir = AppProperties.get((String)PROP_LOCK_DIR);
        if (lockDir == null || lockDir.isEmpty()) {
            lockDir = Util.getTempFilePath();
        }
        if (!(lockDirFile = FileUtils.getFile((String[])new String[]{lockDir = Util.toAbsolutePath(lockDir) + File.separator})).exists()) {
            lockDirFile.mkdirs();
        }
        this.lockFile = FileUtils.getFile((String[])new String[]{lockDir + this.lockName});
        if (!this.lockFile.exists()) {
            try {
                if (!this.lockFile.createNewFile()) {
                    throw new AppRuntimeException("failed to create lock file: " + this.lockName);
                }
            }
            catch (IOException e) {
                throw new AppRuntimeException((Throwable)e);
            }
        }
        this.setLockPermission();
    }

    public static synchronized ProcessLocker getInstance(String name) {
        ProcessLocker instance = instances.get(name);
        if (instance == null) {
            instance = new ProcessLocker(name);
            instances.put(name, instance);
        }
        return instance;
    }

    public static void unlock(ProcessLocker ... locks) {
        if (locks == null) {
            return;
        }
        for (ProcessLocker lock : locks) {
            try {
                if (lock == null) continue;
                lock.unlock();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public ProcessLocker getReadLock() {
        return this.getLock(0);
    }

    public ProcessLocker getWriteLock() {
        return this.getLock(1);
    }

    public synchronized void lock() throws AppRuntimeException {
        this.getWriteLock().lock();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void unlock() throws AppRuntimeException {
        block8: {
            block7: {
                if (this.flocker != null && this.fc != null && this.flocker.isValid()) break block7;
                this.count = 0;
                if (this.count != 0) return;
                EncryptHelper.close(this.fc, this.lockRandomAccessFile);
                return;
            }
            if (this.count != 0) break block8;
            if (this.count != 0) return;
            EncryptHelper.close(this.fc, this.lockRandomAccessFile);
            return;
        }
        try {
            --this.count;
            if (this.count == 0) {
                this.flocker.release();
            }
            if (this.count != 0) return;
        }
        catch (Exception e) {
            try {
                throw new AppRuntimeException("Unlock error(flocker) : " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                if (this.count != 0) throw throwable;
                EncryptHelper.close(this.fc, this.lockRandomAccessFile);
                throw throwable;
            }
        }
        EncryptHelper.close(this.fc, this.lockRandomAccessFile);
        return;
    }

    public static synchronized ProcessLocker getInstance() {
        return ProcessLocker.getInstance(DEFAULT_LOCKER_NAME_STRING);
    }

    private synchronized ProcessLocker getLock(int type) {
        ProcessLocker[] lockPair = lockerMap.get(this.lockName);
        if (lockPair == null) {
            lockPair = new ProcessLocker[]{new ReadLocker(this.lockName), new WriteLocker(this.lockName)};
            lockerMap.put(this.lockName, lockPair);
        }
        return lockPair[type];
    }

    private void setLockPermission() {
        if (EncryptHelper.isWindows()) {
            return;
        }
        String runMode = AppProperties.get((String)PROP_RUN_MODE, (String)"multigroup").toLowerCase(Locale.ROOT);
        String permission = "";
        if ("singleuser".equals(runMode)) {
            permission = "600";
        } else if ("singlegroup".equals(runMode)) {
            permission = "660";
        } else if ("multigroup".equals(runMode)) {
            permission = "666";
        } else {
            throw new AppRuntimeException("crypt_run_mode has wrong value,it should be singleuser, singlegroup or multigroup");
        }
        String user = AppProperties.get((String)PROP_RUN_MODE_USER);
        String group = AppProperties.get((String)PROP_RUN_MODE_GROUP);
        try {
            EncryptHelper.setFilePermission(this.lockFile, permission, user, group);
        }
        catch (IOException e) {
            Auditor.log("setLockPermission error", false, e);
        }
    }
}

