/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.crypt.Auditor;
import com.huawei.wcc.crypt.EncryptHelper;
import com.huawei.wcc.crypt.RootKeyComponent;
import com.huawei.wcc.crypt.RootKeyUpdateHandler;
import com.huawei.wcc.framework.AppProperties;
import com.huawei.wcc.framework.AppRuntimeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public final class RootKeyUpdater {
    protected static final String UPDATE_LOCKER = "update_lock";
    private static final String UPDATE_ENABLED = "crypt_rootkey_update_enabled";
    private static final String ROOTKEY_LIFETIME_DAYS = "crypt_rootkey_lifetime_days";
    private static final String ROOTKEY_LIFETIME_SECONDS = "crypt_rootkey_lifetime_seconds";
    private static final String UPDATE_HANDLER = "crypt_rootkey_update_handler";
    private static final long MIN_LIFETIME = 1L;
    private static final long BACKUP_FAIL = -1L;
    private static final long MS_OF_A_DAY = 86400000L;
    private static final long MS_OF_A_SECOND = 1000L;
    private static volatile RootKeyUpdater instance = null;
    private static boolean updating = false;
    private static Object updatingLocker = new Object();
    private boolean updateEnable;
    private long lifetime = Long.MAX_VALUE;
    private List<String> updateHandlerClass = new LinkedList<String>();

    private RootKeyUpdater() {
        this.updateEnable = AppProperties.getAsBoolean((String)UPDATE_ENABLED, (boolean)false);
        if (!this.updateEnable) {
            return;
        }
        this.lifetime = this.getLifeTime();
        this.addHandler(AppProperties.get((String)UPDATE_HANDLER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static RootKeyUpdater getInstance() {
        if (instance != null) return instance;
        Class<RootKeyUpdater> clazz = RootKeyUpdater.class;
        synchronized (RootKeyUpdater.class) {
            if (instance != null) return instance;
            instance = new RootKeyUpdater();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isUpdating() {
        Object object = updatingLocker;
        synchronized (object) {
            return updating;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setUpdating(boolean isUpdating) {
        Object object = updatingLocker;
        synchronized (object) {
            updating = isUpdating;
        }
    }

    protected boolean needUpdate() {
        long keyGenTime;
        if (!this.updateEnable) {
            return false;
        }
        if (RootKeyUpdater.isUpdating()) {
            return false;
        }
        long current = System.currentTimeMillis();
        return current - (keyGenTime = RootKeyComponent.currentTimeStamp()) > this.lifetime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doUpdate() {
        if (!this.updateEnable) {
            return false;
        }
        String[] rkcPaths = RootKeyComponent.getRKCPaths();
        if (rkcPaths.length == 0) {
            return false;
        }
        long backupStamp = this.backupRKC(rkcPaths);
        if (backupStamp == -1L) {
            Auditor.log("Update Root Key", false, "backup rkc fail");
            return false;
        }
        try {
            RootKeyUpdater.setUpdating(true);
            LinkedList<RootKeyUpdateHandler> handlers = new LinkedList<RootKeyUpdateHandler>();
            List<String> list = this.updateHandlerClass;
            synchronized (list) {
                for (String handlerClass : this.updateHandlerClass) {
                    handlers.add(this.newHandler(handlerClass));
                }
            }
            for (RootKeyUpdateHandler handler : handlers) {
                if (handler == null || handler.doBeforeUpdate()) continue;
                Auditor.log("Update Root Key", false, handler.getClass().getName() + ".doBeforeUpdate return false");
                boolean bl = false;
                return bl;
            }
            int rkcNum = rkcPaths.length;
            RootKeyComponent[] rkcs = RootKeyComponent.generateBatch(rkcNum);
            RootKeyComponent.saveBatch(rkcs, rkcPaths);
            for (RootKeyUpdateHandler handler : handlers) {
                if (handler == null || handler.doAfterUpdate()) continue;
                Auditor.log("Update Root Key", false, handler.getClass().getName() + ".doAfterUpdate return false");
                throw new AppRuntimeException("doAfterUpdate Error");
            }
        }
        catch (Exception e) {
            Auditor.log("Update Root Key", false, e);
            boolean bl = this.restoreRKC(rkcPaths, backupStamp);
            return bl;
        }
        finally {
            RootKeyUpdater.setUpdating(false);
        }
        Auditor.log("Update Root Key", true);
        return true;
    }

    protected RootKeyComponent[] getOldRKCS(long stamp) {
        String[] paths = RootKeyComponent.getRKCPaths();
        if (paths.length == 0) {
            throw new AppRuntimeException("getOldRKCS error: getRKCPaths returns null/empty");
        }
        int size = paths.length;
        RootKeyComponent[] rkcs = new RootKeyComponent[size];
        for (int i = 0; i < size; ++i) {
            paths[i] = paths[i] + "." + stamp;
            try {
                rkcs[i] = new RootKeyComponent(FileUtils.getFile((String[])new String[]{paths[i]}));
                continue;
            }
            catch (FileNotFoundException e) {
                rkcs = null;
                break;
            }
        }
        return rkcs;
    }

    private long backupRKC(String[] rkcPaths) {
        long stamp;
        if (rkcPaths == null) {
            return -1L;
        }
        try {
            stamp = new RootKeyComponent(FileUtils.getFile((String[])new String[]{rkcPaths[0]})).getTimeStamp();
        }
        catch (FileNotFoundException e) {
            throw new AppRuntimeException("rkcPaths[0] Not Found");
        }
        for (String path : rkcPaths) {
            EncryptHelper.copyFile(FileUtils.getFile((String[])new String[]{path}), FileUtils.getFile((String[])new String[]{path + "." + stamp}));
        }
        return stamp;
    }

    private boolean restoreRKC(String[] rkcPaths, long timeStamp) {
        if (rkcPaths == null) {
            return false;
        }
        try {
            for (String path : rkcPaths) {
                EncryptHelper.copyFile(new File(path + "." + timeStamp), new File(path));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private long getLifeTime() {
        try {
            long time;
            String value = AppProperties.get((String)ROOTKEY_LIFETIME_SECONDS);
            if (value != null) {
                time = Long.parseLong(value);
                if (time < 1L) {
                    this.updateEnable = false;
                    time = Long.MAX_VALUE;
                } else {
                    time *= 1000L;
                }
            } else {
                value = AppProperties.get((String)ROOTKEY_LIFETIME_DAYS);
                if (value == null) {
                    this.updateEnable = false;
                    return Long.MAX_VALUE;
                }
                time = Long.parseLong(value);
                if (time < 1L) {
                    this.updateEnable = false;
                    time = Long.MAX_VALUE;
                } else {
                    time *= 86400000L;
                }
            }
            return time;
        }
        catch (Exception e) {
            throw new AppRuntimeException("[crypt_rootkey_lifetime_*] config error", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addHandler(String handlerClasses) {
        if (handlerClasses == null || handlerClasses.isEmpty()) {
            return;
        }
        String[] handlers = handlerClasses.split(";");
        List<String> list = this.updateHandlerClass;
        synchronized (list) {
            for (String handler : handlers) {
                if (this.updateHandlerClass.contains(handler)) continue;
                this.updateHandlerClass.add(handler);
            }
        }
    }

    private RootKeyUpdateHandler newHandler(String className) {
        try {
            Class<?> handlerClass = Class.forName(className);
            return (RootKeyUpdateHandler)handlerClass.newInstance();
        }
        catch (Exception e) {
            throw new AppRuntimeException("Update Handler " + className + " Not Found, will not update", (Throwable)e);
        }
    }
}

