/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.wcc.crypt.EncryptHelper;
import com.huawei.wcc.framework.AppProperties;
import com.huawei.wcc.framework.AppRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Locale;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class Util {
    private static final int SIZE_4_KB = 4096;

    public static Document loadFromXML(String file) {
        Document document;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        ByteArrayInputStream in = null;
        try {
            factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            String content = Util.readFile(file);
            in = new ByteArrayInputStream(content.getBytes("UTF-8"));
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(in);
        }
        catch (Exception e) {
            try {
                throw new AppRuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                EncryptHelper.close(in);
                throw throwable;
            }
        }
        EncryptHelper.close(in);
        return document;
    }

    public static boolean storeToXml(Node doc, OutputStream out) {
        DOMImplementationRegistry registry;
        try {
            registry = DOMImplementationRegistry.newInstance();
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        DOMImplementationLS impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        if (impl == null) {
            throw new AppRuntimeException("getDOMImplementation(\"LS\") returns null");
        }
        LSSerializer writer = impl.createLSSerializer();
        writer.getDomConfig().setParameter("format-pretty-print", Boolean.TRUE);
        LSOutput output = impl.createLSOutput();
        output.setByteStream(out);
        return writer.write(doc, output);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean storeToXml(Node doc, String filePath) {
        boolean bl;
        block9: {
            File file;
            FileOutputStream out;
            block7: {
                boolean bl2;
                block8: {
                    out = null;
                    file = FileUtils.getFile((String[])new String[]{filePath});
                    if (file.exists() || file.createNewFile()) break block7;
                    bl2 = false;
                    if (out == null) break block8;
                    EncryptHelper.close(out);
                }
                return bl2;
            }
            try {
                out = FileUtils.openOutputStream((File)file);
                bl = Util.storeToXml(doc, out);
                if (out == null) break block9;
            }
            catch (FileNotFoundException e) {
                try {
                    throw new AppRuntimeException("file not found");
                    catch (IOException e2) {
                        throw new AppRuntimeException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (out != null) {
                        EncryptHelper.close(out);
                    }
                    throw throwable;
                }
            }
            EncryptHelper.close(out);
        }
        return bl;
    }

    public static NodeList searchByXPath(Node doc, String xpath) {
        return (NodeList)Util.searchByXPath(doc, xpath, XPathConstants.NODESET);
    }

    public static Object searchByXPath(Node doc, String xpath, QName returnType) {
        XPath xp = XPathFactory.newInstance().newXPath();
        XPathExpression expression = null;
        try {
            expression = xp.compile(xpath);
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
        Class<Util> clazz = Util.class;
        synchronized (Util.class) {
            try {
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return expression.evaluate(doc, returnType);
            }
            catch (XPathExpressionException e) {
                throw new AppRuntimeException((Throwable)e);
            }
        }
    }

    public static String getNodeAttr(Node node, String attrName) {
        String attrValue = null;
        NamedNodeMap attrs = node.getAttributes();
        int size = attrs.getLength();
        for (int i = 0; i < size; ++i) {
            Node attr = attrs.item(i);
            if (!attr.getNodeName().equals(attrName)) continue;
            attrValue = attr.getNodeValue();
            break;
        }
        return attrValue;
    }

    public static String getNodeValue(Node node) {
        return node.getTextContent();
    }

    public static String getSecureHash(String content) {
        if (content == null) {
            return null;
        }
        try {
            byte[] bytes = content.getBytes(StandardCharsets.UTF_8);
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] result = digest.digest(bytes);
            return EncryptHelper.parseByte2HexStr(result);
        }
        catch (Exception e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    public static byte[] getRandom(int length) throws AppRuntimeException {
        try {
            if (length <= 0) {
                throw new AppRuntimeException("length must bigger than 0");
            }
            byte[] random = new byte[length];
            SecureRandom rand = SecureRandomFactory.getInstanceStrongWithDRBG();
            rand.nextBytes(random);
            return random;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AppRuntimeException((Throwable)e);
        }
    }

    public static String toAbsolutePath(String path) {
        if (path == null || path.isEmpty()) {
            return null;
        }
        File file = FileUtils.getFile((String[])new String[]{path});
        if (file.isAbsolute()) {
            return path;
        }
        if (AppProperties.getAsBoolean((String)"crypt_enable_user_dir", (boolean)false)) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException e) {
                throw new AppRuntimeException((Throwable)e);
            }
        }
        return AppProperties.getAppHome() + "/" + path;
    }

    /*
     * Exception decompiling
     */
    public static String readFile(String fileName) throws AppRuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void deleteFile(String filePath) {
        File file = new File(filePath);
        if (!file.delete()) {
            throw new AppRuntimeException("failed to delete file");
        }
    }

    public static String getTempFilePath() {
        String os = System.getProperty("os.name");
        if (os != null && !os.isEmpty() && os.toLowerCase(Locale.ENGLISH).contains("linux")) {
            return "/opt/wcc";
        }
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("_wcc_test_", null);
            File parentFile = tmpFile.getParentFile();
            if (parentFile == null) {
                throw new AppRuntimeException("does not name a parent directory");
            }
            String string = parentFile.getCanonicalPath() + "/";
            return string;
        }
        catch (IOException e) {
            throw new AppRuntimeException("getTmpDir Error");
        }
        finally {
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
        }
    }
}

