/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.crypt;

import com.huawei.wcc.crypt.Auditor;
import com.huawei.wcc.crypt.Crypter;
import com.huawei.wcc.crypt.CrypterFactory;
import com.huawei.wcc.crypt.Domain;
import com.huawei.wcc.crypt.EncryptHelper;
import com.huawei.wcc.crypt.KeyStore;
import com.huawei.wcc.crypt.KeyUpdateHandler;
import com.huawei.wcc.crypt.RKUpdateHandler;
import com.huawei.wcc.crypt.RootKeyUpdater;
import com.huawei.wcc.crypt.Util;
import com.huawei.wcc.framework.AppRuntimeException;
import java.io.Serializable;
import java.util.UUID;

class WorkKey
implements Cloneable,
Serializable {
    public static final int NUM_OF_TYPE = 2;
    private static final long serialVersionUID = -3912557748152455602L;
    private static final int PLAIN_KEY_LENGTH = 128;
    private String id = "";
    private Domain domain;
    private int type;
    private long createTime;
    private boolean active;
    private char[] value;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkKey(String domainName, int type) {
        String uuid = UUID.randomUUID().toString();
        long time = System.currentTimeMillis();
        boolean isActive = true;
        char[] plainValue = null;
        char[] cipher = null;
        try {
            plainValue = EncryptHelper.parseByte2HexChars(Util.getRandom(128));
            cipher = this.encrypt(plainValue);
        }
        finally {
            Crypter.erase(plainValue);
        }
        this.init(uuid, domainName, type, time, isActive, cipher);
    }

    public WorkKey(String domainName, int type, char[] value) {
        if (value == null || value.length < 128) {
            Auditor.log("the value length is error.", false, "WorkKey fail");
            throw new AppRuntimeException("WorkKey fail");
        }
        String uuid = UUID.randomUUID().toString();
        long time = System.currentTimeMillis();
        this.init(uuid, domainName, type, time, true, this.encrypt(value));
    }

    public WorkKey(String id, String domainName, int type, long createTime, boolean active, char[] value) {
        this.init(id, domainName, type, createTime, active, value);
    }

    public char[] getPlainKey() {
        return this.decrypt();
    }

    public boolean update() {
        return this.update(null);
    }

    private boolean update(String value) {
        boolean isSuccess = false;
        try {
            KeyUpdateHandler handler = this.domain.getUpdateHandler();
            if (handler != null && !(isSuccess = handler.doBeforeUpdate(this.domain.getName()))) {
                Auditor.log("Update WorkKey, id = " + this.getId(), false, "doBeforeUpdate fail");
                return false;
            }
            this.active = false;
            KeyStore keyStore = KeyStore.getInstance();
            keyStore.save(this);
            WorkKey newKey = value == null || value.trim().isEmpty() ? new WorkKey(this.domain.getName(), this.type) : new WorkKey(this.domain.getName(), this.type, value.toCharArray());
            isSuccess = keyStore.save(newKey);
            if (!isSuccess) {
                Auditor.log("Update WorkKey, id = " + newKey.getId(), false, "save key fail");
                return false;
            }
            if (handler != null && !(isSuccess = handler.doAfterUpdate(this.domain.getName()))) {
                Auditor.log("Update WorkKey, id = " + newKey.getId(), false, "doAfterUpdate fail");
                return false;
            }
            this.id = newKey.id;
            this.active = newKey.active;
            this.value = newKey.value;
            this.createTime = newKey.createTime;
            Auditor.log("Update WorkKey, id = " + newKey.getId(), true);
        }
        catch (Exception e) {
            Auditor.log("Update WorkKey, id = " + this.getId(), false, e);
        }
        return isSuccess;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public char[] getValue() {
        return this.value;
    }

    public void setValue(char[] value) {
        this.value = value;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private char[] encrypt(char[] plainValue) {
        Crypter crypter = CrypterFactory.getCrypter();
        return crypter.encryptByRootKey(plainValue);
    }

    private char[] decrypt() {
        Crypter crypter = CrypterFactory.getCrypter();
        return crypter.decryptByRootKey(this.value);
    }

    private void init(String id, String domainName, int type, long createTime, boolean active, char[] value) {
        this.id = id;
        this.domain = Domain.getByName(domainName);
        this.type = type;
        this.createTime = createTime;
        this.active = active;
        this.value = value;
        RootKeyUpdater.getInstance().addHandler(RKUpdateHandler.class.getName());
    }
}

