/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.wcc.framework;

import com.huawei.wcc.framework.AppContext;
import com.huawei.wcc.framework.AppRuntimeException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public final class AppProperties {
    private static Properties appPpt = new Properties();

    public static void load() {
        InputStream in = AppProperties.searchProp();
        if (in == null) {
            return;
        }
        try {
            appPpt.load(in);
        }
        catch (IOException e) {
            throw new AppRuntimeException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                AppProperties.nop();
            }
        }
    }

    public static void clear() {
        appPpt.clear();
    }

    public static int getAsInt(String key, int defaultValue) {
        String val = AppProperties.get(key);
        if (val == null || val.length() == 0) {
            return defaultValue;
        }
        return Integer.parseInt(val.trim());
    }

    public static Properties getProperties() {
        return appPpt;
    }

    public static String get(String key) {
        return appPpt.getProperty(key);
    }

    public static String get(String key, String defaultValue) {
        String val = AppProperties.get(key);
        if (val == null) {
            return defaultValue;
        }
        return val;
    }

    public static boolean getAsBoolean(String key, boolean defaultValue) {
        String val = AppProperties.get(key);
        if (val == null || val.length() == 0) {
            return defaultValue;
        }
        return Boolean.parseBoolean(val.trim());
    }

    public static String getAppHome() {
        return AppContext.getInstance().getAppHome();
    }

    private static InputStream searchProp() {
        InputStream result = null;
        String filePath = AppProperties.getAppHome();
        String filenamePath = filePath.trim().length() > 0 ? filePath + "application.properties" : "config/application.properties";
        File file = FileUtils.getFile((String[])new String[]{filenamePath});
        if (file.exists()) {
            try {
                result = FileUtils.openInputStream((File)file);
            }
            catch (FileNotFoundException e) {
                AppProperties.systemErr("Exception: [application.properties] not found");
            }
            catch (Exception ex) {
                AppProperties.nop();
            }
        } else {
            try {
                result = AppProperties.getResAsStream(filenamePath);
            }
            catch (IOException e) {
                AppProperties.nop();
            }
        }
        return result;
    }

    private static void systemErr(String info) {
        PrintStream ps = System.err;
        ps.println(info);
    }

    private static void nop() {
    }

    private static InputStream getResAsStream(String resource) throws IOException {
        return AppProperties.getResAsStream(Thread.currentThread().getContextClassLoader(), resource);
    }

    private static InputStream getResAsStream(ClassLoader loader, String resource) throws IOException {
        InputStream in = null;
        if (loader != null) {
            in = loader.getResourceAsStream(resource);
        }
        if (in == null) {
            in = ClassLoader.getSystemResourceAsStream(resource);
        }
        if (in == null) {
            URL url = new URL(resource);
            in = url.openStream();
        }
        return in;
    }

    static {
        AppProperties.load();
    }
}

