/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.aamonitor.sdk;

import com.huawei.aamonitor.util.etcd.AAMEtcdClient;
import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.util.JSONObject;
import com.huawei.jetcd.client.EtcdConfig;
import com.huawei.jetcd.exception.EtcdException;
import com.huawei.jetcd.exception.EtcdServerException;
import com.huawei.jetcd.model.EtcdResult;

public class AAMonitorClient {
    private AAMEtcdClient etcdClient;

    public AAMonitorClient(EtcdConfig etcdConfig) {
        this(etcdConfig, Boolean.TRUE, Boolean.FALSE);
    }

    public AAMonitorClient(EtcdConfig etcdConfig, boolean isHttpsMode) {
        this(etcdConfig, isHttpsMode, Boolean.FALSE);
    }

    public AAMonitorClient(EtcdConfig etcdConfig, boolean isHttpsMode, boolean isForceCheckCert) {
        this.etcdClient = new AAMEtcdClient(etcdConfig);
        this.etcdClient.setHttpsMode(isHttpsMode);
        this.etcdClient.setForceCheckCert(isForceCheckCert);
    }

    public boolean listDir(JSONObject certAuthResult) throws Exception {
        try {
            this.etcdClient.dirExist(certAuthResult);
        }
        catch (Exception e) {
            LogManager.error("list dir error, cause by " + LogManager.getErrorMessage(e));
            throw e;
        }
        return true;
    }

    public boolean connect(JSONObject certAuthResult) throws Exception {
        return this.etcdClient.connect(certAuthResult);
    }

    public String getDetailStatus(String dcSerial) throws EtcdException {
        String status = "ok";
        try {
            EtcdResult result = this.etcdClient.get("/monitor/status/" + dcSerial + "/detail_status");
            status = result.getNode().getValue();
        }
        catch (EtcdServerException e) {
            LogManager.error("getDetailStatus failed. dcSerial:" + dcSerial + ", errorCode=" + e.getErrorCode() + ", " + LogManager.getErrorMessage(e));
            if (e.getErrorCode() == 100) {
                LogManager.error("the dcSerial:" + dcSerial + " not found in etcd, throw exception.");
                throw e;
            }
            throw e;
        }
        return status;
    }

    public void close() {
        if (null != this.etcdClient) {
            this.etcdClient.close();
            this.etcdClient = null;
        }
    }
}

