/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.aamonitor.util.etcd;

import com.huawei.ism.drm.arbitration.log.LogManager;
import com.huawei.ism.drm.arbitration.security.ArbX509TrustManager;
import com.huawei.ism.drm.arbitration.util.JSONObject;
import com.huawei.ism.drm.arbitration.util.VerifyUtil;
import com.huawei.ism.drm.wcc.rest.security.SecureRandomFactory;
import com.huawei.jetcd.client.EtcdConfig;
import com.huawei.jetcd.client.IClient;
import com.huawei.jetcd.client.impl.ClientImpl;
import com.huawei.jetcd.exception.EtcdException;
import com.huawei.jetcd.exception.EtcdServerException;
import com.huawei.jetcd.model.EtcdResult;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class AAMEtcdClient {
    private IClient etcdClient;
    private boolean httpsMode = false;
    private EtcdConfig etcdConfig = null;
    private boolean isForceCheckCert = Boolean.FALSE;

    public AAMEtcdClient(EtcdConfig etcdConfig) {
        this.setEtcdConfig(etcdConfig);
    }

    public boolean connect(JSONObject certAuthResult) throws Exception {
        return this.connectEtcd(certAuthResult);
    }

    private boolean connectEtcd(JSONObject certAuthResult) throws Exception {
        try {
            this.creatEtcdClient(certAuthResult);
            if (!VerifyUtil.isEmpty(this.etcdClient.version())) {
                LogManager.info("AAMonitorClient connect OK.");
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LogManager.info("AAMonitorClient connect failed." + LogManager.getErrorMessage(e));
            throw e;
        }
    }

    private void creatEtcdClient(JSONObject certAuthResult) throws NoSuchAlgorithmException, KeyManagementException, EtcdServerException {
        if (this.isHttpsMode()) {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.getX509TrustManager(certAuthResult)}, SecureRandomFactory.getInstanceStrongWithDRBG());
            this.etcdClient = new ClientImpl(this.etcdConfig, (SslContext)new JdkSslContext(sslContext, true, ClientAuth.NONE));
        } else {
            this.etcdClient = new ClientImpl(this.etcdConfig);
        }
    }

    private X509TrustManager getX509TrustManager(JSONObject certAuthResult) throws EtcdServerException {
        Object x509TrustManager = null;
        try {
            LogManager.info("cert auth start");
            x509TrustManager = new ArbX509TrustManager(this.etcdConfig, this.isForceCheckCert());
            certAuthResult.put("cert_auth_flag", (Object)true);
        }
        catch (Throwable e) {
            LogManager.error("cert auth failed, " + LogManager.getErrorMessage(e));
            if (VerifyUtil.isEmpty(certAuthResult.get("cert_auth_flag"))) {
                throw new EtcdServerException(207);
            }
            x509TrustManager = new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return new X509Certificate[0];
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            };
            certAuthResult.put("cert_auth_flag", (Object)false);
        }
        return x509TrustManager;
    }

    public boolean reconnect(EtcdConfig newEtcdConfig, JSONObject certAuthResult) throws Exception {
        try {
            if (null != this.etcdClient) {
                this.etcdClient.close();
                this.etcdClient = null;
            }
        }
        catch (IOException e) {
            LogManager.warn("IOExcetion when close etcdClient.");
            this.etcdClient = null;
        }
        this.setEtcdConfig(newEtcdConfig);
        return this.connect(certAuthResult);
    }

    public boolean reconnect(JSONObject certAuthResult) throws Exception {
        try {
            if (null != this.etcdClient) {
                this.etcdClient.close();
                this.etcdClient = null;
            }
        }
        catch (IOException e) {
            LogManager.warn("IOExcetion when close etcdClient.");
            this.etcdClient = null;
        }
        return this.connect(certAuthResult);
    }

    public void close() {
        try {
            if (null != this.etcdClient) {
                this.etcdClient.close();
                this.etcdClient = null;
            }
            LogManager.info("success close etcClient");
        }
        catch (IOException e) {
            LogManager.warn("IOExcetion when close etcdClient.");
            this.etcdClient = null;
        }
        this.setEtcdConfig(null);
    }

    public EtcdResult get(String key) throws EtcdException {
        return this.etcdClient.get(key);
    }

    public boolean dirExist(JSONObject certAuthResult) throws Exception {
        try {
            this.creatEtcdClient(certAuthResult);
            this.etcdClient.listDir("/monitor/status/");
        }
        catch (Exception e) {
            LogManager.error("list Dir failed, cause by " + LogManager.getErrorMessage(e));
            throw e;
        }
        return true;
    }

    public boolean keyExist(String key) throws EtcdException {
        try {
            this.etcdClient.get(key);
        }
        catch (EtcdServerException e) {
            if (e.getErrorCode() == 100) {
                return false;
            }
            throw e;
        }
        return true;
    }

    public boolean isHttpsMode() {
        return this.httpsMode;
    }

    public void setHttpsMode(boolean httpsMode) {
        this.httpsMode = httpsMode;
    }

    public EtcdConfig getEtcdConfig() {
        return this.etcdConfig;
    }

    public void setEtcdConfig(EtcdConfig etcdConfig) {
        this.etcdConfig = etcdConfig;
    }

    public boolean isForceCheckCert() {
        return this.isForceCheckCert;
    }

    public void setForceCheckCert(boolean isForceCheckCert) {
        this.isForceCheckCert = isForceCheckCert;
    }
}

